/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Collections;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, cyclesRationale="Backedge jmp", size=NodeSize.SIZE_1, sizeRationale="Backedge jmp")
public final class LoopEndNode
extends AbstractEndNode {
    public static final NodeClass<LoopEndNode> TYPE = NodeClass.create(LoopEndNode.class);
    @Node.Input(value=InputType.Association)
    AbstractBeginNode loopBegin;
    protected int endIndex;
    boolean canSafepoint;
    boolean canGuestSafepoint;

    public LoopEndNode(LoopBeginNode begin) {
        super((NodeClass<? extends AbstractEndNode>)TYPE);
        int idx = begin.nextEndIndex();
        assert (NumUtil.assertNonNegativeInt(idx));
        this.endIndex = idx;
        this.loopBegin = begin;
        this.canSafepoint = begin.canEndsSafepoint();
        this.canGuestSafepoint = begin.canEndsGuestSafepoint();
    }

    @Override
    public AbstractMergeNode merge() {
        return this.loopBegin();
    }

    public LoopBeginNode loopBegin() {
        return (LoopBeginNode)this.loopBegin;
    }

    public void setLoopBegin(LoopBeginNode x) {
        this.updateUsages(this.loopBegin, x);
        this.loopBegin = x;
    }

    public void disableSafepoint() {
        this.canSafepoint = false;
    }

    public void disableGuestSafepoint() {
        this.canGuestSafepoint = false;
    }

    public boolean canGuestSafepoint() {
        assert (!this.canGuestSafepoint || this.loopBegin().canEndsGuestSafepoint()) : "When safepoints are disabled for loop begin, safepoints must be disabled for all loop ends";
        return this.canGuestSafepoint;
    }

    public boolean canSafepoint() {
        assert (!this.canSafepoint || this.loopBegin().canEndsSafepoint()) : "When safepoints are disabled for loop begin, safepoints must be disabled for all loop ends";
        return this.canSafepoint;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.visitLoopEnd(this);
        super.generate(gen);
    }

    @Override
    public boolean verifyNode() {
        this.assertTrue(this.loopBegin != null, "must have a loop begin", new Object[0]);
        this.assertTrue(this.hasNoUsages(), "LoopEnds can not be used", new Object[0]);
        return super.verifyNode();
    }

    int endIndex() {
        return this.endIndex;
    }

    void setEndIndex(int idx) {
        this.endIndex = idx;
    }

    @Override
    public Iterable<? extends Node> cfgSuccessors() {
        return Collections.emptyList();
    }

    @Override
    public NodeCycles estimatedNodeCycles() {
        if (!(this.loopBegin instanceof LoopBeginNode) || this.loopBegin() == null) {
            return NodeCycles.CYCLES_UNKNOWN;
        }
        if (this.canSafepoint()) {
            return NodeCycles.CYCLES_2;
        }
        return super.estimatedNodeCycles();
    }

    @Override
    protected NodeSize dynamicNodeSizeEstimate() {
        if (!(this.loopBegin instanceof LoopBeginNode)) {
            return NodeSize.SIZE_UNKNOWN;
        }
        if (this.canSafepoint()) {
            return NodeSize.SIZE_2;
        }
        return super.dynamicNodeSizeEstimate();
    }
}

