/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.GuardPhiNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;

@NodeInfo(allowedUsageTypes={InputType.Guard}, nameTemplate="GuardProxy({i#value})")
public final class GuardProxyNode
extends ProxyNode
implements GuardingNode {
    public static final NodeClass<GuardProxyNode> TYPE = NodeClass.create(GuardProxyNode.class);
    @Node.OptionalInput(value=InputType.Guard)
    GuardingNode value;

    public GuardProxyNode(GuardingNode value, LoopExitNode proxyPoint) {
        super(TYPE, StampFactory.forVoid(), proxyPoint);
        this.value = value;
    }

    @Override
    public ValueNode value() {
        return this.value == null ? null : this.value.asNode();
    }

    @Override
    public PhiNode createPhi(AbstractMergeNode merge) {
        return this.graph().addWithoutUnique(new GuardPhiNode(merge));
    }

    @Override
    public ProxyNode duplicateOn(LoopExitNode newProxyPoint, ValueNode newOriginalNode) {
        assert (newOriginalNode instanceof GuardingNode) : Assertions.errorMessageContext("this", this, "newOriginalNode", newOriginalNode);
        return this.graph().addWithoutUnique(new GuardProxyNode((GuardingNode)((Object)newOriginalNode), newProxyPoint));
    }
}

