/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.Fields;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.util.TypeReader;
import jdk.graal.compiler.core.common.util.UnsafeArrayTypeReader;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.graph.Edges;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.InputEdges;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.graph.NodeSuccessorList;
import jdk.graal.compiler.graph.SuccessorEdges;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.DeoptimizingGuard;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.InliningLog;
import jdk.graal.compiler.nodes.InliningLogCodec;
import jdk.graal.compiler.nodes.Invokable;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopDetector;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.OptimizationLog;
import jdk.graal.compiler.nodes.OptimizationLogCodec;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.extended.SwitchNode;
import jdk.graal.compiler.nodes.graphbuilderconf.LoopExplosionPlugin;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.nodes.MethodHandleWithExceptionNode;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.Pair;

public class GraphDecoder {
    private static final TimerKey MakeSuccessorStubsTimer = DebugContext.timer("PartialEvaluation-MakeSuccessorStubs").doc("Time spent in making successor stubs for the PE.");
    private static final TimerKey ReadPropertiesTimer = DebugContext.timer("PartialEvaluation-ReadProperties").doc("Time spent in reading node properties in the PE.");
    protected final Architecture architecture;
    protected final StructuredGraph graph;
    protected final OptionValues options;
    protected final DebugContext debug;
    private final EconomicMap<NodeClass<?>, ArrayDeque<Node>> reusableFloatingNodes;
    public static final boolean DUMP_DURING_FIXED_NODE_PROCESSING = false;

    public GraphDecoder(Architecture architecture, StructuredGraph graph) {
        this.architecture = architecture;
        this.graph = graph;
        this.options = graph.getOptions();
        this.debug = graph.getDebug();
        this.reusableFloatingNodes = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
    }

    public final void decode(EncodedGraph encodedGraph) {
        this.decode(encodedGraph, null);
    }

    public final void decode(EncodedGraph encodedGraph, Iterable<EncodedGraph.EncodedNodeReference> nodeReferences) {
        try (DebugContext.Scope scope = this.debug.scope((Object)"GraphDecoder", this.graph);){
            this.recordGraphElements(encodedGraph);
            MethodScope methodScope = new MethodScope(null, this.graph, encodedGraph, LoopExplosionPlugin.LoopExplosionKind.NONE);
            LoopScope loopScope = this.createInitialLoopScope(methodScope, null);
            this.decode(loopScope);
            this.cleanupGraph(methodScope);
            assert (this.graph.verify());
            if (nodeReferences != null) {
                for (EncodedGraph.EncodedNodeReference nodeReference : nodeReferences) {
                    if (nodeReference.orderId < 0) {
                        throw GraalError.shouldNotReachHere("EncodeNodeReference is not in 'encoded' state");
                    }
                    nodeReference.node = loopScope.createdNodes[nodeReference.orderId];
                    if (nodeReference.node == null || !nodeReference.node.isAlive()) {
                        throw GraalError.shouldNotReachHere("Could not decode the EncodedNodeReference");
                    }
                    nodeReference.orderId = -1;
                }
            }
            this.graph.maybeMarkUnsafeAccess(encodedGraph);
        }
        catch (Throwable ex) {
            this.debug.handle(ex);
        }
    }

    protected void recordGraphElements(EncodedGraph encodedGraph) {
        List<ResolvedJavaMethod> inlinedMethods = encodedGraph.getInlinedMethods();
        if (inlinedMethods != null) {
            for (ResolvedJavaMethod other : inlinedMethods) {
                this.graph.recordMethod(other);
            }
        }
        Assumptions assumptions = this.graph.getAssumptions();
        Assumptions inlinedAssumptions = encodedGraph.getAssumptions();
        if (assumptions != null) {
            if (inlinedAssumptions != null) {
                assumptions.record(inlinedAssumptions);
            }
        } else assert (inlinedAssumptions == null) : String.format("cannot inline graph (%s) which makes assumptions into a graph (%s) that doesn't", encodedGraph, this.graph);
        this.graph.maybeMarkUnsafeAccess(encodedGraph);
    }

    protected final LoopScope createInitialLoopScope(MethodScope methodScope, FixedWithNextNode startNode) {
        LoopScope loopScope = new LoopScope(methodScope);
        if (startNode != null) {
            this.registerNode(loopScope, 1, AbstractBeginNode.prevBegin(startNode), false, false);
            FixedNode firstNode = this.makeStubNode(methodScope, loopScope, 2);
            startNode.setNext(firstNode);
            loopScope.nodesToProcess.set(2);
        } else {
            StartNode firstNode = this.graph.start();
            this.registerNode(loopScope, 1, firstNode, false, false);
            loopScope.nodesToProcess.set(1);
        }
        return loopScope;
    }

    protected final void decode(LoopScope initialLoopScope) {
        initialLoopScope.methodScope.replaceLogsForDecodedGraph();
        try (InliningLog.UpdateScope updateScope = InliningLog.openDefaultUpdateScope(this.graph.getInliningLog());){
            LoopScope loopScope = initialLoopScope;
            while (loopScope != null) {
                MethodScope methodScope = loopScope.methodScope;
                while (loopScope != null) {
                    while (!loopScope.nodesToProcess.isEmpty()) {
                        loopScope = this.processNextNode(methodScope, loopScope);
                        methodScope = loopScope.methodScope;
                    }
                    if (loopScope.hasIterationsToProcess()) {
                        loopScope = loopScope.getNextIterationToProcess(true);
                        continue;
                    }
                    GraphDecoder.propagateCreatedNodes(loopScope);
                    loopScope = loopScope.outer;
                    if (loopScope != null) continue;
                    this.afterMethodScope(methodScope);
                }
                if (methodScope.loopExplosion.mergeLoops()) {
                    LoopDetector loopDetector = new LoopDetector(this.graph, methodScope);
                    loopDetector.run();
                }
                if (methodScope.isInlinedMethod()) {
                    this.finishInlining(methodScope);
                }
                loopScope = methodScope.callerLoopScope;
            }
        }
    }

    protected void afterMethodScope(MethodScope methodScope) {
    }

    protected void finishInlining(MethodScope inlineScope) {
    }

    private static void propagateCreatedNodes(LoopScope loopScope) {
        if (loopScope.outer == null || loopScope.createdNodes != loopScope.outer.createdNodes) {
            return;
        }
        for (int i = 0; i < loopScope.createdNodes.length; ++i) {
            if (loopScope.outer.createdNodes[i] != null) continue;
            loopScope.outer.createdNodes[i] = loopScope.createdNodes[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoopScope processNextNode(MethodScope methodScope, LoopScope loopScope) {
        int nodeOrderId = loopScope.nodesToProcess.nextSetBit(0);
        loopScope.nodesToProcess.clear(nodeOrderId);
        FixedNode node = (FixedNode)this.lookupNode(loopScope, nodeOrderId);
        if (node.isDeleted()) {
            return loopScope;
        }
        this.graph.beforeDecodingFields(node);
        try {
            if ((node instanceof MergeNode || node instanceof LoopBeginNode && methodScope.loopExplosion.unrollLoops() && !methodScope.loopExplosion.mergeLoops()) && ((AbstractMergeNode)node).forwardEndCount() == 1) {
                AbstractMergeNode merge = (AbstractMergeNode)node;
                EndNode singleEnd = merge.forwardEndAt(0);
                this.registerNode(loopScope, nodeOrderId, AbstractBeginNode.prevBegin(singleEnd), true, false);
                FixedNode next = this.makeStubNode(methodScope, loopScope, nodeOrderId + 1);
                singleEnd.replaceAtPredecessor(next);
                merge.safeDelete();
                singleEnd.safeDelete();
                LoopScope loopScope2 = loopScope;
                return loopScope2;
            }
            LoopScope successorAddScope = loopScope;
            boolean updatePredecessors = true;
            if (node instanceof LoopExitNode) {
                if (methodScope.loopExplosion.duplicateLoopExits() || methodScope.loopExplosion.mergeLoops() && loopScope.loopDepth > 1) {
                    int nextIterationNumber;
                    LoopScope outerScope = loopScope.outer;
                    int n = nextIterationNumber = outerScope.nextIterationFromLoopExitDuplication.isEmpty() ? outerScope.loopIteration + 1 : outerScope.nextIterationFromLoopExitDuplication.getLast().loopIteration + 1;
                    Node[] initialCreatedNodes = outerScope.initialCreatedNodes == null ? null : (methodScope.loopExplosion.mergeLoops() ? Arrays.copyOf(outerScope.initialCreatedNodes, outerScope.initialCreatedNodes.length) : outerScope.initialCreatedNodes);
                    successorAddScope = new LoopScope(methodScope, outerScope.outer, outerScope.loopDepth, nextIterationNumber, outerScope.loopBeginOrderId, LoopScopeTrigger.LOOP_EXIT_DUPLICATION, initialCreatedNodes, Arrays.copyOf(loopScope.initialCreatedNodes, loopScope.initialCreatedNodes.length), outerScope.nextIterationFromLoopExitDuplication, outerScope.nextIterationFromLoopEndDuplication, outerScope.nextIterationsFromUnrolling, outerScope.iterationStates);
                    this.checkLoopExplosionIteration(methodScope, successorAddScope);
                    int id = outerScope.nodesToProcess.nextSetBit(0);
                    while (id >= 0) {
                        successorAddScope.createdNodes[id] = null;
                        id = outerScope.nodesToProcess.nextSetBit(id + 1);
                    }
                    outerScope.nextIterationFromLoopExitDuplication.addLast(successorAddScope);
                } else {
                    successorAddScope = loopScope.outer;
                }
                updatePredecessors = methodScope.loopExplosion.isNoExplosion();
            }
            methodScope.reader.setByteIndex(methodScope.encodedGraph.nodeStartOffsets[nodeOrderId]);
            int typeId = methodScope.reader.getUVInt();
            assert (node.getNodeClass() == methodScope.encodedGraph.getNodeClasses()[typeId]) : Assertions.errorMessage(node, methodScope.encodedGraph.getNodeClasses()[typeId]);
            this.makeFixedNodeInputs(methodScope, loopScope, node);
            this.readProperties(methodScope, node);
            if ((node instanceof IfNode || node instanceof SwitchNode) && this.earlyCanonicalization(methodScope, successorAddScope, nodeOrderId, node)) {
                LoopScope nextIterationNumber = loopScope;
                return nextIterationNumber;
            }
            this.makeSuccessorStubs(methodScope, successorAddScope, node, updatePredecessors);
            LoopScope resultScope = loopScope;
            if (node instanceof LoopBeginNode) {
                if (methodScope.loopExplosion.useExplosion()) {
                    this.handleLoopExplosionBegin(methodScope, loopScope, (LoopBeginNode)node);
                }
            } else if (node instanceof LoopExitNode) {
                if (methodScope.loopExplosion.useExplosion()) {
                    this.handleLoopExplosionProxyNodes(methodScope, loopScope, successorAddScope, (LoopExitNode)node, nodeOrderId);
                } else {
                    this.handleProxyNodes(methodScope, loopScope, (LoopExitNode)node);
                }
            } else if (node instanceof MergeNode) {
                this.handleMergeNode((MergeNode)node);
            } else if (node instanceof AbstractEndNode) {
                boolean requiresMergeOfOuterLoop;
                LoopScope phiInputScope = loopScope;
                LoopScope phiNodeScope = loopScope;
                int mergeOrderId = this.readOrderId(methodScope);
                boolean bl = requiresMergeOfOuterLoop = methodScope.loopExplosion.unrollLoops() && methodScope.loopExplosion.duplicateLoopExits() && !methodScope.loopExplosion.duplicateLoopEnds() && !methodScope.loopExplosion.mergeLoops() && node instanceof LoopEndNode && loopScope.trigger == LoopScopeTrigger.LOOP_EXIT_DUPLICATION;
                if (requiresMergeOfOuterLoop) {
                    replacementNode = this.graph.add(new EndNode());
                    node.replaceAtPredecessor(replacementNode);
                    node.safeDelete();
                    node = replacementNode;
                    if (loopScope.nextIterationsFromUnrolling.isEmpty()) {
                        int nextIterationNumber = loopScope.nextIterationsFromUnrolling.isEmpty() ? loopScope.loopIteration + 1 : loopScope.nextIterationsFromUnrolling.getLast().loopIteration + 1;
                        LoopScope outerLoopMergeScope = new LoopScope(methodScope, loopScope.outer, loopScope.loopDepth, nextIterationNumber, loopScope.loopBeginOrderId, LoopScopeTrigger.LOOP_BEGIN_UNROLLING, methodScope.loopExplosion.mergeLoops() ? Arrays.copyOf(loopScope.initialCreatedNodes, loopScope.initialCreatedNodes.length) : loopScope.initialCreatedNodes, Arrays.copyOf(loopScope.initialCreatedNodes, loopScope.initialCreatedNodes.length), loopScope.nextIterationFromLoopExitDuplication, loopScope.nextIterationFromLoopEndDuplication, loopScope.nextIterationsFromUnrolling, loopScope.iterationStates);
                        this.checkLoopExplosionIteration(methodScope, outerLoopMergeScope);
                        loopScope.nextIterationsFromUnrolling.addLast(outerLoopMergeScope);
                        this.registerNode(outerLoopMergeScope, loopScope.loopBeginOrderId, null, true, true);
                        this.makeStubNode(methodScope, outerLoopMergeScope, loopScope.loopBeginOrderId);
                        phiNodeScope = outerLoopMergeScope;
                    } else {
                        phiNodeScope = loopScope.nextIterationsFromUnrolling.getLast();
                    }
                } else if (methodScope.loopExplosion.useExplosion() && node instanceof LoopEndNode) {
                    replacementNode = this.graph.add(new EndNode());
                    node.replaceAtPredecessor(replacementNode);
                    node.safeDelete();
                    node = replacementNode;
                    LoopScopeTrigger trigger = this.handleLoopExplosionEnd(methodScope, loopScope);
                    Deque<LoopScope> phiScope = loopScope.nextIterationsFromUnrolling;
                    if (trigger == LoopScopeTrigger.LOOP_END_DUPLICATION) {
                        phiScope = loopScope.nextIterationFromLoopEndDuplication;
                    }
                    phiNodeScope = phiScope.getLast();
                }
                AbstractMergeNode merge = (AbstractMergeNode)this.lookupNode(phiNodeScope, mergeOrderId);
                if (merge == null && (merge = (AbstractMergeNode)this.makeStubNode(methodScope, phiNodeScope, mergeOrderId)) instanceof LoopBeginNode) {
                    assert (phiNodeScope == phiInputScope) : String.valueOf(phiInputScope) + "!=" + String.valueOf(phiInputScope);
                    assert (phiNodeScope == loopScope) : String.valueOf(phiNodeScope) + "!=" + String.valueOf(loopScope);
                    phiInputScope = resultScope = new LoopScope(methodScope, loopScope, loopScope.loopDepth + 1, 0, mergeOrderId, LoopScopeTrigger.START, methodScope.loopExplosion.useExplosion() ? Arrays.copyOf(loopScope.createdNodes, loopScope.createdNodes.length) : null, methodScope.loopExplosion.useExplosion() ? Arrays.copyOf(loopScope.createdNodes, loopScope.createdNodes.length) : loopScope.createdNodes, methodScope.loopExplosion.duplicateLoopExits() || methodScope.loopExplosion.mergeLoops() ? new ArrayDeque<LoopScope>(2) : null, methodScope.loopExplosion.duplicateLoopEnds() ? new ArrayDeque<LoopScope>(2) : null, methodScope.loopExplosion.unrollLoops() ? new ArrayDeque<LoopScope>(2) : null, (EconomicMap<LoopExplosionState, LoopExplosionState>)(methodScope.loopExplosion.mergeLoops() ? EconomicMap.create((Equivalence)Equivalence.DEFAULT) : null));
                    phiNodeScope = resultScope;
                    if (methodScope.loopExplosion.useExplosion()) {
                        this.registerNode(loopScope, mergeOrderId, null, true, true);
                    }
                    loopScope.nodesToProcess.clear(mergeOrderId);
                    resultScope.nodesToProcess.set(mergeOrderId);
                }
                this.handlePhiFunctions(methodScope, phiInputScope, phiNodeScope, (AbstractEndNode)node, merge);
            } else if (node instanceof Invoke) {
                InvokeData invokeData = this.readInvokeData(methodScope, nodeOrderId, (Invoke)((Object)node));
                resultScope = this.handleInvoke(methodScope, loopScope, invokeData);
            } else if (node instanceof MethodHandleWithExceptionNode) {
                MethodHandleWithExceptionNode methodHandle = (MethodHandleWithExceptionNode)node;
                InvokableData<MethodHandleWithExceptionNode> invokableData = this.readInvokableData(methodScope, nodeOrderId, methodHandle);
                resultScope = this.handleMethodHandle(methodScope, loopScope, invokableData);
            } else if (node instanceof ReturnNode || node instanceof UnwindNode) {
                methodScope.returnAndUnwindNodes.add((ControlSinkNode)node);
            } else {
                this.handleFixedNode(methodScope, loopScope, nodeOrderId, node);
            }
            LoopScope loopScope3 = resultScope;
            return loopScope3;
        }
        finally {
            this.graph.afterDecodingFields(node);
        }
    }

    protected LoopScope handleMethodHandle(MethodScope methodScope, LoopScope loopScope, InvokableData<MethodHandleWithExceptionNode> invokableData) {
        this.appendInvokable(methodScope, loopScope, invokableData);
        return loopScope;
    }

    protected <T extends Invokable> InvokableData<T> readInvokableData(MethodScope methodScope, int orderId, T node) {
        ResolvedJavaType contextType = (ResolvedJavaType)this.readObject(methodScope);
        int stateAfterOrderId = this.readOrderId(methodScope);
        int nextOrderId = this.readOrderId(methodScope);
        if (node instanceof WithExceptionNode) {
            int exceptionOrderId = this.readOrderId(methodScope);
            int exceptionStateOrderId = this.readOrderId(methodScope);
            int exceptionNextOrderId = this.readOrderId(methodScope);
            return new InvokableData<T>(node, contextType, orderId, stateAfterOrderId, nextOrderId, exceptionOrderId, exceptionStateOrderId, exceptionNextOrderId);
        }
        return new InvokableData<T>(node, contextType, orderId, stateAfterOrderId, nextOrderId, -1, -1, -1);
    }

    protected InvokeData readInvokeData(MethodScope methodScope, int invokeOrderId, Invoke invoke) {
        int callTargetOrderId = this.readOrderId(methodScope);
        InvokableData<Invoke> invokableData = this.readInvokableData(methodScope, invokeOrderId, invoke);
        return InvokeData.createFrom(invokableData, callTargetOrderId, false);
    }

    protected LoopScope handleInvoke(MethodScope methodScope, LoopScope loopScope, InvokeData invokeData) {
        assert (((Invoke)invokeData.invoke).callTarget() == null) : "callTarget edge is ignored during decoding of Invoke";
        CallTargetNode callTarget = (CallTargetNode)this.ensureNodeCreated(methodScope, loopScope, invokeData.callTargetOrderId);
        this.appendInvoke(methodScope, loopScope, invokeData, callTarget);
        return loopScope;
    }

    protected void appendInvoke(MethodScope methodScope, LoopScope loopScope, InvokeData invokeData, CallTargetNode callTarget) {
        if (invokeData.invoke instanceof InvokeWithExceptionNode) {
            ((InvokeWithExceptionNode)invokeData.invoke).setCallTarget(callTarget);
        } else {
            ((InvokeNode)invokeData.invoke).setCallTarget(callTarget);
        }
        this.appendInvokable(methodScope, loopScope, invokeData);
    }

    private <T extends Invokable & StateSplit> void appendInvokable(MethodScope methodScope, LoopScope loopScope, InvokableData<T> invokeData) {
        Invoke inv;
        Object t;
        if (((StateSplit)invokeData.invoke).stateAfter() == null) {
            ((StateSplit)invokeData.invoke).setStateAfter((FrameState)this.ensureNodeCreated(methodScope, loopScope, invokeData.stateAfterOrderId));
        }
        assert (!((t = invokeData.invoke) instanceof Invoke && (inv = (Invoke)t).stateDuring() != null)) : "stateDuring is not used in high tier graphs";
        FixedNode next = this.makeStubNode(methodScope, loopScope, invokeData.nextOrderId);
        Object t2 = invokeData.invoke;
        if (t2 instanceof WithExceptionNode) {
            WithExceptionNode withException = (WithExceptionNode)t2;
            withException.setNext((AbstractBeginNode)next);
            withException.setExceptionEdge((AbstractBeginNode)this.makeStubNode(methodScope, loopScope, invokeData.exceptionOrderId));
        } else {
            ((FixedWithNextNode)invokeData.invoke).setNext(next);
        }
    }

    protected void handleMergeNode(MergeNode merge) {
    }

    protected void handleLoopExplosionBegin(final MethodScope methodScope, final LoopScope loopScope, LoopBeginNode loopBegin) {
        LoopExplosionState queryState;
        LoopExplosionState existingState;
        this.checkLoopExplosionIteration(methodScope, loopScope);
        List predecessors = loopBegin.forwardEnds().snapshot();
        FixedNode successor = loopBegin.next();
        FrameState frameState = loopBegin.stateAfter();
        if (methodScope.loopExplosion.mergeLoops() && (existingState = (LoopExplosionState)loopScope.iterationStates.get((Object)(queryState = new LoopExplosionState(frameState, null)))) != null) {
            loopBegin.replaceAtUsagesAndDelete(existingState.merge);
            successor.safeDelete();
            for (EndNode predecessor : predecessors) {
                existingState.merge.addForwardEnd(predecessor);
            }
            return;
        }
        final MergeNode merge = this.graph.add(new MergeNode());
        methodScope.loopExplosionMerges.add((Object)merge);
        if (methodScope.loopExplosion.mergeLoops()) {
            if (loopScope.iterationStates.size() == 0 && loopScope.loopDepth == 1) {
                if (methodScope.loopExplosionHead != null) {
                    throw new PermanentBailoutException("Graal implementation restriction: Method with %s loop explosion must not have more than one top-level loop", new Object[]{LoopExplosionPlugin.LoopExplosionKind.MERGE_EXPLODE});
                }
                methodScope.loopExplosionHead = merge;
            }
            FrameState.ValueFunction valueFunction = new FrameState.ValueFunction(){
                final /* synthetic */ GraphDecoder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public ValueNode apply(int index, ValueNode frameStateValue) {
                    int i;
                    if (frameStateValue == null || frameStateValue.isConstant() || !this.this$0.graph.isNew(methodScope.methodStartMark, frameStateValue)) {
                        return frameStateValue;
                    }
                    ProxyPlaceholder newFrameStateValue = this.this$0.graph.unique(new ProxyPlaceholder(frameStateValue, merge));
                    for (i = 0; i < loopScope.createdNodes.length; ++i) {
                        if (loopScope.createdNodes[i] != frameStateValue) continue;
                        loopScope.createdNodes[i] = newFrameStateValue;
                    }
                    if (loopScope.initialCreatedNodes != null) {
                        for (i = 0; i < loopScope.initialCreatedNodes.length; ++i) {
                            if (loopScope.initialCreatedNodes[i] != frameStateValue) continue;
                            loopScope.initialCreatedNodes[i] = newFrameStateValue;
                        }
                    }
                    return newFrameStateValue;
                }
            };
            FrameState newFrameState = this.graph.add(frameState.duplicate(valueFunction));
            frameState.replaceAtUsagesAndDelete(newFrameState);
            frameState = newFrameState;
        }
        loopBegin.replaceAtUsagesAndDelete(merge);
        merge.setStateAfter(frameState);
        merge.setNext(successor);
        for (EndNode predecessor : predecessors) {
            merge.addForwardEnd(predecessor);
        }
        if (methodScope.loopExplosion.mergeLoops()) {
            LoopExplosionState explosionState = new LoopExplosionState(frameState, merge);
            loopScope.iterationStates.put((Object)explosionState, (Object)explosionState);
        }
    }

    protected void checkLoopExplosionIteration(MethodScope methodScope, LoopScope loopScope) {
        throw GraalError.shouldNotReachHere("when subclass uses loop explosion, it needs to implement this method");
    }

    protected LoopScopeTrigger handleLoopExplosionEnd(MethodScope methodScope, LoopScope loopScope) {
        LoopScopeTrigger trigger = null;
        Deque<LoopScope> nextIterations = null;
        if (methodScope.loopExplosion.duplicateLoopEnds()) {
            trigger = LoopScopeTrigger.LOOP_END_DUPLICATION;
            nextIterations = loopScope.nextIterationFromLoopEndDuplication;
        } else if (loopScope.nextIterationsFromUnrolling.isEmpty()) {
            trigger = LoopScopeTrigger.LOOP_BEGIN_UNROLLING;
            nextIterations = loopScope.nextIterationsFromUnrolling;
        }
        if (trigger != null) {
            int nextIterationNumber = nextIterations.isEmpty() ? loopScope.loopIteration + 1 : nextIterations.getLast().loopIteration + 1;
            LoopScope nextIterationScope = new LoopScope(methodScope, loopScope.outer, loopScope.loopDepth, nextIterationNumber, loopScope.loopBeginOrderId, trigger, methodScope.loopExplosion.mergeLoops() ? Arrays.copyOf(loopScope.initialCreatedNodes, loopScope.initialCreatedNodes.length) : loopScope.initialCreatedNodes, Arrays.copyOf(loopScope.initialCreatedNodes, loopScope.initialCreatedNodes.length), loopScope.nextIterationFromLoopExitDuplication, loopScope.nextIterationFromLoopEndDuplication, loopScope.nextIterationsFromUnrolling, loopScope.iterationStates);
            this.checkLoopExplosionIteration(methodScope, nextIterationScope);
            nextIterations.addLast(nextIterationScope);
            this.registerNode(nextIterationScope, loopScope.loopBeginOrderId, null, true, true);
            this.makeStubNode(methodScope, nextIterationScope, loopScope.loopBeginOrderId);
        }
        return trigger;
    }

    protected void handleFixedNode(MethodScope methodScope, LoopScope loopScope, int nodeOrderId, FixedNode node) {
    }

    protected boolean earlyCanonicalization(MethodScope methodScope, LoopScope loopScope, int nodeOrderId, FixedNode node) {
        return false;
    }

    protected void handleProxyNodes(MethodScope methodScope, LoopScope loopScope, LoopExitNode loopExit) {
        assert (loopExit.stateAfter() == null);
        int stateAfterOrderId = this.readOrderId(methodScope);
        loopExit.setStateAfter((FrameState)this.ensureNodeCreated(methodScope, loopScope, stateAfterOrderId));
        int numProxies = methodScope.reader.getUVInt();
        for (int i = 0; i < numProxies; ++i) {
            int proxyOrderId = this.readOrderId(methodScope);
            ProxyNode proxy = (ProxyNode)this.ensureNodeCreated(methodScope, loopScope, proxyOrderId);
            if (loopScope.outer.createdNodes == loopScope.createdNodes) continue;
            this.registerNode(loopScope.outer, proxyOrderId, proxy, false, false);
        }
    }

    protected void handleLoopExplosionProxyNodes(MethodScope methodScope, LoopScope loopScope, LoopScope outerScope, LoopExitNode loopExit, int loopExitOrderId) {
        BeginNode begin;
        assert (loopExit.stateAfter() == null);
        int stateAfterOrderId = this.readOrderId(methodScope);
        FixedNode loopExitSuccessor = loopExit.next();
        if (loopExit.predecessor() instanceof BeginNode) {
            begin = (BeginNode)loopExit.predecessor();
            loopExit.replaceAtPredecessor(null);
        } else {
            begin = this.graph.add(new BeginNode());
            loopExit.replaceAtPredecessor(begin);
        }
        MergeNode loopExitPlaceholder = null;
        if (methodScope.loopExplosion.mergeLoops() && loopScope.loopDepth == 1) {
            loopExitPlaceholder = this.graph.add(new MergeNode());
            methodScope.loopExplosionMerges.add((Object)loopExitPlaceholder);
            EndNode end = this.graph.add(new EndNode());
            begin.setNext(end);
            loopExitPlaceholder.addForwardEnd(end);
            begin = this.graph.add(new BeginNode());
            loopExitPlaceholder.setNext(begin);
        }
        MergeNode merge = null;
        Node existingExit = this.lookupNode(outerScope, loopExitOrderId);
        if (existingExit == null) {
            this.registerNode(outerScope, loopExitOrderId, begin, false, false);
            begin.setNext(loopExitSuccessor);
        } else if (existingExit instanceof BeginNode) {
            merge = this.graph.add(new MergeNode());
            this.registerNode(outerScope, loopExitOrderId, merge, true, false);
            EndNode firstEnd = this.graph.add(new EndNode());
            ((BeginNode)existingExit).setNext(firstEnd);
            merge.addForwardEnd(firstEnd);
            merge.setNext(loopExitSuccessor);
        } else {
            merge = (MergeNode)existingExit;
        }
        if (merge != null) {
            EndNode end = this.graph.add(new EndNode());
            begin.setNext(end);
            merge.addForwardEnd(end);
        }
        int numProxies = methodScope.reader.getUVInt();
        boolean phiCreated = false;
        for (int i = 0; i < numProxies; ++i) {
            ValueNode replacement;
            ValueNode existing;
            int proxyOrderId = this.readOrderId(methodScope);
            ProxyNode proxy = (ProxyNode)this.ensureNodeCreated(methodScope, loopScope, proxyOrderId);
            ValueNode phiInput = proxy.value();
            if (loopExitPlaceholder != null) {
                if (!phiInput.isConstant()) {
                    phiInput = this.graph.unique(new ProxyPlaceholder(phiInput, loopExitPlaceholder));
                }
                this.registerNode(loopScope, proxyOrderId, phiInput, true, false);
            }
            if ((existing = (ValueNode)outerScope.createdNodes[proxyOrderId]) == null || existing == phiInput) {
                this.registerNode(outerScope, proxyOrderId, phiInput, true, false);
                replacement = phiInput;
            } else {
                assert (merge != null);
                if (!merge.isPhiAtMerge(existing)) {
                    phi = proxy.createPhi(merge);
                    for (int j = 0; j < merge.phiPredecessorCount() - 1; ++j) {
                        phi.addInput(existing);
                    }
                    phi.addInput(phiInput);
                    this.registerNode(outerScope, proxyOrderId, phi, true, false);
                    replacement = phi;
                    phiCreated = true;
                } else {
                    phi = (PhiNode)existing;
                    phi.addInput(phiInput);
                    replacement = phi;
                }
            }
            proxy.replaceAtUsagesAndDelete(replacement);
        }
        if (loopExitPlaceholder != null) {
            this.registerNode(loopScope, stateAfterOrderId, null, true, true);
            loopExitPlaceholder.setStateAfter((FrameState)this.ensureNodeCreated(methodScope, loopScope, stateAfterOrderId));
        }
        if (merge != null && (merge.stateAfter() == null || phiCreated)) {
            FrameState oldStateAfter = merge.stateAfter();
            this.registerNode(outerScope, stateAfterOrderId, null, true, true);
            merge.setStateAfter((FrameState)this.ensureNodeCreated(methodScope, outerScope, stateAfterOrderId));
            if (oldStateAfter != null) {
                oldStateAfter.safeDelete();
            }
        }
        loopExit.safeDelete();
        assert (loopExitSuccessor.predecessor() == null);
        if (merge != null) {
            merge.getNodeClass().getSuccessorEdges().update(merge, null, loopExitSuccessor);
        } else {
            begin.getNodeClass().getSuccessorEdges().update(begin, null, loopExitSuccessor);
        }
    }

    protected void handlePhiFunctions(MethodScope methodScope, LoopScope phiInputScope, LoopScope phiNodeScope, AbstractEndNode end, AbstractMergeNode merge) {
        if (end instanceof LoopEndNode) {
            int numEnds;
            ((LoopBeginNode)merge).nextEndIndex = numEnds = ((LoopBeginNode)merge).loopEnds().count();
            ((LoopEndNode)end).endIndex = numEnds - 1;
        } else {
            if (merge.ends == null) {
                merge.ends = new NodeInputList(merge);
            }
            merge.addForwardEnd((EndNode)end);
        }
        boolean lazyPhi = this.allowLazyPhis() && (!(merge instanceof LoopBeginNode) || methodScope.loopExplosion.useExplosion());
        int numPhis = methodScope.reader.getUVInt();
        for (int i = 0; i < numPhis; ++i) {
            PhiNode phi;
            int phiInputOrderId = this.readOrderId(methodScope);
            int phiNodeOrderId = this.readOrderId(methodScope);
            ValueNode phiInput = (ValueNode)this.ensureNodeCreated(methodScope, phiInputScope, phiInputOrderId);
            ValueNode existing = (ValueNode)this.lookupNode(phiNodeScope, phiNodeOrderId);
            if (existing != null && merge.phiPredecessorCount() == 1) {
                assert (methodScope.loopExplosion.duplicateLoopExits());
                assert (phiNodeScope.loopIteration > 0) : Assertions.errorMessageContext("phiNodeScope.loopIteration", phiNodeScope.loopIteration);
                existing = null;
            }
            if (lazyPhi && (existing == null || existing == phiInput)) {
                this.registerNode(phiNodeScope, phiNodeOrderId, phiInput, true, false);
                continue;
            }
            if (!merge.isPhiAtMerge(existing)) {
                this.registerNode(phiNodeScope, phiNodeOrderId, null, true, true);
                phi = (PhiNode)this.ensureNodeCreated(methodScope, phiNodeScope, phiNodeOrderId);
                phi.setMerge(merge);
                for (int j = 0; j < merge.phiPredecessorCount() - 1; ++j) {
                    phi.addInput(existing);
                }
                phi.addInput(phiInput);
                continue;
            }
            phi = (PhiNode)existing;
            phi.addInput(phiInput);
        }
    }

    protected boolean allowLazyPhis() {
        return false;
    }

    protected void readProperties(MethodScope methodScope, Node node) {
        try (DebugCloseable a = ReadPropertiesTimer.start(this.debug);){
            NodeSourcePosition position = (NodeSourcePosition)this.readObject(methodScope);
            Fields fields = node.getNodeClass().getData();
            for (int pos : fields.getStableOrder()) {
                if (fields.getType(pos).isPrimitive()) {
                    long primitive = methodScope.reader.getSV();
                    fields.setRawPrimitive(node, pos, primitive);
                    continue;
                }
                Object value = this.readObject(methodScope);
                fields.putObject(node, pos, value);
            }
            if (this.graph.trackNodeSourcePosition() && position != null) {
                NodeSourcePosition newPosition = methodScope.getNodeSourcePosition(position);
                node.setNodeSourcePosition(newPosition);
                if (node instanceof DeoptimizingGuard) {
                    DeoptimizingGuard deoptGuard = (DeoptimizingGuard)((Object)node);
                    if (!newPosition.equals(position)) {
                        deoptGuard.addCallerToNoDeoptSuccessorPosition(newPosition.getCaller());
                    }
                }
            }
        }
    }

    protected void makeFixedNodeInputs(MethodScope methodScope, LoopScope loopScope, Node node) {
        int index;
        InputEdges edges = node.getNodeClass().getInputEdges();
        for (index = 0; index < edges.getDirectCount(); ++index) {
            if (GraphDecoder.skipDirectEdge(node, edges, index)) continue;
            int orderId = this.readOrderId(methodScope);
            Node value = this.ensureNodeCreated(methodScope, loopScope, orderId);
            edges.initializeNode(node, index, value);
            if (value == null || value.isDeleted()) continue;
            ((Edges)edges).update(node, null, value);
        }
        if (node instanceof AbstractMergeNode) {
            assert (edges.getCount() - edges.getDirectCount() == 1) : "MergeNode has one variable size input (the ends)";
            assert (Edges.getNodeList(node, edges.getOffsets(), edges.getDirectCount()) != null) : "Input list must have been already created";
        } else {
            for (index = edges.getDirectCount(); index < edges.getCount(); ++index) {
                int size = methodScope.reader.getSVInt();
                if (size == -1) continue;
                NodeInputList<Node> nodeList = new NodeInputList<Node>(node, size);
                edges.initializeList(node, index, nodeList);
                for (int idx = 0; idx < size; ++idx) {
                    int orderId = this.readOrderId(methodScope);
                    Node value = this.ensureNodeCreated(methodScope, loopScope, orderId);
                    nodeList.initialize(idx, value);
                    if (value == null || value.isDeleted()) continue;
                    ((Edges)edges).update(node, null, value);
                }
            }
        }
    }

    protected void makeFloatingNodeInputs(MethodScope methodScope, LoopScope loopScope, Node node) {
        InputEdges edges = node.getNodeClass().getInputEdges();
        if (node instanceof PhiNode) {
            assert (edges.getDirectCount() == 1) : "PhiNode has one direct input (the MergeNode)";
            assert (edges.getCount() - edges.getDirectCount() == 1) : "PhiNode has one variable size input (the values)";
            edges.initializeList(node, edges.getDirectCount(), new NodeInputList<Node>(node));
        } else {
            int index;
            for (index = 0; index < edges.getDirectCount(); ++index) {
                int orderId = this.readOrderId(methodScope);
                Node value = this.ensureNodeCreated(methodScope, loopScope, orderId);
                edges.initializeNode(node, index, value);
            }
            for (index = edges.getDirectCount(); index < edges.getCount(); ++index) {
                int size = methodScope.reader.getSVInt();
                if (size == -1) continue;
                NodeInputList<Node> nodeList = new NodeInputList<Node>(node, size);
                edges.initializeList(node, index, nodeList);
                for (int idx = 0; idx < size; ++idx) {
                    int orderId = this.readOrderId(methodScope);
                    Node value = this.ensureNodeCreated(methodScope, loopScope, orderId);
                    nodeList.initialize(idx, value);
                }
            }
        }
    }

    protected Node ensureNodeCreated(MethodScope methodScope, LoopScope loopScope, int nodeOrderId) {
        if (nodeOrderId == 0) {
            return null;
        }
        Node node = this.lookupNode(loopScope, nodeOrderId);
        if (node != null) {
            return node;
        }
        node = this.decodeFloatingNode(methodScope, loopScope, nodeOrderId);
        if (node instanceof ProxyNode || node instanceof PhiNode) {
            node = this.graph.addWithoutUnique(node);
        } else {
            Node newNode = this.handleFloatingNodeBeforeAdd(methodScope, loopScope, node);
            if (newNode != node) {
                this.releaseFloatingNode(node);
            }
            if (!newNode.isAlive()) {
                newNode = this.addFloatingNode(methodScope, loopScope, newNode);
            }
            node = this.handleFloatingNodeAfterAdd(methodScope, loopScope, newNode);
        }
        this.registerNode(loopScope, nodeOrderId, node, false, false);
        return node;
    }

    protected Node addFloatingNode(MethodScope methodScope, LoopScope loopScope, Node node) {
        return this.graph.addWithoutUnique(node);
    }

    protected Node decodeFloatingNode(MethodScope methodScope, LoopScope loopScope, int nodeOrderId) {
        long readerByteIndex = methodScope.reader.getByteIndex();
        methodScope.reader.setByteIndex(methodScope.encodedGraph.nodeStartOffsets[nodeOrderId]);
        NodeClass<?> nodeClass = methodScope.encodedGraph.getNodeClasses()[methodScope.reader.getUVInt()];
        Node node = this.allocateFloatingNode(nodeClass);
        if (node instanceof FixedNode) {
            throw GraalError.shouldNotReachHere("Not a floating node: " + node.getClass().getName());
        }
        this.makeFloatingNodeInputs(methodScope, loopScope, node);
        this.readProperties(methodScope, node);
        assert (node.getNodeClass().getEdges(Edges.Type.Successors).getCount() == 0) : Assertions.errorMessage(node);
        methodScope.reader.setByteIndex(readerByteIndex);
        return node;
    }

    private Node allocateFloatingNode(NodeClass<?> nodeClass) {
        Node node;
        ArrayDeque cachedNodes = (ArrayDeque)this.reusableFloatingNodes.get(nodeClass);
        if (cachedNodes != null && (node = (Node)cachedNodes.poll()) != null) {
            return node;
        }
        return nodeClass.allocateInstance();
    }

    private void releaseFloatingNode(Node node) {
        ArrayDeque<Node> cachedNodes = (ArrayDeque<Node>)this.reusableFloatingNodes.get(node.getNodeClass());
        if (cachedNodes == null) {
            cachedNodes = new ArrayDeque<Node>(2);
            this.reusableFloatingNodes.put(node.getNodeClass(), cachedNodes);
        }
        cachedNodes.push(node);
    }

    protected Node handleFloatingNodeBeforeAdd(MethodScope methodScope, LoopScope loopScope, Node node) {
        return node;
    }

    protected Node handleFloatingNodeAfterAdd(MethodScope methodScope, LoopScope loopScope, Node node) {
        return node;
    }

    protected void makeSuccessorStubs(MethodScope methodScope, LoopScope loopScope, Node node, boolean updatePredecessors) {
        try (DebugCloseable a = MakeSuccessorStubsTimer.start(this.debug);){
            int index;
            SuccessorEdges edges = node.getNodeClass().getSuccessorEdges();
            for (index = 0; index < edges.getDirectCount(); ++index) {
                if (GraphDecoder.skipDirectEdge(node, edges, index)) continue;
                int orderId = this.readOrderId(methodScope);
                FixedNode value = this.makeStubNode(methodScope, loopScope, orderId);
                edges.initializeNode(node, index, value);
                if (!updatePredecessors || value == null) continue;
                ((Edges)edges).update(node, null, value);
            }
            for (index = edges.getDirectCount(); index < edges.getCount(); ++index) {
                int size = methodScope.reader.getSVInt();
                if (size == -1) continue;
                NodeSuccessorList<Node> nodeList = new NodeSuccessorList<Node>(node, size);
                edges.initializeList(node, index, nodeList);
                for (int idx = 0; idx < size; ++idx) {
                    int orderId = this.readOrderId(methodScope);
                    FixedNode value = this.makeStubNode(methodScope, loopScope, orderId);
                    nodeList.initialize(idx, value);
                    if (!updatePredecessors || value == null) continue;
                    ((Edges)edges).update(node, null, value);
                }
            }
        }
    }

    protected NodeClass<?> getNodeClass(MethodScope methodScope, LoopScope loopScope, int nodeOrderId) {
        if (nodeOrderId == 0) {
            return null;
        }
        FixedNode node = (FixedNode)this.lookupNode(loopScope, nodeOrderId);
        if (node != null) {
            return node.getNodeClass();
        }
        long readerByteIndex = methodScope.reader.getByteIndex();
        methodScope.reader.setByteIndex(methodScope.encodedGraph.nodeStartOffsets[nodeOrderId]);
        NodeClass<?> nodeClass = methodScope.encodedGraph.getNodeClasses()[methodScope.reader.getUVInt()];
        methodScope.reader.setByteIndex(readerByteIndex);
        return nodeClass;
    }

    protected FixedNode makeStubNode(MethodScope methodScope, LoopScope loopScope, int nodeOrderId) {
        if (nodeOrderId == 0) {
            return null;
        }
        FixedNode node = (FixedNode)this.lookupNode(loopScope, nodeOrderId);
        if (node != null) {
            return node;
        }
        long readerByteIndex = methodScope.reader.getByteIndex();
        methodScope.reader.setByteIndex(methodScope.encodedGraph.nodeStartOffsets[nodeOrderId]);
        NodeClass<?> nodeClass = methodScope.encodedGraph.getNodeClasses()[methodScope.reader.getUVInt()];
        Node stubNode = nodeClass.allocateInstance();
        if (this.graph.trackNodeSourcePosition()) {
            stubNode.setNodeSourcePosition(NodeSourcePosition.placeholder(this.graph.method()));
        }
        node = (FixedNode)this.graph.add(stubNode);
        methodScope.reader.setByteIndex(readerByteIndex);
        this.registerNode(loopScope, nodeOrderId, node, false, false);
        loopScope.nodesToProcess.set(nodeOrderId);
        return node;
    }

    protected static boolean skipDirectEdge(Node node, Edges edges, int index) {
        if (node instanceof Invoke || node instanceof MethodHandleWithExceptionNode) {
            assert (node instanceof InvokeNode || node instanceof InvokeWithExceptionNode || node instanceof MethodHandleWithExceptionNode) : "The only supported node classes. Got " + String.valueOf(node.getClass());
            if (edges.type() == Edges.Type.Successors) {
                assert (edges.getCount() == (node instanceof WithExceptionNode ? 2 : 1)) : "Base Invokable has one successor (next); WithExceptionNode has two successors (next, exceptionEdge)";
                return true;
            }
            assert (edges.type() == Edges.Type.Inputs) : edges.type();
            if (edges.getType(index) == CallTargetNode.class) {
                return true;
            }
            if (edges.getType(index) == FrameState.class) {
                assert (edges.get(node, index) == null || edges.get(node, index) == ((StateSplit)((Object)node)).stateAfter()) : "Only stateAfter can be a FrameState during encoding";
                return true;
            }
        } else if (node instanceof LoopExitNode && edges.type() == Edges.Type.Inputs && edges.getType(index) == FrameState.class) {
            return true;
        }
        return false;
    }

    protected Node lookupNode(LoopScope loopScope, int nodeOrderId) {
        return loopScope.createdNodes[nodeOrderId];
    }

    protected void registerNode(LoopScope loopScope, int nodeOrderId, Node node, boolean allowOverwrite, boolean allowNull) {
        assert (node == null || node.isAlive());
        assert (allowNull || node != null);
        assert (allowOverwrite || this.lookupNode(loopScope, nodeOrderId) == null);
        loopScope.createdNodes[nodeOrderId] = node;
        if (loopScope.methodScope.inliningLogDecoder != null) {
            loopScope.methodScope.inliningLogDecoder.registerNode(loopScope.methodScope.inliningLog, node, nodeOrderId);
        }
    }

    protected int readOrderId(MethodScope methodScope) {
        switch (methodScope.orderIdWidth) {
            case 1: {
                return methodScope.reader.getU1();
            }
            case 2: {
                return methodScope.reader.getU2();
            }
            case 4: {
                return methodScope.reader.getS4();
            }
        }
        throw GraalError.shouldNotReachHere("Invalid orderIdWidth: " + methodScope.orderIdWidth);
    }

    protected Object readObject(MethodScope methodScope) {
        return methodScope.encodedGraph.getObject(methodScope.reader.getUVInt());
    }

    protected void cleanupGraph(MethodScope methodScope) {
        for (MergeNode merge : this.graph.getNodes(MergeNode.TYPE)) {
            for (ProxyPlaceholder placeholder : merge.usages().filter(ProxyPlaceholder.class).snapshot()) {
                placeholder.replaceAndDelete(placeholder.value);
            }
        }
        assert (this.verifyEdges());
    }

    protected boolean verifyEdges() {
        for (Node node : this.graph.getNodes()) {
            assert (node.isAlive());
            for (Node i : node.inputs()) {
                assert (i.isAlive());
                assert (i.usages().contains(node));
            }
            for (Node s : node.successors()) {
                assert (s.isAlive());
                assert (s.predecessor() == node) : Assertions.errorMessage(s.predecessor(), node);
            }
            for (Node usage : node.usages()) {
                assert (usage.isAlive());
                assert (usage.inputs().contains(node)) : String.valueOf(node) + " / " + String.valueOf(usage) + " / " + usage.inputs().count();
            }
            if (node.predecessor() == null) continue;
            assert (node.predecessor().isAlive());
            assert (node.predecessor().successors().contains(node));
        }
        return true;
    }

    protected class MethodScope {
        public final LoopScope callerLoopScope;
        public final Graph.Mark methodStartMark;
        public final EncodedGraph encodedGraph;
        public final int maxFixedNodeOrderId;
        public final int orderIdWidth;
        public final TypeReader reader;
        public final LoopExplosionPlugin.LoopExplosionKind loopExplosion;
        public final List<ControlSinkNode> returnAndUnwindNodes;
        public final EconomicSet<Node> loopExplosionMerges;
        public MergeNode loopExplosionHead;
        public InliningLog inliningLog;
        public OptimizationLog optimizationLog;
        public InliningLogCodec.InliningLogDecoder inliningLogDecoder;

        protected MethodScope(LoopScope callerLoopScope, StructuredGraph graph, EncodedGraph encodedGraph, LoopExplosionPlugin.LoopExplosionKind loopExplosion) {
            this.callerLoopScope = callerLoopScope;
            this.methodStartMark = graph.getMark();
            this.encodedGraph = encodedGraph;
            this.loopExplosion = loopExplosion;
            this.returnAndUnwindNodes = new ArrayList<ControlSinkNode>(2);
            if (encodedGraph != null) {
                Pair<InliningLogCodec.InliningLogDecoder, InliningLog> decoderPair;
                this.reader = UnsafeArrayTypeReader.create(encodedGraph.getEncoding(), encodedGraph.getStartOffset(), GraphDecoder.this.architecture.supportsUnalignedMemoryAccess());
                this.maxFixedNodeOrderId = this.reader.getUVInt();
                GraphState.GuardsStage guardsStage = (GraphState.GuardsStage)((Object)GraphDecoder.this.readObject(this));
                EnumSet stageFlags = (EnumSet)GraphDecoder.this.readObject(this);
                if (callerLoopScope == null) {
                    graph.getGraphState().setGuardsStage(guardsStage);
                    graph.getGraphState().getStageFlags().addAll(stageFlags);
                }
                if ((decoderPair = InliningLogCodec.maybeDecode(graph, GraphDecoder.this.readObject(this))) != null) {
                    this.inliningLogDecoder = (InliningLogCodec.InliningLogDecoder)decoderPair.getLeft();
                    this.inliningLog = (InliningLog)decoderPair.getRight();
                }
                this.optimizationLog = OptimizationLogCodec.maybeDecode(graph, GraphDecoder.this.readObject(this));
                int nodeCount = this.reader.getUVInt();
                if (encodedGraph.nodeStartOffsets == null) {
                    int[] nodeStartOffsets = new int[nodeCount];
                    for (int i = 0; i < nodeCount; ++i) {
                        nodeStartOffsets[i] = encodedGraph.getStartOffset() - this.reader.getUVInt();
                    }
                    encodedGraph.nodeStartOffsets = nodeStartOffsets;
                }
                this.orderIdWidth = nodeCount <= 128 ? 1 : (nodeCount <= 32768 ? 2 : 4);
            } else {
                this.reader = null;
                this.maxFixedNodeOrderId = 0;
                this.orderIdWidth = 0;
            }
            this.loopExplosionMerges = loopExplosion.useExplosion() ? EconomicSet.create((Equivalence)Equivalence.IDENTITY) : null;
        }

        public boolean isInlinedMethod() {
            return false;
        }

        public NodeSourcePosition getCallerNodeSourcePosition() {
            return null;
        }

        public NodeSourcePosition getNodeSourcePosition(NodeSourcePosition position) {
            return position;
        }

        public void replaceLogsForDecodedGraph() {
            if (this.inliningLog != null) {
                GraphDecoder.this.graph.setInliningLog(this.inliningLog);
            }
            if (this.optimizationLog != null) {
                GraphDecoder.this.graph.setOptimizationLog(this.optimizationLog);
            }
        }
    }

    protected static class LoopScope {
        public final MethodScope methodScope;
        public final LoopScope outer;
        public final int loopDepth;
        public final int loopIteration;
        final LoopScopeTrigger trigger;
        public Deque<LoopScope> nextIterationFromLoopExitDuplication;
        public Deque<LoopScope> nextIterationFromLoopEndDuplication;
        public Deque<LoopScope> nextIterationsFromUnrolling;
        public final EconomicMap<LoopExplosionState, LoopExplosionState> iterationStates;
        public final int loopBeginOrderId;
        public final BitSet nodesToProcess;
        public final Node[] createdNodes;
        public final Node[] initialCreatedNodes;

        protected LoopScope(MethodScope methodScope) {
            this.methodScope = methodScope;
            this.outer = null;
            this.nextIterationFromLoopExitDuplication = methodScope.loopExplosion.duplicateLoopExits() || methodScope.loopExplosion.mergeLoops() ? new ArrayDeque<LoopScope>(2) : null;
            this.nextIterationFromLoopEndDuplication = methodScope.loopExplosion.duplicateLoopEnds() ? new ArrayDeque(2) : null;
            this.nextIterationsFromUnrolling = methodScope.loopExplosion.unrollLoops() ? new ArrayDeque(2) : null;
            this.loopDepth = 0;
            this.loopIteration = 0;
            this.iterationStates = null;
            this.loopBeginOrderId = -1;
            int nodeCount = methodScope.encodedGraph.nodeStartOffsets.length;
            this.nodesToProcess = new BitSet(methodScope.maxFixedNodeOrderId);
            this.createdNodes = new Node[nodeCount];
            this.initialCreatedNodes = null;
            this.trigger = LoopScopeTrigger.START;
        }

        protected LoopScope(MethodScope methodScope, LoopScope outer, int loopDepth, int loopIteration, int loopBeginOrderId, LoopScopeTrigger trigger, Node[] initialCreatedNodes, Node[] createdNodes, Deque<LoopScope> nextIterationFromLoopExitDuplication, Deque<LoopScope> nextIterationFromLoopEndDuplication, Deque<LoopScope> nextIterationsFromUnrolling, EconomicMap<LoopExplosionState, LoopExplosionState> iterationStates) {
            this.methodScope = methodScope;
            this.outer = outer;
            this.loopDepth = loopDepth;
            this.loopIteration = loopIteration;
            this.trigger = trigger;
            this.nextIterationFromLoopExitDuplication = nextIterationFromLoopExitDuplication;
            this.nextIterationFromLoopEndDuplication = nextIterationFromLoopEndDuplication;
            this.nextIterationsFromUnrolling = nextIterationsFromUnrolling;
            this.iterationStates = iterationStates;
            this.loopBeginOrderId = loopBeginOrderId;
            this.nodesToProcess = new BitSet(methodScope.maxFixedNodeOrderId);
            this.initialCreatedNodes = initialCreatedNodes;
            this.createdNodes = createdNodes;
        }

        public String toString() {
            return this.loopDepth + "," + this.loopIteration + (String)(this.loopBeginOrderId == -1 ? "" : "#" + this.loopBeginOrderId) + " triggered by " + String.valueOf((Object)this.trigger);
        }

        public boolean hasIterationsToProcess() {
            return this.nextIterationFromLoopEndDuplication != null && !this.nextIterationFromLoopEndDuplication.isEmpty() || this.nextIterationFromLoopExitDuplication != null && !this.nextIterationFromLoopExitDuplication.isEmpty() || this.nextIterationsFromUnrolling != null && !this.nextIterationsFromUnrolling.isEmpty();
        }

        public LoopScope getNextIterationToProcess(boolean remove) {
            if (this.nextIterationFromLoopEndDuplication != null && !this.nextIterationFromLoopEndDuplication.isEmpty()) {
                return remove ? this.nextIterationFromLoopEndDuplication.removeFirst() : this.nextIterationFromLoopEndDuplication.peekFirst();
            }
            if (this.nextIterationFromLoopExitDuplication != null && !this.nextIterationFromLoopExitDuplication.isEmpty()) {
                return remove ? this.nextIterationFromLoopExitDuplication.removeFirst() : this.nextIterationFromLoopExitDuplication.peekFirst();
            }
            if (this.nextIterationsFromUnrolling != null && !this.nextIterationsFromUnrolling.isEmpty()) {
                return remove ? this.nextIterationsFromUnrolling.removeFirst() : this.nextIterationsFromUnrolling.peekFirst();
            }
            return null;
        }
    }

    public static enum LoopScopeTrigger {
        START,
        LOOP_BEGIN_UNROLLING,
        LOOP_END_DUPLICATION,
        LOOP_EXIT_DUPLICATION;

    }

    protected static class InvokeData
    extends InvokableData<Invoke> {
        public final int callTargetOrderId;
        public final boolean intrinsifiedMethodHandle;
        public JavaConstant constantReceiver;
        public CallTargetNode callTarget;
        public FixedWithNextNode invokePredecessor;

        static InvokeData createFrom(InvokableData<? extends Invoke> from, int callTargetOrderId, boolean intrinsifiedMethodHandle) {
            return new InvokeData((Invoke)from.invoke, from.contextType, from.orderId, callTargetOrderId, intrinsifiedMethodHandle, from.stateAfterOrderId, from.nextOrderId, from.exceptionOrderId, from.exceptionStateOrderId, from.exceptionNextOrderId);
        }

        public InvokeData(Invoke invoke, ResolvedJavaType contextType, int invokeOrderId, int callTargetOrderId, boolean intrinsifiedMethodHandle, int stateAfterOrderId, int nextOrderId, int exceptionOrderId, int exceptionStateOrderId, int exceptionNextOrderId) {
            super(invoke, contextType, invokeOrderId, stateAfterOrderId, nextOrderId, exceptionOrderId, exceptionStateOrderId, exceptionNextOrderId);
            this.callTargetOrderId = callTargetOrderId;
            this.intrinsifiedMethodHandle = intrinsifiedMethodHandle;
        }
    }

    protected static class InvokableData<T extends Invokable> {
        public final T invoke;
        public final ResolvedJavaType contextType;
        public final int orderId;
        public final int stateAfterOrderId;
        public final int nextOrderId;
        public final int exceptionOrderId;
        public final int exceptionStateOrderId;
        public final int exceptionNextOrderId;

        protected InvokableData(T invoke, ResolvedJavaType contextType, int orderId, int stateAfterOrderId, int nextOrderId, int exceptionOrderId, int exceptionStateOrderId, int exceptionNextOrderId) {
            this.invoke = invoke;
            this.contextType = contextType;
            this.orderId = orderId;
            this.stateAfterOrderId = stateAfterOrderId;
            this.nextOrderId = nextOrderId;
            this.exceptionOrderId = exceptionOrderId;
            this.exceptionStateOrderId = exceptionStateOrderId;
            this.exceptionNextOrderId = exceptionNextOrderId;
        }
    }

    protected static class LoopExplosionState {
        public final FrameState state;
        public final MergeNode merge;
        public final int hashCode;

        protected LoopExplosionState(FrameState state, MergeNode merge) {
            this.state = state;
            this.merge = merge;
            int h = 0;
            for (ValueNode value : state.values()) {
                if (value == null) {
                    h = h * 31 + 1234;
                    continue;
                }
                h = h * 31 + ProxyPlaceholder.unwrap(value).hashCode();
            }
            this.hashCode = h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LoopExplosionState)) {
                return false;
            }
            FrameState otherState = ((LoopExplosionState)obj).state;
            FrameState thisState = this.state;
            assert (thisState.outerFrameState() == otherState.outerFrameState()) : Assertions.errorMessage(thisState, thisState.outerFrameState(), otherState, otherState.outerFrameState());
            Iterator thisIter = thisState.values().iterator();
            Iterator otherIter = otherState.values().iterator();
            while (thisIter.hasNext() && otherIter.hasNext()) {
                ValueNode otherValue;
                ValueNode thisValue = ProxyPlaceholder.unwrap((ValueNode)thisIter.next());
                if (thisValue == (otherValue = ProxyPlaceholder.unwrap((ValueNode)otherIter.next()))) continue;
                return false;
            }
            return thisIter.hasNext() == otherIter.hasNext();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    protected static final class ProxyPlaceholder
    extends FloatingNode
    implements Canonicalizable {
        public static final NodeClass<ProxyPlaceholder> TYPE = NodeClass.create(ProxyPlaceholder.class);
        @Node.Input
        ValueNode value;
        @Node.Input(value=InputType.Association)
        Node proxyPoint;

        public ProxyPlaceholder(ValueNode value, MergeNode proxyPoint) {
            super((NodeClass<? extends FloatingNode>)TYPE, value.stamp(NodeView.DEFAULT));
            this.value = value;
            this.proxyPoint = proxyPoint;
        }

        void setValue(ValueNode value) {
            this.updateUsages(this.value, value);
            this.value = value;
        }

        @Override
        public Node canonical(CanonicalizerTool tool) {
            if (tool.allUsagesAvailable()) {
                return this.value;
            }
            return this;
        }

        public static ValueNode unwrap(ValueNode value) {
            ValueNode result = value;
            while (result instanceof ProxyPlaceholder) {
                result = ((ProxyPlaceholder)result).value;
            }
            return result;
        }
    }
}

