/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.ProfileData;

@NodeInfo
public abstract class ControlSplitNode
extends FixedNode {
    public static final NodeClass<ControlSplitNode> TYPE = NodeClass.create(ControlSplitNode.class);

    protected ControlSplitNode(NodeClass<? extends ControlSplitNode> c, Stamp stamp) {
        super((NodeClass<? extends FixedNode>)c, stamp);
    }

    public abstract double probability(AbstractBeginNode var1);

    public abstract boolean setProbability(AbstractBeginNode var1, ProfileData.BranchProbabilityData var2);

    public double[] successorProbabilities() {
        double[] probabilities = new double[this.getSuccessorCount()];
        int index = 0;
        for (Node succ : this.successors()) {
            probabilities[index++] = this.probability((AbstractBeginNode)succ);
        }
        assert (index == this.getSuccessorCount()) : Assertions.errorMessage(index, this.getSuccessorCount());
        return probabilities;
    }

    public abstract AbstractBeginNode getPrimarySuccessor();

    public abstract int getSuccessorCount();

    public abstract ProfileData getProfileData();
}

