/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(allowedUsageTypes={InputType.Extension}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public abstract class CallTargetNode
extends ValueNode
implements LIRLowerable {
    public static final NodeClass<CallTargetNode> TYPE = NodeClass.create(CallTargetNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    protected ResolvedJavaMethod targetMethod;
    protected ResolvedJavaType referencedType;
    protected InvokeKind invokeKind;
    protected final StampPair returnStamp;

    protected CallTargetNode(NodeClass<? extends CallTargetNode> c, ValueNode[] arguments, ResolvedJavaMethod targetMethod, InvokeKind invokeKind, StampPair returnStamp) {
        super(c, StampFactory.forVoid());
        this.targetMethod = targetMethod;
        this.invokeKind = invokeKind;
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.returnStamp = returnStamp;
    }

    public NodeInputList<ValueNode> arguments() {
        return this.arguments;
    }

    public StampPair returnStamp() {
        return this.returnStamp;
    }

    public abstract String targetName();

    @Override
    public void generate(NodeLIRBuilderTool gen) {
    }

    public void setTargetMethod(ResolvedJavaMethod targetMethod) {
        this.targetMethod = targetMethod;
    }

    public ResolvedJavaMethod targetMethod() {
        return this.targetMethod;
    }

    public void setReferencedType(ResolvedJavaType referencedType) {
        this.referencedType = referencedType;
    }

    public ResolvedJavaType referencedType() {
        return this.referencedType;
    }

    public InvokeKind invokeKind() {
        return this.invokeKind;
    }

    public void setInvokeKind(InvokeKind kind) {
        this.invokeKind = kind;
    }

    public Invoke invoke() {
        return (Invoke)((Object)this.usages().first());
    }

    public static enum InvokeKind {
        Interface(false),
        Special(true),
        Static(true),
        Virtual(false);

        private final boolean direct;

        private InvokeKind(boolean direct) {
            this.direct = direct;
        }

        public boolean hasReceiver() {
            return this != Static;
        }

        public boolean isDirect() {
            return this.direct;
        }

        public boolean isIndirect() {
            return !this.direct;
        }

        public boolean isInterface() {
            return this == Interface;
        }
    }
}

