/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.DeoptimizingFixedWithNextNode;
import jdk.graal.compiler.nodes.DeoptimizingGuard;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNegationNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.SpeculationLog;

@NodeInfo
public abstract class AbstractFixedGuardNode
extends DeoptimizingFixedWithNextNode
implements Simplifiable,
GuardingNode,
DeoptimizingGuard {
    public static final NodeClass<AbstractFixedGuardNode> TYPE = NodeClass.create(AbstractFixedGuardNode.class);
    @Node.Input(value=InputType.Condition)
    protected LogicNode condition;
    protected DeoptimizationReason reason;
    protected DeoptimizationAction action;
    protected SpeculationLog.Speculation speculation;
    protected boolean negated;
    protected NodeSourcePosition noDeoptSuccessorPosition;

    @Override
    public LogicNode getCondition() {
        return this.condition;
    }

    public LogicNode condition() {
        return this.getCondition();
    }

    @Override
    public void setCondition(LogicNode x, boolean negated) {
        this.updateUsages(this.condition, x);
        this.condition = x;
        this.negated = negated;
    }

    protected AbstractFixedGuardNode(NodeClass<? extends AbstractFixedGuardNode> c, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated) {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)c, StampFactory.forVoid());
        this.action = action;
        assert (speculation != null);
        this.speculation = speculation;
        this.negated = negated;
        this.condition = condition;
        this.reason = deoptReason;
    }

    protected AbstractFixedGuardNode(NodeClass<? extends AbstractFixedGuardNode> c, LogicNode condition, DeoptimizationReason deoptReason, DeoptimizationAction action, SpeculationLog.Speculation speculation, boolean negated, NodeSourcePosition noDeoptSuccessorPosition) {
        this(c, condition, deoptReason, action, speculation, negated);
        this.noDeoptSuccessorPosition = noDeoptSuccessorPosition;
    }

    @Override
    public DeoptimizationReason getReason() {
        return this.reason;
    }

    @Override
    public DeoptimizationAction getAction() {
        return this.action;
    }

    @Override
    public SpeculationLog.Speculation getSpeculation() {
        return this.speculation;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name && this.negated) {
            return "!" + super.toString(verbosity);
        }
        return super.toString(verbosity);
    }

    @Override
    public void simplify(SimplifierTool tool) {
        boolean simplifiedNegation = false;
        while (this.condition instanceof LogicNegationNode) {
            LogicNegationNode negation = (LogicNegationNode)this.condition;
            this.setCondition(negation.getValue(), !this.negated);
            simplifiedNegation = true;
        }
        if (simplifiedNegation) {
            tool.addToWorkList(this.condition);
        }
    }

    public DeoptimizeNode lowerToIf() {
        try (DebugCloseable position = this.withNodeSourcePosition();){
            AbstractBeginNode noDeoptSuccessor;
            IfNode ifNode;
            FixedNode currentNext = this.next();
            this.setNext(null);
            if (currentNext instanceof AbstractBeginNode && currentNext instanceof StateSplit && ((StateSplit)((Object)currentNext)).stateAfter() != null) {
                BeginNode begin = this.graph().add(new BeginNode());
                begin.setNodeSourcePosition(this.getNoDeoptSuccessorPosition());
                begin.setNext(currentNext);
                currentNext = begin;
            }
            DeoptimizeNode deopt = this.graph().add(new DeoptimizeNode(this.action, this.reason, this.speculation));
            deopt.setStateBefore(this.stateBefore());
            if (this.negated) {
                ifNode = this.graph().add(new IfNode(this.condition, deopt, currentNext, BranchProbabilityNode.NEVER_TAKEN_PROFILE));
                noDeoptSuccessor = ifNode.falseSuccessor();
            } else {
                ifNode = this.graph().add(new IfNode(this.condition, currentNext, deopt, BranchProbabilityNode.ALWAYS_TAKEN_PROFILE));
                noDeoptSuccessor = ifNode.trueSuccessor();
            }
            noDeoptSuccessor.setNodeSourcePosition(this.getNoDeoptSuccessorPosition());
            ((FixedWithNextNode)this.predecessor()).setNext(ifNode);
            this.replaceAtUsages(noDeoptSuccessor);
            GraphUtil.killWithUnusedFloatingInputs(this);
            DeoptimizeNode deoptimizeNode = deopt;
            return deoptimizeNode;
        }
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void setAction(DeoptimizationAction action) {
        this.action = action;
    }

    @Override
    public void setReason(DeoptimizationReason reason) {
        this.reason = reason;
    }

    @Override
    public NodeSourcePosition getNoDeoptSuccessorPosition() {
        return this.noDeoptSuccessorPosition;
    }

    @Override
    public void setNoDeoptSuccessorPosition(NodeSourcePosition noDeoptSuccessorPosition) {
        this.noDeoptSuccessorPosition = noDeoptSuccessorPosition;
    }
}

