/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.meta.MetaAccessProvider;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, cyclesRationale="The cycles for a deopt are as high as possible as we continue execution in the interpreter, but they pollute the cost model, thus we do not care about their cycles.", size=NodeSize.SIZE_UNKNOWN, sizeRationale="Deopts carry the meta information necessary to map the state back in the interpreter, but they pollute the cost model,thus we do not care about their size.")
public abstract class AbstractDeoptimizeNode
extends ControlSinkNode
implements IterableNodeType,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<AbstractDeoptimizeNode> TYPE = NodeClass.create(AbstractDeoptimizeNode.class);
    @Node.OptionalInput(value=InputType.State)
    FrameState stateBefore;

    protected AbstractDeoptimizeNode(NodeClass<? extends AbstractDeoptimizeNode> c, FrameState stateBefore) {
        super((NodeClass<? extends ControlSinkNode>)c, StampFactory.forVoid());
        this.stateBefore = stateBefore;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    public abstract ValueNode getActionAndReason(MetaAccessProvider var1);

    public abstract ValueNode getSpeculation(MetaAccessProvider var1);
}

