/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.RetryableBailoutException;
import jdk.graal.compiler.core.common.calc.CanonicalCondition;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardPhiNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.extended.OpaqueNode;
import jdk.graal.compiler.nodes.extended.SwitchNode;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.DefaultLoopPolicies;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopFragment;
import jdk.graal.compiler.nodes.loop.LoopFragmentInside;
import jdk.graal.compiler.nodes.loop.LoopFragmentWhole;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.util.IntegerHelper;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.graal.compiler.phases.common.util.LoopUtility;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public abstract class LoopTransformations {
    private LoopTransformations() {
    }

    public static LoopFragmentInside peel(Loop loop) {
        loop.detectCounted();
        double frequencyBefore = loop.localLoopFrequency();
        AbstractBeginNode mainExit = null;
        if (loop.isCounted()) {
            mainExit = loop.counted().getCountedExit();
        } else if (loop.loopBegin().loopExits().count() == 1 && !((mainExit = (AbstractBeginNode)loop.loopBegin().loopExits().first()).predecessor() instanceof IfNode)) {
            mainExit = null;
        }
        LoopFragmentInside inside = loop.inside().duplicate();
        inside.insertBefore(loop);
        loop.loopBegin().incrementPeelings();
        loop.loopBegin().graph().getOptimizationLog().withProperty("peelings", loop.loopBegin().peelings()).report(LoopTransformations.class, "LoopPeeling", loop.loopBegin());
        if (mainExit != null) {
            LoopTransformations.adaptCountedLoopExitProbability(mainExit, frequencyBefore - 1.0);
        }
        return inside;
    }

    public static void fullUnroll(Loop loop, CoreProviders context, CanonicalizerPhase canonicalizer) {
        LoopBeginNode loopBegin = loop.loopBegin();
        StructuredGraph graph = loopBegin.graph();
        int initialNodeCount = graph.getNodeCount();
        SimplifierTool defaultSimplifier = GraphUtil.getDefaultSimplifier(context, canonicalizer.getCanonicalizeReads(), graph.getAssumptions(), graph.getOptions());
        CanonicalizerPhase c = canonicalizer.copyWithoutSimplification();
        EconomicSetNodeEventListener l = new EconomicSetNodeEventListener();
        int peelings = 0;
        try (Graph.NodeEventScope ev = graph.trackNodeEvents(l);){
            while (!loopBegin.isDeleted()) {
                Graph.Mark newNodes = graph.getMark();
                EconomicSetNodeEventListener peeledListener = new EconomicSetNodeEventListener();
                try (Graph.NodeEventScope peeledScope = graph.trackNodeEvents(peeledListener);){
                    LoopTransformations.peel(loop);
                }
                c.applyIncremental(graph, context, (Iterable<? extends Node>)peeledListener.getNodes());
                loop.invalidateFragmentsAndIVs();
                for (Node n : graph.getNewNodes(newNodes)) {
                    if (!n.isAlive() || !(n instanceof IfNode) && !(n instanceof SwitchNode) && !(n instanceof FixedGuardNode) && !(n instanceof BeginNode)) continue;
                    Simplifiable s = (Simplifiable)((Object)n);
                    s.simplify(defaultSimplifier);
                    graph.getOptimizationLog().report(LoopTransformations.class, "LoopFullUnrollCfgSimplification", n);
                }
                if (graph.getNodeCount() > initialNodeCount + GraalOptions.MaximumDesiredSize.getValue(graph.getOptions()) * 2 || peelings > DefaultLoopPolicies.Options.FullUnrollMaxIterations.getValue(graph.getOptions())) {
                    throw new RetryableBailoutException("FullUnroll : Graph seems to grow out of proportion");
                }
                ++peelings;
            }
        }
        canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)l.getNodes());
        loop.loopBegin().graph().getOptimizationLog().report(LoopTransformations.class, "LoopFullUnroll", loop.loopBegin());
    }

    public static void unswitch(Loop loop, List<ControlSplitNode> controlSplitNodeSet, boolean isTrivialUnswitch) {
        ControlSplitNode firstNode = controlSplitNodeSet.iterator().next();
        StructuredGraph graph = firstNode.graph();
        graph.getDebug().dump(3, (Object)graph, "Before unswitching %s", controlSplitNodeSet);
        LoopFragmentWhole originalLoop = loop.whole();
        if (!isTrivialUnswitch) {
            loop.loopBegin().incrementUnswitches();
        }
        ControlSplitNode newControlSplit = (ControlSplitNode)firstNode.copyWithInputs();
        originalLoop.entryPoint().replaceAtPredecessor(newControlSplit);
        Iterator<Position> successors = firstNode.successorPositions().iterator();
        assert (successors.hasNext());
        Position firstPosition = successors.next();
        AbstractBeginNode originalLoopBegin = BeginNode.begin(originalLoop.entryPoint());
        firstPosition.set(newControlSplit, originalLoopBegin);
        originalLoopBegin.setNodeSourcePosition(firstPosition.get(firstNode).getNodeSourcePosition());
        while (successors.hasNext()) {
            Position position = successors.next();
            LoopFragmentWhole duplicateLoop = originalLoop.duplicate();
            AbstractBeginNode newBegin = BeginNode.begin(duplicateLoop.entryPoint());
            newBegin.setNodeSourcePosition(position.get(firstNode).getNodeSourcePosition());
            position.set(newControlSplit, newBegin);
            for (ControlSplitNode controlSplitNode : controlSplitNodeSet) {
                ControlSplitNode duplicatedControlSplit = (ControlSplitNode)duplicateLoop.getDuplicatedNode(controlSplitNode);
                if (!duplicatedControlSplit.isAlive()) continue;
                AbstractBeginNode survivingSuccessor = (AbstractBeginNode)position.get(duplicatedControlSplit);
                survivingSuccessor.replaceAtUsages((Node)newBegin, InputType.Guard);
                graph.removeSplitPropagate(duplicatedControlSplit, survivingSuccessor);
            }
        }
        for (ControlSplitNode controlSplitNode : controlSplitNodeSet) {
            if (!controlSplitNode.isAlive()) continue;
            AbstractBeginNode survivingSuccessor = (AbstractBeginNode)firstPosition.get(controlSplitNode);
            survivingSuccessor.replaceAtUsages((Node)originalLoopBegin, InputType.Guard);
            graph.removeSplitPropagate(controlSplitNode, survivingSuccessor);
        }
        loop.loopBegin().graph().getOptimizationLog().withProperty("unswitches", loop.loopBegin().unswitches()).report(LoopTransformations.class, "LoopUnswitching", loop.loopBegin());
    }

    public static void partialUnroll(Loop loop, EconomicMap<LoopBeginNode, OpaqueNode> opaqueUnrolledStrides) {
        assert (loop.loopBegin().isMainLoop());
        LoopTransformations.adaptCountedLoopExitProbability(loop.counted().getCountedExit(), loop.localLoopFrequency() / 2.0);
        LoopFragmentInside newSegment = loop.inside().duplicate();
        newSegment.insertWithinAfter(loop, opaqueUnrolledStrides);
        loop.loopBegin().graph().getOptimizationLog().withProperty("unrollFactor", loop.loopBegin().getUnrollFactor()).report(LoopTransformations.class, "LoopPartialUnroll", loop.loopBegin());
    }

    public static void ensureExitsHaveUniqueStates(Loop loop) {
        if (loop.loopBegin().graph().getGuardsStage().areFrameStatesAtDeopts()) {
            return;
        }
        for (LoopExitNode lex : loop.loopBegin().loopExits()) {
            FrameState oldState = lex.stateAfter();
            lex.setStateAfter(lex.stateAfter().duplicateWithVirtualState());
            if (!oldState.hasNoUsages()) continue;
            GraphUtil.killWithUnusedFloatingInputs(oldState);
        }
        loop.invalidateFragmentsAndIVs();
    }

    public static PreMainPostResult insertPrePostLoops(Loop loop) {
        assert (loop.loopBegin().loopExits().isEmpty() || loop.loopBegin().graph().isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) || loop.counted().getCountedExit() instanceof LoopExitNode) : "Can only unroll loops, if they have exits, if the counted exit is a regular loop exit " + String.valueOf(loop);
        StructuredGraph graph = loop.loopBegin().graph();
        LoopTransformations.ensureExitsHaveUniqueStates(loop);
        graph.getDebug().log("LoopTransformations.insertPrePostLoops %s", loop);
        LoopFragmentWhole preLoop = loop.whole();
        CountedLoopInfo preCounted = loop.counted();
        LoopBeginNode preLoopBegin = loop.loopBegin();
        AbstractBeginNode preLoopExitNode = preCounted.getCountedExit();
        assert (preLoop.nodes().contains(preLoopBegin));
        assert (preLoop.nodes().contains(preLoopExitNode));
        LoopFragmentWhole mainLoop = preLoop.duplicate();
        LoopBeginNode mainLoopBegin = (LoopBeginNode)mainLoop.getDuplicatedNode(preLoopBegin);
        AbstractBeginNode mainLoopExitNode = (AbstractBeginNode)mainLoop.getDuplicatedNode(preLoopExitNode);
        EndNode mainEndNode = LoopTransformations.getBlockEndAfterLoopExit(mainLoopExitNode);
        AbstractMergeNode mainMergeNode = mainEndNode.merge();
        graph.getDebug().dump(5, (Object)graph, "After  duplication of main loop %s", mainLoop);
        LoopFragmentWhole postLoop = preLoop.duplicate();
        LoopBeginNode postLoopBegin = (LoopBeginNode)postLoop.getDuplicatedNode(preLoopBegin);
        AbstractBeginNode postLoopExitNode = (AbstractBeginNode)postLoop.getDuplicatedNode(preLoopExitNode);
        EndNode postEndNode = LoopTransformations.getBlockEndAfterLoopExit(postLoopExitNode);
        AbstractMergeNode postMergeNode = postEndNode.merge();
        graph.getDebug().dump(5, graph, "After post loop duplication");
        preLoopBegin.incrementSplits();
        preLoopBegin.incrementSplits();
        preLoopBegin.setPreLoop();
        mainLoopBegin.setMainLoop();
        postLoopBegin.setPostLoop();
        if (graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            LoopTransformations.cleanupAndDeleteState(mainMergeNode);
            LoopTransformations.cleanupPostDominatingValues(mainLoopBegin, mainMergeNode, postEndNode);
            LoopTransformations.removeStateAndPhis(postMergeNode);
            LoopTransformations.createExitState(preLoopBegin, (LoopExitNode)preLoopExitNode, loop.counted().isInverted(), preLoop);
            LoopTransformations.createExitState(mainLoopBegin, (LoopExitNode)mainLoopExitNode, loop.counted().isInverted(), mainLoop);
        }
        assert (graph.isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) || preLoopExitNode instanceof LoopExitNode) : "Unrolling with proxies requires actual loop exit nodes as counted exits";
        LoopTransformations.rewirePreToMainPhis(preLoopBegin, mainLoop, preLoop, graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) ? (LoopExitNode)preLoopExitNode : null, loop.counted().isInverted());
        EndNode postEntryNode = postLoopBegin.forwardEnd();
        FixedNode continuationNode = mainMergeNode.next();
        AbstractBeginNode mainLandingNode = BeginNode.begin(postEntryNode);
        mainLoopExitNode.setNext(mainLandingNode);
        preLoopExitNode.setNext(mainLoopBegin.forwardEnd());
        assert (graph.isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) || mainLoopExitNode instanceof LoopExitNode) : "Unrolling with proxies requires actual loop exit nodes as counted exits";
        LoopTransformations.processPreLoopPhis(loop, graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) ? (LoopExitNode)mainLoopExitNode : null, mainLoop, postLoop);
        graph.getDebug().dump(5, graph, "After processing pre loop phis");
        continuationNode.predecessor().clearSuccessors();
        postLoopExitNode.setNext(continuationNode);
        LoopTransformations.cleanupMerge(postMergeNode, postLoopExitNode);
        LoopTransformations.cleanupMerge(mainMergeNode, mainLandingNode);
        if (graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            loop.resetCounted();
            loop.detectCounted();
            LoopTransformations.updatePreLoopLimit(loop.counted());
        } else {
            LoopTransformations.updatePreLoopLimit(preCounted);
        }
        graph.getDebug().dump(5, graph, "After updating preloop limit");
        double originalFrequency = loop.localLoopFrequency();
        preLoopBegin.setLoopOrigFrequency(originalFrequency);
        mainLoopBegin.setLoopOrigFrequency(originalFrequency);
        postLoopBegin.setLoopOrigFrequency(originalFrequency);
        assert (preLoopExitNode.predecessor() instanceof IfNode) : Assertions.errorMessage(preLoopExitNode);
        assert (mainLoopExitNode.predecessor() instanceof IfNode) : Assertions.errorMessage(mainLoopExitNode);
        assert (postLoopExitNode.predecessor() instanceof IfNode) : Assertions.errorMessage(postLoopExitNode);
        LoopTransformations.setSingleVisitedLoopFrequencySplitProbability(preLoopExitNode);
        LoopTransformations.setSingleVisitedLoopFrequencySplitProbability(postLoopExitNode);
        if (graph.isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            for (SafepointNode safepoint : preLoop.nodes().filter(SafepointNode.class)) {
                graph.removeFixed(safepoint);
            }
            for (SafepointNode safepoint : postLoop.nodes().filter(SafepointNode.class)) {
                graph.removeFixed(safepoint);
            }
        }
        graph.getOptimizationLog().report(LoopTransformations.class, "PreMainPostInsertion", loop.loopBegin());
        return new PreMainPostResult(preLoopBegin, mainLoopBegin, postLoopBegin, preLoop, mainLoop, postLoop);
    }

    private static void setSingleVisitedLoopFrequencySplitProbability(AbstractBeginNode lex) {
        IfNode ifNode = (IfNode)lex.predecessor();
        boolean trueSucc = ifNode.trueSuccessor() == lex;
        ifNode.setTrueSuccessorProbability(ProfileData.BranchProbabilityData.injected(0.01, trueSucc));
    }

    public static void adaptCountedLoopExitProbability(AbstractBeginNode lex, double newFrequency) {
        double probability = 1.0 - 1.0 / newFrequency;
        if (probability <= 0.0) {
            LoopTransformations.setSingleVisitedLoopFrequencySplitProbability(lex);
            return;
        }
        IfNode ifNode = (IfNode)lex.predecessor();
        boolean trueSucc = ifNode.trueSuccessor() == lex;
        ifNode.setTrueSuccessorProbability(ProfileData.BranchProbabilityData.injected(probability, trueSucc));
    }

    private static void cleanupPostDominatingValues(LoopBeginNode mainLoopBegin, AbstractMergeNode mainMergeNode, AbstractEndNode postEndNode) {
        for (LoopExitNode exit : mainLoopBegin.loopExits()) {
            for (ProxyNode proxy : exit.proxies()) {
                for (Node usage : proxy.usages().snapshot()) {
                    if (!(usage instanceof PhiNode) || ((PhiNode)usage).merge() != mainMergeNode) continue;
                    assert (usage instanceof PhiNode) : Assertions.errorMessage(usage);
                    PhiNode pUsage = (PhiNode)usage;
                    ValueNode v = pUsage.valueAt(0);
                    assert (v instanceof PhiNode) : Assertions.errorMessage(v);
                    PhiNode vP = (PhiNode)v;
                    usage.replaceAtUsages(vP.valueAt(postEndNode));
                    usage.safeDelete();
                }
            }
        }
        mainLoopBegin.graph().getDebug().dump(5, mainLoopBegin.graph(), "After fixing post dominating proxy usages");
    }

    private static void rewirePreToMainPhis(LoopBeginNode preLoopBegin, LoopFragment mainLoop, LoopFragment preLoop, LoopExitNode preLoopCountedExit, boolean inverted) {
        for (PhiNode prePhiNode : preLoopBegin.phis()) {
            PhiNode mainPhiNode = (PhiNode)mainLoop.getDuplicatedNode(prePhiNode);
            LoopTransformations.rewirePhi(prePhiNode, mainPhiNode, preLoopCountedExit, preLoop, inverted);
        }
        preLoopBegin.graph().getDebug().dump(5, preLoopBegin.graph(), "After updating value flow from pre loop phi to main loop phi");
    }

    private static void cleanupAndDeleteState(StateSplit statesplit) {
        FrameState fs = statesplit.stateAfter();
        statesplit.setStateAfter(null);
        GraphUtil.killWithUnusedFloatingInputs(fs);
    }

    private static void removeStateAndPhis(AbstractMergeNode merge) {
        LoopTransformations.cleanupAndDeleteState(merge);
        for (PhiNode phi : merge.phis().snapshot()) {
            phi.safeDelete();
        }
        merge.graph().getDebug().dump(5, merge.graph(), "After deleting unused phis");
    }

    private static void createExitState(LoopBeginNode begin, final LoopExitNode lex, boolean inverted, final LoopFragment loop) {
        FrameState stateToUse = inverted ? GraphUtil.findLastFrameState((FixedNode)lex.predecessor()).duplicateWithVirtualState() : begin.stateAfter().duplicateWithVirtualState();
        stateToUse.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

            @Override
            public void apply(Node from, Position p) {
                ValueNode toProxy = (ValueNode)p.get(from);
                if (toProxy instanceof VirtualObjectNode) {
                    return;
                }
                ValueNode replacement = loop.contains(toProxy) ? lex.graph().addOrUnique(new ValueProxyNode(toProxy, lex)) : toProxy;
                p.set(from, replacement);
            }
        });
        lex.setStateAfter(stateToUse);
        begin.graph().getDebug().dump(5, begin.graph(), "After proxy-ing phis for exit state");
    }

    private static void cleanupMerge(AbstractMergeNode mergeNode, AbstractBeginNode landingNode) {
        for (EndNode end : mergeNode.cfgPredecessors().snapshot()) {
            mergeNode.removeEnd(end);
            end.safeDelete();
        }
        mergeNode.getDebug().dump(5, (Object)mergeNode.graph(), "After cleaning up merge %s", mergeNode);
        mergeNode.prepareDelete(landingNode);
        mergeNode.safeDelete();
    }

    private static void rewirePhi(PhiNode currentPhi, PhiNode outGoingPhi, LoopExitNode exitToProxy, LoopFragment loopToProxy, boolean inverted) {
        if (currentPhi.graph().isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) {
            ValueNode toProxy;
            ValueNode set = null;
            set = toProxy = inverted ? currentPhi.singleBackValueOrThis() : currentPhi;
            if (toProxy == null) {
                GraalError.guarantee(currentPhi instanceof GuardPhiNode, "Only guard phi nodes can have null inputs %s", (Object)currentPhi);
            } else if (loopToProxy.contains(toProxy)) {
                set = LoopFragmentInside.patchProxyAtPhi(currentPhi, exitToProxy, toProxy);
                assert (set != null);
            }
            outGoingPhi.setValueAt(0, set);
        } else {
            outGoingPhi.setValueAt(0, (ValueNode)currentPhi);
        }
    }

    private static void processPreLoopPhis(Loop preLoop, LoopExitNode mainLoopCountedExit, LoopFragmentWhole mainLoop, LoopFragmentWhole postLoop) {
        LoopBeginNode preLoopBegin = preLoop.loopBegin();
        StructuredGraph graph = preLoopBegin.graph();
        for (PhiNode prePhiNode : preLoopBegin.phis().snapshot()) {
            PhiNode postPhiNode = (PhiNode)postLoop.getDuplicatedNode(prePhiNode);
            PhiNode mainPhiNode = (PhiNode)mainLoop.getDuplicatedNode(prePhiNode);
            LoopTransformations.rewirePhi(mainPhiNode, postPhiNode, mainLoopCountedExit, mainLoop, preLoop.counted().isInverted());
            if (!graph.isAfterStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) continue;
            for (Node usage : prePhiNode.usages().snapshot()) {
                if (usage == mainPhiNode || !preLoop.isOutsideLoop(usage)) continue;
                usage.replaceFirstInput(prePhiNode, postPhiNode);
            }
            for (Node node : preLoop.inside().nodes()) {
                for (Node externalUsage : node.usages().snapshot()) {
                    if (!preLoop.isOutsideLoop(externalUsage)) continue;
                    Object postUsage = postLoop.getDuplicatedNode(node);
                    assert (postUsage != null);
                    externalUsage.replaceFirstInput(node, (Node)postUsage);
                }
            }
        }
    }

    private static EndNode getBlockEndAfterLoopExit(AbstractBeginNode exit) {
        FixedNode node = exit.next();
        return LoopTransformations.getBlockEnd(node);
    }

    private static EndNode getBlockEnd(FixedNode node) {
        FixedNode curNode = node;
        while (curNode instanceof FixedWithNextNode) {
            curNode = ((FixedWithNextNode)curNode).next();
        }
        return (EndNode)curNode;
    }

    private static void updatePreLoopLimit(CountedLoopInfo preCounted) {
        ValueNode newLimit = AddNode.add(preCounted.getBodyIVStart(), preCounted.getLimitCheckedIV().strideNode(), NodeView.DEFAULT);
        ValueNode ub = preCounted.getLimit();
        IntegerHelper helper = preCounted.getCounterIntegerHelper();
        LogicNode entryCheck = preCounted.getDirection() == InductionVariable.Direction.Up ? helper.createCompareNode(newLimit, ub, NodeView.DEFAULT) : helper.createCompareNode(ub, newLimit, NodeView.DEFAULT);
        newLimit = ConditionalNode.create(entryCheck, newLimit, ub, NodeView.DEFAULT);
        CompareNode compareNode = (CompareNode)preCounted.getLimitTest().condition();
        compareNode.replaceFirstInput(ub, compareNode.graph().addOrUniqueWithInputs(newLimit));
    }

    public static EconomicMap<ValueNode, List<ControlSplitNode>> findUnswitchable(Loop loop) {
        ValueNode invariantValue;
        EconomicMap controls = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        for (IfNode ifNode : loop.whole().nodes().filter(IfNode.class)) {
            if (!loop.isOutsideLoop(ifNode.condition())) continue;
            invariantValue = ifNode.condition();
            ArrayList<IfNode> ifs = (ArrayList<IfNode>)controls.get((Object)invariantValue);
            if (ifs == null) {
                ifs = new ArrayList<IfNode>();
                controls.put((Object)invariantValue, ifs);
            }
            ifs.add(ifNode);
        }
        for (SwitchNode switchNode : loop.whole().nodes().filter(SwitchNode.class)) {
            if (switchNode.successors().count() <= 1 || !loop.isOutsideLoop(switchNode.value())) continue;
            invariantValue = switchNode.value();
            ArrayList<SwitchNode> switchs = (ArrayList<SwitchNode>)controls.get((Object)invariantValue);
            if (switchs == null) {
                switchs = new ArrayList<SwitchNode>();
                switchs.add(switchNode);
                controls.put((Object)invariantValue, switchs);
                continue;
            }
            if (!((SwitchNode)switchs.get(0)).structureEquals(switchNode)) continue;
            switchs.add(switchNode);
        }
        return controls;
    }

    public static boolean countedLoopExitConditionHasMultipleUsages(Loop loop) {
        LogicNode condition = loop.counted().getLimitTest().condition();
        return condition.hasMoreThanOneUsage();
    }

    public static boolean strideAdditionOverflows(Loop loop) {
        int bits = ((IntegerStamp)loop.counted().getLimitCheckedIV().valueNode().stamp(NodeView.DEFAULT)).getBits();
        long stride = loop.counted().getLimitCheckedIV().constantStride();
        try {
            LoopUtility.addExact(bits, stride, stride);
            return false;
        }
        catch (ArithmeticException ae) {
            return true;
        }
    }

    public static boolean isUnrollableLoop(Loop loop) {
        if (!loop.isCounted() || !loop.counted().getLimitCheckedIV().isConstantStride() || !loop.getCFGLoop().getChildren().isEmpty() || loop.loopBegin().loopEnds().count() != 1 || loop.loopBegin().loopExits().count() > 1 || loop.counted().isInverted()) {
            return false;
        }
        assert (loop.counted().getDirection() != null);
        LoopBeginNode loopBegin = loop.loopBegin();
        LogicNode condition = loop.counted().getLimitTest().condition();
        if (!(condition instanceof CompareNode)) {
            return false;
        }
        if (((CompareNode)condition).condition() == CanonicalCondition.EQ) {
            condition.getDebug().log(3, "isUnrollableLoop %s condition unsupported %s ", (Object)loopBegin, (Object)((CompareNode)condition).condition());
            return false;
        }
        if (LoopTransformations.countedLoopExitConditionHasMultipleUsages(loop)) {
            return false;
        }
        if (LoopTransformations.strideAdditionOverflows(loop)) {
            condition.getDebug().log(3, "isUnrollableLoop %s doubling the stride overflows %d", (Object)loopBegin, (Object)loop.counted().getLimitCheckedIV().constantStride());
            return false;
        }
        if (!loop.canDuplicateLoop()) {
            return false;
        }
        if (loopBegin.isMainLoop() || loopBegin.isSimpleLoop()) {
            if (loop.getCFGLoop().getBlocks().size() < 3) {
                return true;
            }
            condition.getDebug().log(3, "isUnrollableLoop %s too large to unroll %s ", (Object)loopBegin, loop.getCFGLoop().getBlocks().size());
        }
        return false;
    }

    public static class PreMainPostResult {
        private final LoopBeginNode preLoop;
        private final LoopBeginNode mainLoop;
        private final LoopBeginNode postLoop;
        private final LoopFragment preLoopFragment;
        private final LoopFragment mainLoopFragment;
        private final LoopFragment postLoopFragment;

        public PreMainPostResult(LoopBeginNode preLoop, LoopBeginNode mainLoop, LoopBeginNode postLoop, LoopFragment preLoopFragment, LoopFragment mainLoopFragment, LoopFragment postLoopFragment) {
            this.preLoop = preLoop;
            this.mainLoop = mainLoop;
            this.postLoop = postLoop;
            this.preLoopFragment = preLoopFragment;
            this.mainLoopFragment = mainLoopFragment;
            this.postLoopFragment = postLoopFragment;
        }

        public LoopFragment getPreLoopFragment() {
            return this.preLoopFragment;
        }

        public LoopFragment getMainLoopFragment() {
            return this.mainLoopFragment;
        }

        public LoopFragment getPostLoopFragment() {
            return this.postLoopFragment;
        }

        public LoopBeginNode getMainLoop() {
            return this.mainLoop;
        }

        public LoopBeginNode getPostLoop() {
            return this.postLoop;
        }

        public LoopBeginNode getPreLoop() {
            return this.preLoop;
        }
    }
}

