/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Optional;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class LoopSafepointEliminationPhase
extends BasePhase<MidTierContext> {
    private static final long IntegerRangeDistance = NumUtil.unsafeAbs(0xFFFFFFFFL);

    public static boolean iterationRangeIsIn32Bit(Loop loop) {
        if (loop.counted().getStamp().getBits() <= 32) {
            return true;
        }
        Stamp limitStamp = loop.counted().getTripCountLimit().stamp(NodeView.DEFAULT);
        if (limitStamp instanceof IntegerStamp) {
            IntegerStamp limitIStamp = (IntegerStamp)limitStamp;
            long upperBoundLimit = limitIStamp.upperBound();
            Stamp startStamp = loop.counted().getBodyIVStart().stamp(NodeView.DEFAULT);
            if (startStamp instanceof IntegerStamp) {
                IntegerStamp startIStamp = (IntegerStamp)startStamp;
                long lowerBoundStart = startIStamp.lowerBound();
                if (IntegerStamp.subtractionOverflows(upperBoundLimit, lowerBoundStart, 64)) {
                    return false;
                }
                try {
                    long startToLimitDistance = NumUtil.safeAbs(upperBoundLimit - lowerBoundStart);
                    InductionVariable counter = loop.counted().getLimitCheckedIV();
                    long stride = counter.isConstantStride() ? NumUtil.safeAbs(counter.constantStride()) : 1L;
                    long strideRelativeStartToLimitDistance = startToLimitDistance / stride;
                    return strideRelativeStartToLimitDistance <= IntegerRangeDistance;
                }
                catch (ArithmeticException e) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.LOOP_OVERFLOWS_CHECKED, graphState);
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        new Instance(graph, context).optimizeSafepoints();
    }

    public static boolean canDisableSafepoint(FixedNode node, CoreProviders context) {
        if (node instanceof Invoke) {
            Invoke invoke = (Invoke)((Object)node);
            ResolvedJavaMethod method = invoke.getTargetMethod();
            return context.getMetaAccessExtensionProvider().isGuaranteedSafepoint(method, invoke.getInvokeKind().isDirect());
        }
        if (node instanceof ForeignCall) {
            return ((ForeignCall)((Object)node)).isGuaranteedSafepoint();
        }
        return false;
    }

    protected static class Instance {
        private final StructuredGraph graph;
        private final MidTierContext context;

        protected Instance(StructuredGraph graph, MidTierContext context) {
            this.graph = graph;
            this.context = context;
        }

        private int disableSafepointsByBodyNodes(Loop loop, ControlFlowGraph cfg) {
            int loopEndSafepointsDisabled = 0;
            block0: for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                for (HIRBlock b = cfg.blockFor(loopEnd); b != loop.getCFGLoop().getHeader(); b = (HIRBlock)b.getDominator()) {
                    assert (b != null);
                    for (FixedNode node : b.getNodes()) {
                        boolean canDisableSafepoint = LoopSafepointEliminationPhase.canDisableSafepoint(node, this.context);
                        boolean disabledInSubclass = this.onCallInLoop(loopEnd, node);
                        if (!canDisableSafepoint) continue;
                        loopEnd.disableSafepoint();
                        this.graph.getOptimizationLog().report(LoopSafepointEliminationPhase.class, "SafepointElimination", loop.loopBegin());
                        ++loopEndSafepointsDisabled;
                        if (!disabledInSubclass) continue;
                        continue block0;
                    }
                }
            }
            return loopEndSafepointsDisabled;
        }

        public void optimizeSafepoints() {
            boolean optimisticallyRemoveLoopSafepoints = Options.RemoveLoopSafepoints.getValue(this.graph.getOptions());
            LoopsData loops = this.context.getLoopsDataProvider().getLoopsData(this.graph);
            loops.detectCountedLoops();
            for (Loop loop : loops.loops()) {
                boolean allLoopEndSafepointsEnabled;
                int loopEndSafepointsDisabled;
                boolean allLoopEndSafepointsDisabled;
                if (!this.allowGuestSafepoints()) {
                    loop.loopBegin().disableGuestSafepoint(LoopBeginNode.SafepointState.MUST_NEVER_SAFEPOINT);
                }
                boolean bl = allLoopEndSafepointsDisabled = (loopEndSafepointsDisabled = this.disableSafepointsByBodyNodes(loop, loops.getCFG())) == loop.loopBegin().getLoopEndCount();
                if (!allLoopEndSafepointsDisabled && optimisticallyRemoveLoopSafepoints && this.optimizeSafepointsForCountedLoop(loop)) {
                    loopEndSafepointsDisabled = loop.loopBegin().getLoopEndCount();
                }
                if (!(allLoopEndSafepointsEnabled = loopEndSafepointsDisabled == 0)) continue;
                loop.loopBegin().disableLoopExitSafepoint(LoopBeginNode.SafepointState.OPTIMIZER_DISABLED);
            }
            loops.deleteUnusedNodes();
        }

        protected boolean allowGuestSafepoints() {
            return false;
        }

        protected boolean onCallInLoop(LoopEndNode loopEnd, FixedNode currentCallNode) {
            return true;
        }

        protected void onSafepointDisabledLoopBegin(Loop loop) {
        }

        private boolean optimizeSafepointsForCountedLoop(Loop loop) {
            if (loop.isCounted() && loop.getCFGLoop().getChildren().isEmpty() && (loop.loopBegin().isPreLoop() || loop.loopBegin().isPostLoop() || this.loopIsIn32BitRange(loop) || loop.loopBegin().isStripMinedInner())) {
                boolean hasSafepoint = false;
                for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                    hasSafepoint |= loopEnd.canSafepoint();
                }
                if (hasSafepoint) {
                    if (!loop.counted().counterNeverOverflows()) {
                        boolean allowsLoopLimitChecks = this.context.getOptimisticOptimizations().useLoopLimitChecks(this.graph.getOptions());
                        boolean allowsFloatingGuards = this.graph.getGuardsStage().allowsFloatingGuards();
                        if (allowsLoopLimitChecks && allowsFloatingGuards) {
                            loop.counted().createOverFlowGuard();
                        } else {
                            return false;
                        }
                    }
                    loop.loopBegin().disableSafepoint(LoopBeginNode.SafepointState.OPTIMIZER_DISABLED);
                    if (loop.loopBegin().isStripMinedInner()) {
                        loop.loopBegin().disableGuestSafepoint(LoopBeginNode.SafepointState.OPTIMIZER_DISABLED);
                    } else {
                        this.onSafepointDisabledLoopBegin(loop);
                    }
                    this.graph.getOptimizationLog().report(LoopSafepointEliminationPhase.class, "SafepointElimination", loop.loopBegin());
                    return true;
                }
            }
            return false;
        }

        public boolean loopIsIn32BitRange(Loop loop) {
            return LoopSafepointEliminationPhase.iterationRangeIsIn32Bit(loop);
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> RemoveLoopSafepoints = new OptionKey<Boolean>(true);
    }
}

