/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Optional;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.loop.phases.LoopPhase;
import jdk.graal.compiler.loop.phases.LoopTransformations;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.OpaqueNode;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LoopsDataProvider;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.util.EconomicSetNodeEventListener;
import jdk.graal.compiler.phases.common.util.LoopUtility;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class LoopPartialUnrollPhase
extends LoopPhase<LoopPolicies> {
    public LoopPartialUnrollPhase(LoopPolicies policies, CanonicalizerPhase canonicalizer) {
        super(policies, canonicalizer);
    }

    private void unroll(StructuredGraph graph, CoreProviders context) {
        Graph.NodeEventScope nes;
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        boolean changed = true;
        EconomicMap opaqueUnrolledStrides = null;
        NodeBitMap newMainLoops = null;
        while (changed) {
            changed = false;
            nes = graph.trackNodeEvents(listener);
            try {
                LoopsData dataCounted = context.getLoopsDataProvider().getLoopsData(graph);
                dataCounted.detectCountedLoops();
                graph.getDebug().log(2, "Detected %d counted loops", dataCounted.countedLoops().size());
                Graph.Mark mark = graph.getMark();
                for (Loop loop : dataCounted.countedLoops()) {
                    if (LoopTransformations.isUnrollableLoop(loop)) {
                        graph.getDebug().log(2, "Loop %s can be unrolled, now checking if we should", (Object)loop);
                        if (!this.getPolicies().shouldPartiallyUnroll(loop, context)) continue;
                        if (loop.loopBegin().isSimpleLoop()) {
                            LoopUtility.preserveCounterStampsForDivAfterUnroll(loop);
                            LoopTransformations.PreMainPostResult res = LoopTransformations.insertPrePostLoops(loop);
                            if (newMainLoops == null) {
                                newMainLoops = graph.createNodeBitMap();
                            }
                            newMainLoops.markAndGrow(res.getMainLoop());
                            changed = true;
                            continue;
                        }
                        if (newMainLoops == null || !newMainLoops.isMarkedAndGrow(loop.loopBegin())) continue;
                        if (opaqueUnrolledStrides == null) {
                            opaqueUnrolledStrides = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                        }
                        LoopTransformations.partialUnroll(loop, (EconomicMap<LoopBeginNode, OpaqueNode>)opaqueUnrolledStrides);
                        changed = true;
                        continue;
                    }
                    graph.getDebug().log(2, "Loop %s cannot be unrolled", (Object)loop);
                }
                dataCounted.deleteUnusedNodes();
                if (!listener.getNodes().isEmpty()) {
                    this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
                    listener.getNodes().clear();
                }
                assert (newMainLoops == null || LoopPartialUnrollPhase.checkCounted(graph, context.getLoopsDataProvider(), mark));
            }
            finally {
                if (nes == null) continue;
                nes.close();
            }
        }
        if (opaqueUnrolledStrides != null) {
            nes = graph.trackNodeEvents(listener);
            try {
                for (OpaqueNode opaque : opaqueUnrolledStrides.getValues()) {
                    opaque.remove();
                }
                if (!listener.getNodes().isEmpty()) {
                    this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
                }
            }
            finally {
                if (nes != null) {
                    nes.close();
                }
            }
        }
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.FSA, graphState), BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        EconomicSetNodeEventListener listener = new EconomicSetNodeEventListener();
        if (graph.hasLoops()) {
            try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
                this.unroll(graph, context);
            }
            if (!listener.getNodes().isEmpty()) {
                this.canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)listener.getNodes());
            }
        }
    }

    private static boolean checkCounted(StructuredGraph graph, LoopsDataProvider loopsDataProvider, Graph.Mark mark) {
        LoopsData dataCounted = loopsDataProvider.getLoopsData(graph);
        dataCounted.detectCountedLoops();
        for (Loop anyLoop : dataCounted.loops()) {
            if (graph.isNew(mark, anyLoop.loopBegin())) assert (anyLoop.isCounted()) : "pre/post transformation loses counted loop " + String.valueOf(anyLoop.loopBegin());
        }
        return true;
    }

    @Override
    public boolean checkContract() {
        return false;
    }
}

