/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.loop.phases.LoopPhase;
import jdk.graal.compiler.loop.phases.LoopTransformations;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopPolicies;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.contract.NodeCostUtil;

public class LoopFullUnrollPhase
extends LoopPhase<LoopPolicies> {
    private static final double LargeGraph = 10000.0;
    public static final Comparator<Loop> LOOP_COMPARATOR;

    static double scaleValue(double x, double smallGraph, double largeGraph) {
        return Math.min(Math.max(x, smallGraph), largeGraph) / largeGraph * 10.0;
    }

    private static double getBudget(int nodeCostSize, OptionValues options) {
        int x = nodeCostSize;
        double largeScale = Options.FullUnrollCodeSizeBudgetFactorForLargeGraphs.getValue(options);
        double smallScale = Options.FullUnrollCodeSizeBudgetFactorForSmallGraphs.getValue(options);
        double smallGraph = Options.FullUnrollSmallGraphThreshold.getValue(options).intValue();
        double budget = largeScale + (smallScale - largeScale) * Math.pow(0.5, LoopFullUnrollPhase.scaleValue(x, smallGraph, 10000.0)) / Math.pow(0.5, LoopFullUnrollPhase.scaleValue(smallGraph, smallGraph, 10000.0));
        return budget;
    }

    public LoopFullUnrollPhase(CanonicalizerPhase canonicalizer, LoopPolicies policies) {
        super(policies, canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FSA, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (GraalOptions.FullUnroll.getValue(graph.getOptions()).booleanValue()) {
            DebugContext debug = graph.getDebug();
            if (graph.hasLoops()) {
                boolean peeled;
                int applications = 0;
                int graphSizeBefore = -1;
                int maxGraphSize = -1;
                do {
                    int currentGraphSize;
                    peeled = false;
                    LoopsData dataCounted = context.getLoopsDataProvider().getLoopsData(graph);
                    dataCounted.detectCountedLoops();
                    List<Loop> countedLoops = dataCounted.countedLoops();
                    graph.getDebug().log(2, "Detected %d counted loops", countedLoops.size());
                    countedLoops.sort(LOOP_COMPARATOR);
                    for (Loop loop : countedLoops) {
                        if (!this.getPolicies().shouldFullUnroll(loop)) continue;
                        if (graphSizeBefore == -1) {
                            graphSizeBefore = NodeCostUtil.computeGraphSize(graph);
                            double budgetForSize = LoopFullUnrollPhase.getBudget(graphSizeBefore, graph.getOptions());
                            maxGraphSize = (int)((double)graphSizeBefore * budgetForSize);
                        }
                        LoopTransformations.fullUnroll(loop, context, this.canonicalizer);
                        peeled = true;
                        break;
                    }
                    if (graphSizeBefore != -1 && (currentGraphSize = NodeCostUtil.computeGraphSize(graph)) > maxGraphSize) {
                        debug.log(5, "Aborting full unroll, graphsize went from %d to %d in %s", (Object)graphSizeBefore, (Object)currentGraphSize, (Object)graph);
                        return;
                    }
                    dataCounted.deleteUnusedNodes();
                } while (peeled && ++applications < Options.FullUnrollMaxApplication.getValue(graph.getOptions()));
            }
        }
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    static {
        ToDoubleFunction<Loop> loopFreq = e -> e.getCFGLoop().getHeader().getFirstPredecessor().getRelativeFrequency();
        ToIntFunction<Loop> loopDepth = e -> e.getCFGLoop().getDepth();
        LOOP_COMPARATOR = Comparator.comparingDouble(loopFreq).thenComparingInt(loopDepth).reversed();
    }

    public static class Options {
        public static final OptionKey<Integer> FullUnrollMaxApplication = new OptionKey<Integer>(60);
        public static final OptionKey<Integer> FullUnrollSmallGraphThreshold = new OptionKey<Integer>(1000);
        public static final OptionKey<Double> FullUnrollCodeSizeBudgetFactorForSmallGraphs = new OptionKey<Double>(10.0);
        public static final OptionKey<Double> FullUnrollCodeSizeBudgetFactorForLargeGraphs = new OptionKey<Double>(2.0);
    }
}

