/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.loop.phases;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.cfg.CFGLoop;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StaticDeoptimizingNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.OSRMonitorEnterNode;
import jdk.graal.compiler.nodes.loop.Loop;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.RecursivePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.common.LazyValue;
import jdk.graal.compiler.phases.common.PostRunCanonicalizationPhase;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.TriState;

public class ConvertDeoptimizeToGuardPhase
extends PostRunCanonicalizationPhase<CoreProviders>
implements RecursivePhase {
    public ConvertDeoptimizeToGuardPhase(CanonicalizerPhase canonicalizer) {
        super(canonicalizer);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(super.notApplicableTo(graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.VALUE_PROXY_REMOVAL, graphState), BasePhase.NotApplicable.when(graphState.getGuardsStage().areFrameStatesAtDeopts(), "This phase creates guard nodes, i.e., the graph must allow guard insertion"));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DebugCloseable closable;
        LazyValue<LoopsData> lazyLoops = new LazyValue<LoopsData>(() -> context.getLoopsDataProvider().getLoopsData(graph));
        for (DeoptimizeNode d : graph.getNodes(DeoptimizeNode.TYPE)) {
            assert (d.isAlive());
            if (!d.mayConvertToGuard()) continue;
            closable = d.withNodeSourcePosition();
            try {
                ConvertDeoptimizeToGuardPhase.propagateFixed(d, d, context, lazyLoops);
            }
            finally {
                if (closable == null) continue;
                closable.close();
            }
        }
        if (context != null) {
            for (FixedGuardNode fixedGuard : graph.getNodes(FixedGuardNode.TYPE)) {
                closable = fixedGuard.withNodeSourcePosition();
                try {
                    ConvertDeoptimizeToGuardPhase.trySplitFixedGuard(fixedGuard, context, lazyLoops);
                }
                finally {
                    if (closable != null) {
                        closable.close();
                    }
                }
            }
        }
        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(graph);
    }

    private static void trySplitFixedGuard(FixedGuardNode fixedGuard, CoreProviders context, LazyValue<LoopsData> lazyLoops) {
        LogicNode condition = fixedGuard.condition();
        if (condition instanceof CompareNode) {
            ValuePhiNode xPhi;
            CompareNode compare = (CompareNode)condition;
            ValueNode x = compare.getX();
            ValuePhiNode valuePhiNode = xPhi = x instanceof ValuePhiNode ? (ValuePhiNode)x : null;
            if (x instanceof ConstantNode || xPhi != null) {
                ValuePhiNode yPhi;
                ValueNode y = compare.getY();
                ValuePhiNode valuePhiNode2 = yPhi = y instanceof ValuePhiNode ? (ValuePhiNode)y : null;
                if (y instanceof ConstantNode || yPhi != null) {
                    ConvertDeoptimizeToGuardPhase.processFixedGuardAndPhis(fixedGuard, context, compare, x, xPhi, y, yPhi, lazyLoops);
                }
            }
        }
    }

    private static void processFixedGuardAndPhis(FixedGuardNode fixedGuard, CoreProviders context, CompareNode compare, ValueNode x, ValuePhiNode xPhi, ValueNode y, ValuePhiNode yPhi, LazyValue<LoopsData> lazyLoops) {
        AbstractBeginNode pred = AbstractBeginNode.prevBegin(fixedGuard);
        if (pred instanceof AbstractMergeNode) {
            AbstractMergeNode merge = (AbstractMergeNode)pred;
            if (xPhi != null && xPhi.merge() != merge) {
                return;
            }
            if (yPhi != null && yPhi.merge() != merge) {
                return;
            }
            ConvertDeoptimizeToGuardPhase.processFixedGuardAndMerge(fixedGuard, context, compare, x, xPhi, y, yPhi, merge, lazyLoops);
        }
    }

    private static void processFixedGuardAndMerge(FixedGuardNode fixedGuard, CoreProviders context, CompareNode compare, ValueNode x, ValuePhiNode xPhi, ValueNode y, ValuePhiNode yPhi, AbstractMergeNode merge, LazyValue<LoopsData> lazyLoops) {
        AbstractEndNode mergePredecessor;
        List mergePredecessors = merge.cfgPredecessors().snapshot();
        Iterator iterator = mergePredecessors.iterator();
        while (iterator.hasNext() && (mergePredecessor = (AbstractEndNode)iterator.next()).isAlive()) {
            Constant xs = xPhi == null ? x.asConstant() : xPhi.valueAt(mergePredecessor).asConstant();
            Constant ys = yPhi == null ? y.asConstant() : yPhi.valueAt(mergePredecessor).asConstant();
            if (xs == null || ys == null) continue;
            Stamp compareStamp = x.stamp(NodeView.DEFAULT);
            TriState compareResult = compare.condition().foldCondition(compareStamp, xs, ys, context.getConstantReflection(), compare.unorderedIsTrue());
            if (!compareResult.isKnown() || compareResult.toBoolean() != fixedGuard.isNegated()) continue;
            DebugCloseable position = fixedGuard.withNodeSourcePosition();
            try {
                ConvertDeoptimizeToGuardPhase.propagateFixed(mergePredecessor, fixedGuard, context, lazyLoops);
            }
            finally {
                if (position == null) continue;
                position.close();
            }
        }
    }

    public static void propagateFixed(FixedNode from, StaticDeoptimizingNode deopt, CoreProviders providers, LazyValue<LoopsData> lazyLoops) {
        for (Node current = from; current != null; current = current.predecessor()) {
            if (GraalOptions.GuardPriorities.getValue(from.getOptions()).booleanValue() && current instanceof FixedGuardNode) {
                FixedGuardNode otherGuard = (FixedGuardNode)current;
                if (!otherGuard.computePriority().isHigherPriorityThan(deopt.computePriority())) continue;
                ConvertDeoptimizeToGuardPhase.moveAsDeoptAfter(otherGuard, deopt);
                return;
            }
            if (current instanceof AbstractBeginNode) {
                if (current instanceof AbstractMergeNode) {
                    AbstractMergeNode mergeNode = (AbstractMergeNode)current;
                    FixedNode next = mergeNode.next();
                    while (mergeNode.isAlive()) {
                        AbstractEndNode end = (AbstractEndNode)mergeNode.forwardEnds().first();
                        ConvertDeoptimizeToGuardPhase.propagateFixed(end, deopt, providers, lazyLoops);
                    }
                    if (next.isAlive()) {
                        ConvertDeoptimizeToGuardPhase.propagateFixed(next, deopt, providers, lazyLoops);
                    }
                    return;
                }
                if (current.predecessor() instanceof IfNode) {
                    AbstractBeginNode begin = (AbstractBeginNode)current;
                    IfNode ifNode = (IfNode)current.predecessor();
                    if (ConvertDeoptimizeToGuardPhase.isOsrLoopExit(begin) || ConvertDeoptimizeToGuardPhase.isCountedLoopExit(ifNode, lazyLoops)) {
                        ConvertDeoptimizeToGuardPhase.moveAsDeoptAfter(begin, deopt);
                    } else {
                        if (begin instanceof LoopExitNode && ifNode.condition() instanceof IntegerEqualsNode) {
                            StructuredGraph graph = ifNode.graph();
                            IntegerEqualsNode integerEqualsNode = (IntegerEqualsNode)ifNode.condition();
                            if (integerEqualsNode.getX() instanceof BranchProbabilityNode) {
                                simplifierTool = GraphUtil.getDefaultSimplifier(providers, false, graph.getAssumptions(), graph.getOptions());
                                ((BranchProbabilityNode)integerEqualsNode.getX()).simplify(simplifierTool);
                            } else if (integerEqualsNode.getY() instanceof BranchProbabilityNode) {
                                simplifierTool = GraphUtil.getDefaultSimplifier(providers, false, graph.getAssumptions(), graph.getOptions());
                                ((BranchProbabilityNode)integerEqualsNode.getY()).simplify(simplifierTool);
                            }
                        }
                        try (DebugCloseable closable = ifNode.withNodeSourcePosition();){
                            StructuredGraph graph = ifNode.graph();
                            LogicNode conditionNode = ifNode.condition();
                            boolean negateGuardCondition = current == ifNode.trueSuccessor();
                            NodeSourcePosition survivingSuccessorPosition = negateGuardCondition ? ifNode.falseSuccessor().getNodeSourcePosition() : ifNode.trueSuccessor().getNodeSourcePosition();
                            FixedGuardNode guard = graph.add(new FixedGuardNode(conditionNode, deopt.getReason(), deopt.getAction(), deopt.getSpeculation(), negateGuardCondition, survivingSuccessorPosition));
                            FixedWithNextNode pred = (FixedWithNextNode)ifNode.predecessor();
                            AbstractBeginNode survivingSuccessor = negateGuardCondition ? ifNode.falseSuccessor() : ifNode.trueSuccessor();
                            graph.removeSplitPropagate(ifNode, survivingSuccessor);
                            ValueNode newGuard = guard;
                            if (survivingSuccessor.isAlive()) {
                                if (survivingSuccessor instanceof LoopExitNode) {
                                    newGuard = ProxyNode.forGuard(guard, (LoopExitNode)survivingSuccessor);
                                }
                                survivingSuccessor.replaceAtUsages((Node)newGuard, InputType.Guard);
                            }
                            graph.getOptimizationLog().report(ConvertDeoptimizeToGuardPhase.class, "DeoptimizeToGuardConversion", deopt.asNode());
                            FixedNode next = pred.next();
                            pred.setNext(guard);
                            guard.setNext(next);
                            assert (providers != null);
                            SimplifierTool simplifierTool = GraphUtil.getDefaultSimplifier(providers, false, graph.getAssumptions(), graph.getOptions());
                            if (survivingSuccessor.isAlive()) {
                                ((Simplifiable)((Object)survivingSuccessor)).simplify(simplifierTool);
                            }
                        }
                    }
                    return;
                }
                if (current.predecessor() != null && !(current.predecessor() instanceof ControlSplitNode)) continue;
                assert (current.predecessor() != null || current instanceof StartNode && current == ((AbstractBeginNode)current).graph().start()) : Assertions.errorMessageContext("current", current, "pred", current.predecessor());
                ConvertDeoptimizeToGuardPhase.moveAsDeoptAfter((AbstractBeginNode)current, deopt);
                return;
            }
            if (!(current instanceof OSRMonitorEnterNode)) continue;
            OSRMonitorEnterNode monitorEnterNode = (OSRMonitorEnterNode)current;
            ConvertDeoptimizeToGuardPhase.moveAsDeoptAfter(monitorEnterNode, deopt);
            return;
        }
    }

    private static void moveAsDeoptAfter(FixedWithNextNode node, StaticDeoptimizingNode deopt) {
        try (DebugCloseable position = deopt.asNode().withNodeSourcePosition();){
            FixedNode next = node.next();
            if (next != deopt.asNode()) {
                node.setNext(node.graph().add(new DeoptimizeNode(deopt.getAction(), deopt.getReason(), deopt.getSpeculation())));
                GraphUtil.killCFG(next);
                node.graph().getOptimizationLog().report(ConvertDeoptimizeToGuardPhase.class, "DeoptimizeMovement", deopt.asNode());
            }
        }
    }

    private static boolean isOsrLoopExit(AbstractBeginNode node) {
        if (!(node instanceof LoopExitNode)) {
            return false;
        }
        return ((LoopExitNode)node).loopBegin().isOsrLoop();
    }

    private static boolean isCountedLoopExit(IfNode ifNode, LazyValue<LoopsData> lazyLoops) {
        LoopsData loopsData = lazyLoops.get();
        CFGLoop<HIRBlock> loop = loopsData.getCFG().getNodeToBlock().get(ifNode).getLoop();
        if (loop != null) {
            Loop loopEx = loopsData.loop(loop);
            if (loopEx.detectCounted()) {
                return ifNode == loopEx.counted().getLimitTest();
            }
            if (loopEx.canBecomeLimitTestAfterFloatingReads(ifNode)) {
                return true;
            }
        }
        return false;
    }
}

