/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.stackslotalloc;

import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.ValueProcedure;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.lir.framemap.FrameMapBuilderTool;
import jdk.graal.compiler.lir.framemap.SimpleVirtualStackSlot;
import jdk.graal.compiler.lir.framemap.SimpleVirtualStackSlotAlias;
import jdk.graal.compiler.lir.framemap.VirtualStackSlotRange;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.AllocationPhase;
import jdk.graal.compiler.lir.stackslotalloc.StackSlotAllocatorUtil;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ValueKind;

public class SimpleStackSlotAllocator
extends AllocationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.allocateStackSlots((FrameMapBuilderTool)lirGenRes.getFrameMapBuilder(), lirGenRes);
        lirGenRes.buildFrameMap();
    }

    public void allocateStackSlots(FrameMapBuilderTool builder, LIRGenerationResult res) {
        DebugContext debug = res.getLIR().getDebug();
        StackSlot[] mapping = new StackSlot[builder.getNumberOfStackSlots()];
        boolean allocatedFramesizeEnabled = StackSlotAllocatorUtil.allocatedFramesize.isEnabled(debug);
        long currentFrameSize = allocatedFramesizeEnabled ? (long)builder.getFrameMap().currentFrameSize() : 0L;
        for (VirtualStackSlot virtualSlot : builder.getStackSlots()) {
            StackSlot slot;
            if (virtualSlot instanceof SimpleVirtualStackSlot) {
                slotKind = virtualSlot.getValueKind();
                slot = builder.getFrameMap().allocateSpillSlot(slotKind);
                StackSlotAllocatorUtil.virtualFramesize.add(debug, builder.getFrameMap().spillSlotSize(slotKind));
            } else if (virtualSlot instanceof SimpleVirtualStackSlotAlias) {
                slotKind = ((SimpleVirtualStackSlotAlias)virtualSlot).getAliasedSlot().getValueKind();
                slot = builder.getFrameMap().allocateSpillSlot(slotKind);
                StackSlotAllocatorUtil.virtualFramesize.add(debug, builder.getFrameMap().spillSlotSize(slotKind));
            } else if (virtualSlot instanceof VirtualStackSlotRange) {
                VirtualStackSlotRange slotRange = (VirtualStackSlotRange)virtualSlot;
                slot = builder.getFrameMap().allocateStackMemory(slotRange.getSizeInBytes(), slotRange.getAlignmentInBytes());
                StackSlotAllocatorUtil.virtualFramesize.add(debug, slotRange.getSizeInBytes());
            } else {
                throw GraalError.shouldNotReachHere("Unknown VirtualStackSlot: " + String.valueOf((Object)virtualSlot));
            }
            StackSlotAllocatorUtil.allocatedSlots.increment(debug);
            mapping[virtualSlot.getId()] = slot;
        }
        this.updateLIR(res, mapping);
        if (allocatedFramesizeEnabled) {
            StackSlotAllocatorUtil.allocatedFramesize.add(debug, (long)builder.getFrameMap().currentFrameSize() - currentFrameSize);
        }
    }

    protected void updateLIR(LIRGenerationResult res, StackSlot[] mapping) {
        DebugContext debug = res.getLIR().getDebug();
        try (DebugContext.Scope scope = debug.scope("StackSlotMappingLIR");){
            ValueProcedure updateProc = (value, mode, flags) -> {
                if (LIRValueUtil.isVirtualStackSlot(value)) {
                    StackSlot stackSlot = mapping[LIRValueUtil.asVirtualStackSlot(value).getId()];
                    if (value instanceof SimpleVirtualStackSlotAlias) {
                        GraalError.guarantee(mode == LIRInstruction.OperandMode.USE || mode == LIRInstruction.OperandMode.ALIVE, "Invalid application of SimpleVirtualStackSlotAlias");
                        stackSlot = StackSlot.get((ValueKind)value.getValueKind(), (int)stackSlot.getRawOffset(), (boolean)stackSlot.getRawAddFrameSize());
                    }
                    debug.log("map %s -> %s", (Object)value, (Object)stackSlot);
                    return stackSlot;
                }
                return value;
            };
            for (BasicBlock block : res.getLIR().getControlFlowGraph().getBlocks()) {
                try (Indent indent0 = debug.logAndIndent("block: %s", block);){
                    for (LIRInstruction inst : res.getLIR().getLIRforBlock(block)) {
                        Indent indent1 = debug.logAndIndent("Inst: %d: %s", inst.id(), (Object)inst);
                        try {
                            inst.forEachAlive(updateProc);
                            inst.forEachInput(updateProc);
                            inst.forEachOutput(updateProc);
                            inst.forEachTemp(updateProc);
                            inst.forEachState(updateProc);
                        }
                        finally {
                            if (indent1 == null) continue;
                            indent1.close();
                        }
                    }
                }
            }
        }
    }
}

