/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.profiling;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.profiling.MoveType;

public final class MoveProfiler {
    private final LIR lir;
    private final BlockMap<MoveStatistics> blockMap;

    public static BlockMap<MoveStatistics> profile(LIR lir) {
        MoveProfiler profiler = new MoveProfiler(lir);
        profiler.run();
        return profiler.blockMap;
    }

    private MoveProfiler(LIR lir) {
        this.lir = lir;
        this.blockMap = new BlockMap(lir.getControlFlowGraph());
    }

    private void run() {
        for (BasicBlock block : this.lir.getControlFlowGraph().getBlocks()) {
            this.doBlock(block);
        }
    }

    private void doBlock(BasicBlock<?> block) {
        ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
        assert (instructions.size() >= 2) : "Malformed block: " + String.valueOf(block) + ", " + String.valueOf(instructions);
        assert (instructions.get(instructions.size() - 1) instanceof StandardOp.BlockEndOp) : "Not a BlockEndOp: " + String.valueOf(instructions.get(instructions.size() - 1));
        assert (!(instructions.get(instructions.size() - 2) instanceof StandardOp.BlockEndOp)) : "Is a BlockEndOp: " + String.valueOf(instructions.get(instructions.size() - 2));
        assert (instructions.get(0) instanceof StandardOp.LabelOp) : "Not a LabelOp: " + String.valueOf(instructions.get(0));
        assert (!(instructions.get(1) instanceof StandardOp.LabelOp)) : "Is a LabelOp: " + String.valueOf(instructions.get(1));
        MoveStatistics stats = null;
        for (LIRInstruction inst : instructions) {
            if (!StandardOp.MoveOp.isMoveOp(inst)) continue;
            if (stats == null) {
                stats = new MoveStatistics();
                this.blockMap.put(block, stats);
            }
            stats.add(MoveType.get(inst));
        }
    }

    static class MoveStatistics {
        private final int[] cnt = new int[MoveType.values().length];

        MoveStatistics() {
        }

        public void add(MoveType moveType) {
            int n = moveType.ordinal();
            this.cnt[n] = this.cnt[n] + 1;
        }

        public int get(MoveType moveType) {
            return this.cnt[moveType.ordinal()];
        }

        public void add(MoveType moveType, int value) {
            int n = moveType.ordinal();
            this.cnt[n] = this.cnt[n] + value;
        }
    }
}

