/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.profiling;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInsertionBuffer;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public class MethodProfilingPhase
extends PostAllocationOptimizationPhase {
    public static final String INVOCATION_GROUP = "METHOD_INVOCATION_COUNTER";
    public static final String ITERATION_GROUP = "METHOD_ITERATION_COUNTER";

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        new Analyzer(target, lirGenRes, context.diagnosticLirGenTool).run();
    }

    private static class Analyzer {
        private final LIR lir;
        private final DiagnosticLIRGeneratorTool diagnosticLirGenTool;
        private final LIRInsertionBuffer buffer;
        private final ConstantValue increment;
        private final LIRGenerationResult lirGenRes;

        Analyzer(TargetDescription target, LIRGenerationResult lirGenRes, DiagnosticLIRGeneratorTool diagnosticLirGenTool) {
            this.lir = lirGenRes.getLIR();
            this.lirGenRes = lirGenRes;
            this.diagnosticLirGenTool = diagnosticLirGenTool;
            this.buffer = new LIRInsertionBuffer();
            this.increment = new ConstantValue(LIRKind.fromJavaKind(target.arch, JavaKind.Int), (Constant)JavaConstant.INT_1);
        }

        public void run() {
            this.doBlock((BasicBlock<?>)this.lir.getControlFlowGraph().getStartBlock(), MethodProfilingPhase.INVOCATION_GROUP);
            for (BasicBlock block : this.lir.getControlFlowGraph().getBlocks()) {
                if (!block.isLoopHeader()) continue;
                this.doBlock(block, MethodProfilingPhase.ITERATION_GROUP);
            }
        }

        public void doBlock(BasicBlock<?> block, String group) {
            ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
            assert (instructions.size() >= 2) : "Malformed block: " + String.valueOf(block) + ", " + String.valueOf(instructions);
            assert (instructions.get(instructions.size() - 1) instanceof StandardOp.BlockEndOp) : "Not a BlockEndOp: " + String.valueOf(instructions.get(instructions.size() - 1));
            assert (!(instructions.get(instructions.size() - 2) instanceof StandardOp.BlockEndOp)) : "Is a BlockEndOp: " + String.valueOf(instructions.get(instructions.size() - 2));
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "Not a LabelOp: " + String.valueOf(instructions.get(0));
            assert (!(instructions.get(1) instanceof StandardOp.LabelOp)) : "Is a LabelOp: " + String.valueOf(instructions.get(1));
            LIRInstruction op = this.diagnosticLirGenTool.createBenchmarkCounter(this.lirGenRes.getCompilationUnitName(), group, this.increment);
            this.buffer.init(instructions);
            int insertionIndex = this.lirGenRes.getFirstInsertPosition();
            this.buffer.append(insertionIndex, op);
            this.buffer.finish();
        }
    }
}

