/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.phases;

import jdk.graal.compiler.lir.ComputeCodeEmissionOrder;
import jdk.graal.compiler.lir.ControlFlowOptimizer;
import jdk.graal.compiler.lir.EdgeMoveOptimizer;
import jdk.graal.compiler.lir.NullCheckOptimizer;
import jdk.graal.compiler.lir.RedundantMoveElimination;
import jdk.graal.compiler.lir.phases.LIRPhase;
import jdk.graal.compiler.lir.phases.LIRPhaseSuite;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.graal.compiler.lir.profiling.MethodProfilingPhase;
import jdk.graal.compiler.lir.profiling.MoveProfilingPhase;
import jdk.graal.compiler.options.NestedBooleanOptionKey;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;

public class PostAllocationOptimizationStage
extends LIRPhaseSuite<PostAllocationOptimizationPhase.PostAllocationOptimizationContext> {
    public PostAllocationOptimizationStage(OptionValues options) {
        if (Options.LIROptEdgeMoveOptimizer.getValue(options).booleanValue()) {
            this.appendPhase(new EdgeMoveOptimizer());
        }
        if (Options.LIROptRedundantMoveElimination.getValue(options).booleanValue()) {
            this.appendPhase(new RedundantMoveElimination());
        }
        if (Options.LIROptNullCheckOptimizer.getValue(options).booleanValue()) {
            this.appendPhase(new NullCheckOptimizer());
        }
        if (Options.LIROptControlFlowOptimizer.getValue(options).booleanValue()) {
            this.appendPhase(new ControlFlowOptimizer());
        }
        if (Options.LIRProfileMoves.getValue(options).booleanValue()) {
            this.appendPhase(new MoveProfilingPhase());
        }
        if (Options.LIRProfileMethods.getValue(options).booleanValue()) {
            this.appendPhase(new MethodProfilingPhase());
        }
        if (!ComputeCodeEmissionOrder.Options.EarlyCodeEmissionOrder.getValue(options).booleanValue()) {
            this.appendPhase(new ComputeCodeEmissionOrder());
        }
    }

    public static class Options {
        public static final NestedBooleanOptionKey LIROptEdgeMoveOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final NestedBooleanOptionKey LIROptControlFlowOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final NestedBooleanOptionKey LIROptRedundantMoveElimination = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final NestedBooleanOptionKey LIROptNullCheckOptimizer = new NestedBooleanOptionKey(LIRPhase.Options.LIROptimization, true);
        public static final OptionKey<Boolean> LIRProfileMoves = new OptionKey<Boolean>(false);
        public static final OptionKey<Boolean> LIRProfileMethods = new OptionKey<Boolean>(false);
    }
}

