/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.dfa;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.dfa.LocationMarker;
import jdk.graal.compiler.lir.dfa.RegStackValueSet;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.lir.framemap.ReferenceMapBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.FinalCodeAnalysisPhase;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterAttributes;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

public final class LocationMarkerPhase
extends FinalCodeAnalysisPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, FinalCodeAnalysisPhase.FinalCodeAnalysisContext context) {
        new Marker(lirGenRes.getLIR(), lirGenRes.getFrameMap()).build();
    }

    static final class Marker
    extends LocationMarker<RegStackValueSet> {
        private final RegisterAttributes[] registerAttributes;

        private Marker(LIR lir, FrameMap frameMap) {
            super(lir, frameMap);
            this.registerAttributes = frameMap.getRegisterConfig().getAttributesMap();
        }

        @Override
        protected RegStackValueSet newLiveValueSet() {
            return new RegStackValueSet(this.frameMap);
        }

        @Override
        protected boolean shouldProcessValue(Value operand) {
            Register reg;
            if (ValueUtil.isRegister((Value)operand) ? !(reg = ValueUtil.asRegister((Value)operand)).mayContainReference() || !this.attributes(reg).isAllocatable() : !ValueUtil.isStackSlot((Value)operand)) {
                return false;
            }
            return !operand.getValueKind().equals((Object)LIRKind.Illegal);
        }

        @Override
        protected void processState(LIRInstruction op, LIRFrameState info, RegStackValueSet values) {
            if (!info.hasDebugInfo()) {
                info.initDebugInfo();
            }
            ReferenceMapBuilder refMap = this.frameMap.newReferenceMapBuilder();
            values.addLiveValues(refMap);
            info.debugInfo().setReferenceMap(refMap.finish(info));
        }

        private RegisterAttributes attributes(Register reg) {
            return this.registerAttributes[reg.number];
        }
    }
}

