/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.constopt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import jdk.graal.compiler.core.common.cfg.AbstractControlFlowGraph;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.cfg.DominatorOptimizationProblem;
import jdk.graal.compiler.core.common.cfg.PropertyConsumable;
import jdk.graal.compiler.lir.constopt.DefUseTree;
import jdk.graal.compiler.lir.constopt.UseEntry;

public class ConstantTree
extends DominatorOptimizationProblem<Flags, NodeCost> {
    private final BlockMap<List<UseEntry>> blockMap;

    public ConstantTree(AbstractControlFlowGraph<?> cfg, DefUseTree tree) {
        super(Flags.class, cfg);
        this.blockMap = new BlockMap(cfg);
        tree.forEach(u -> this.getOrInitList(u.getBlock()).add((UseEntry)u));
    }

    private List<UseEntry> getOrInitList(BasicBlock<?> block) {
        List<UseEntry> list = this.blockMap.get(block);
        if (list == null) {
            list = new ArrayList<UseEntry>();
            this.blockMap.put(block, list);
        }
        return list;
    }

    public List<UseEntry> getUsages(BasicBlock<?> block) {
        List<UseEntry> list = this.blockMap.get(block);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    NodeCost getOrInitCost(BasicBlock<?> block) {
        NodeCost cost = (NodeCost)this.getCost(block);
        if (cost == null) {
            cost = new NodeCost(block.getRelativeFrequency(), this.blockMap.get(block), 1);
            this.setCost(block, cost);
        }
        return cost;
    }

    @Override
    public String getName(Flags type) {
        switch (type.ordinal()) {
            case 1: {
                return "hasUsage";
            }
            case 0: {
                return "inSubtree";
            }
            case 2: {
                return "materialize";
            }
            case 3: {
                return "candidate";
            }
        }
        return super.getName(type);
    }

    public BasicBlock<?> getStartBlock() {
        return this.stream(Flags.SUBTREE).findFirst().get();
    }

    public void markBlocks() {
        for (BasicBlock<?> block : this.getBlocks()) {
            if (!this.get(Flags.USAGE, block)) continue;
            this.setDominatorPath(Flags.SUBTREE, block);
        }
    }

    public boolean isMarked(BasicBlock<?> block) {
        return this.get(Flags.SUBTREE, block);
    }

    public boolean isLeafBlock(BasicBlock<?> block) {
        for (Object dom = block.getFirstDominated(); dom != null; dom = ((BasicBlock)dom).getDominatedSibling()) {
            if (!this.isMarked((BasicBlock<?>)dom)) continue;
            return false;
        }
        return true;
    }

    public void setSolution(BasicBlock<?> block) {
        this.set(Flags.MATERIALIZE, block);
    }

    public int size() {
        return this.getBlocks().length;
    }

    public static enum Flags {
        SUBTREE,
        USAGE,
        MATERIALIZE,
        CANDIDATE;

    }

    public static class NodeCost
    implements PropertyConsumable {
        private List<UseEntry> usages;
        private double bestCost;
        private int numMat;

        public NodeCost(double bestCost, List<UseEntry> usages, int numMat) {
            this.bestCost = bestCost;
            this.usages = usages;
            this.numMat = numMat;
        }

        @Override
        public void forEachProperty(BiConsumer<String, String> action) {
            action.accept("bestCost", Double.toString(this.getBestCost()));
            action.accept("numMat", Integer.toString(this.getNumMaterializations()));
            action.accept("numUsages", Integer.toString(this.usages.size()));
        }

        public List<UseEntry> getUsages() {
            if (this.usages == null) {
                return Collections.emptyList();
            }
            return this.usages;
        }

        public double getBestCost() {
            return this.bestCost;
        }

        public int getNumMaterializations() {
            return this.numMat;
        }

        public String toString() {
            return "NodeCost [bestCost=" + this.bestCost + ", numUsages=" + this.usages.size() + ", numMat=" + this.numMat + "]";
        }
    }
}

