/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.asm;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstructionVerifier;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.asm.DataBuilder;
import jdk.graal.compiler.lir.asm.FrameContext;
import jdk.graal.compiler.lir.framemap.FrameMap;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.Register;
import org.graalvm.nativeimage.ImageInfo;

public interface CompilationResultBuilderFactory {
    public static final CompilationResultBuilderFactory Default = new CompilationResultBuilderFactory(){
        private List<LIRInstructionVerifier> lirInstructionVerifiers = new ArrayList<LIRInstructionVerifier>();
        private volatile boolean isVerifierInitialized = false;

        private void initializeLIRVerifiers(String lirInstructionVerifierPath) {
            try {
                URL verifierURL = Paths.get(lirInstructionVerifierPath, new String[0]).toUri().toURL();
                URLClassLoader cl = new URLClassLoader(new URL[]{verifierURL}, ClassLoader.getPlatformClassLoader());
                for (LIRInstructionVerifier verifier : ServiceLoader.load(LIRInstructionVerifier.class, cl)) {
                    if (!verifier.isEnabled()) continue;
                    this.lirInstructionVerifiers.add(verifier);
                }
            }
            catch (MalformedURLException e) {
                throw GraalError.shouldNotReachHere(e, "Malformed URL encountered.");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompilationResultBuilder createBuilder(CoreProviders providers, FrameMap frameMap, Assembler<?> asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister, LIR lir) {
            if (!ImageInfo.inImageRuntimeCode() && !this.isVerifierInitialized) {
                List<LIRInstructionVerifier> list = this.lirInstructionVerifiers;
                synchronized (list) {
                    if (!this.isVerifierInitialized) {
                        String lirInstructionVerifierPath = Options.LIRInstructionVerifierPath.getValue(options);
                        if (lirInstructionVerifierPath != null && !lirInstructionVerifierPath.isEmpty()) {
                            this.initializeLIRVerifiers(lirInstructionVerifierPath);
                        }
                        this.isVerifierInitialized = true;
                    }
                }
            }
            return new CompilationResultBuilder(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister, this.lirInstructionVerifiers, lir);
        }
    };

    public CompilationResultBuilder createBuilder(CoreProviders var1, FrameMap var2, Assembler<?> var3, DataBuilder var4, FrameContext var5, OptionValues var6, DebugContext var7, CompilationResult var8, Register var9, LIR var10);

    public static class Options {
        public static final OptionKey<String> LIRInstructionVerifierPath = new OptionKey<Object>(null);
    }
}

