/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.vector;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.core.common.type.DataPointerConstant;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.amd64.AMD64RestoreRegistersOp;
import jdk.graal.compiler.lir.amd64.AMD64SaveRegistersOp;
import jdk.graal.compiler.lir.amd64.vector.AMD64VectorInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;

public class AMD64VectorMove {
    private static AMD64Assembler.AMD64SIMDInstructionEncoding maybeOverrideEvex(AMD64MacroAssembler masm, AMD64Assembler.AMD64SIMDInstructionEncoding enc, AllocatableValue slot) {
        if (enc != AMD64Assembler.AMD64SIMDInstructionEncoding.EVEX && AVXKind.getRegisterSize((Value)slot) == AVXKind.AVXSize.ZMM) {
            GraalError.guarantee(masm.supports(AMD64.CPUFeature.AVX512F) && !AMD64BaseAssembler.supportsFullAVX512(masm.getFeatures()), "Cannot generate ZMM sized stack move without AVX512F!");
            return AMD64Assembler.AMD64SIMDInstructionEncoding.EVEX;
        }
        return enc;
    }

    private static AMD64Assembler.VexMoveOp getScalarMoveOp(AMD64Kind kind, AMD64Assembler.AMD64SIMDInstructionEncoding enc) {
        return switch (kind) {
            case AMD64Kind.SINGLE -> AMD64Assembler.VexMoveOp.VMOVSS.encoding(enc);
            case AMD64Kind.DOUBLE -> AMD64Assembler.VexMoveOp.VMOVSD.encoding(enc);
            default -> throw GraalError.shouldNotReachHereUnexpectedValue(kind);
        };
    }

    private static AMD64Assembler.VexMoveOp getVectorMoveOp(AMD64Kind kind, AMD64Assembler.AMD64SIMDInstructionEncoding enc) {
        return switch (kind) {
            case AMD64Kind.SINGLE -> AMD64Assembler.VexMoveOp.VMOVUPS.encoding(enc);
            case AMD64Kind.DOUBLE -> AMD64Assembler.VexMoveOp.VMOVUPD.encoding(enc);
            default -> AMD64Assembler.VexMoveOp.VMOVDQU32.encoding(enc);
        };
    }

    public static AMD64Assembler.VexMoveOp getVectorMemMoveOp(AMD64Kind kind, AMD64Assembler.AMD64SIMDInstructionEncoding enc) {
        return switch (AVXKind.getDataSize(kind)) {
            case AVXKind.AVXSize.DWORD -> AMD64Assembler.VexMoveOp.VMOVD.encoding(enc);
            case AVXKind.AVXSize.QWORD -> AMD64Assembler.VexMoveOp.VMOVQ.encoding(enc);
            default -> AMD64VectorMove.getVectorMoveOp(kind.getScalar(), enc);
        };
    }

    private static void move(CompilationResultBuilder crb, AMD64MacroAssembler masm, AllocatableValue result, Value input, AMD64Assembler.AMD64SIMDInstructionEncoding enc) {
        AMD64Assembler.VexMoveOp op;
        AVXKind.AVXSize size;
        AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
        if (kind.getVectorLength() > 1) {
            size = AVXKind.getRegisterSize(kind);
            op = ValueUtil.isRegister((Value)input) && ValueUtil.isRegister((Value)result) ? AMD64VectorMove.getVectorMoveOp(kind.getScalar(), enc) : AMD64VectorMove.getVectorMemMoveOp(kind, enc);
        } else {
            size = AVXKind.AVXSize.XMM;
            op = ValueUtil.isRegister((Value)input) && ValueUtil.isRegister((Value)result) ? AMD64VectorMove.getVectorMoveOp(kind, enc) : AMD64VectorMove.getScalarMoveOp(kind, enc);
        }
        if (ValueUtil.isRegister((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                if (!ValueUtil.asRegister((Value)input).equals((Object)ValueUtil.asRegister((Value)result))) {
                    op.emit((AMD64Assembler)masm, size, ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)input));
                }
            } else {
                assert (ValueUtil.isStackSlot((Value)result));
                op.emit((AMD64Assembler)masm, size, (AMD64Address)crb.asAddress((Value)result), ValueUtil.asRegister((Value)input));
            }
        } else {
            assert (ValueUtil.isStackSlot((Value)input)) : Assertions.errorMessageContext("input", input);
            assert (ValueUtil.isRegister((Value)result)) : Assertions.errorMessageContext("result", result);
            op.emit((AMD64Assembler)masm, size, ValueUtil.asRegister((Value)result), (AMD64Address)crb.asAddress(input));
        }
    }

    private static void const2reg(CompilationResultBuilder crb, AMD64MacroAssembler masm, RegisterValue result, JavaConstant input, AMD64Assembler.AMD64SIMDInstructionEncoding enc) {
        if (input.isDefaultForKind()) {
            AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
            Register register = result.getRegister();
            AMD64Assembler.VexRVMOp.VXORPD.encoding(enc).emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, register, register);
            return;
        }
        AMD64Address address = switch (input.getJavaKind()) {
            case JavaKind.Float -> (AMD64Address)crb.asFloatConstRef(input);
            case JavaKind.Double -> (AMD64Address)crb.asDoubleConstRef(input);
            default -> throw GraalError.shouldNotReachHereUnexpectedValue(input.getJavaKind());
        };
        AMD64Assembler.VexMoveOp op = AMD64VectorMove.getScalarMoveOp((AMD64Kind)result.getPlatformKind(), enc);
        op.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)result), address);
    }

    public static final class AVXMoveToIntOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AVXMoveToIntOp> TYPE = LIRInstructionClass.create(AVXMoveToIntOp.class);
        @Opcode
        private final AMD64Assembler.VexMoveOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public AVXMoveToIntOp(AMD64Assembler.VexMoveOp opcode, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                this.opcode.emitReverse(masm, AVXKind.AVXSize.XMM, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input));
            } else {
                this.opcode.emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, (AMD64Address)crb.asAddress((Value)this.result), ValueUtil.asRegister((Value)this.input));
            }
        }
    }

    @Opcode(value="RESTORE_REGISTER")
    public static final class RestoreRegistersOp
    extends AMD64RestoreRegistersOp {
        public static final LIRInstructionClass<RestoreRegistersOp> TYPE = LIRInstructionClass.create(RestoreRegistersOp.class);
        private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;

        public RestoreRegistersOp(AllocatableValue[] source, AMD64SaveRegistersOp save, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
            super(TYPE, source, save);
            this.encoding = encoding;
        }

        @Override
        protected void restoreRegister(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register register, StackSlot input) {
            AMD64Kind kind = (AMD64Kind)input.getPlatformKind();
            if (kind.isXMM()) {
                AMD64Assembler.VexMoveOp op = kind.getVectorLength() > 1 ? AMD64VectorMove.getVectorMoveOp(kind.getScalar(), AMD64VectorMove.maybeOverrideEvex(masm, this.encoding, (AllocatableValue)input)) : AMD64VectorMove.getScalarMoveOp(kind, this.encoding);
                AMD64Address addr = (AMD64Address)crb.asAddress((Value)input);
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, addr);
            } else {
                super.restoreRegister(crb, masm, register, input);
            }
        }
    }

    @Opcode(value="SAVE_REGISTER")
    public static class SaveRegistersOp
    extends AMD64SaveRegistersOp {
        public static final LIRInstructionClass<SaveRegistersOp> TYPE = LIRInstructionClass.create(SaveRegistersOp.class);
        private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;

        public SaveRegistersOp(Register[] savedRegisters, AllocatableValue[] slots, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
            super(TYPE, savedRegisters, slots);
            this.encoding = encoding;
        }

        @Override
        protected void saveRegister(CompilationResultBuilder crb, AMD64MacroAssembler masm, StackSlot result, Register register) {
            AMD64Kind kind = (AMD64Kind)result.getPlatformKind();
            if (kind.isXMM()) {
                AMD64Assembler.VexMoveOp op;
                if (kind.getVectorLength() > 1) {
                    AMD64Assembler.AMD64SIMDInstructionEncoding fEnc = AMD64VectorMove.maybeOverrideEvex(masm, this.encoding, (AllocatableValue)result);
                    op = AMD64VectorMove.getVectorMoveOp(kind.getScalar(), fEnc);
                } else {
                    op = AMD64VectorMove.getScalarMoveOp(kind, this.encoding);
                }
                AMD64Address addr = (AMD64Address)crb.asAddress((Value)result);
                op.emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), addr, register);
            } else {
                super.saveRegister(crb, masm, result, register);
            }
        }
    }

    public static class VectorMaskedStoreOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<VectorMaskedStoreOp> TYPE = LIRInstructionClass.create(VectorMaskedStoreOp.class);
        protected final AVXKind.AVXSize size;
        protected final AMD64Assembler.VexOp op;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue mask;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue value;
        @LIRInstruction.State
        protected LIRFrameState state;

        public VectorMaskedStoreOp(AVXKind.AVXSize size, AMD64Assembler.VexMaskedMoveOp op, AMD64AddressValue address, AllocatableValue mask, AllocatableValue value, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.size = size;
            this.op = op;
            this.address = address;
            this.mask = mask;
            this.value = value;
            this.state = state;
        }

        public VectorMaskedStoreOp(AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AMD64AddressValue address, AllocatableValue mask, AllocatableValue value, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.size = size;
            this.op = op;
            this.address = address;
            this.mask = mask;
            this.value = value;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            GraalError.guarantee(this.state == null, "Implicit exception not supported yet");
            AMD64Assembler.VexOp vexOp = this.op;
            if (vexOp instanceof AMD64Assembler.VexMaskedMoveOp) {
                AMD64Assembler.VexMaskedMoveOp o = (AMD64Assembler.VexMaskedMoveOp)vexOp;
                o.emit((AMD64Assembler)masm, this.size, this.address.toAddress(masm), ValueUtil.asRegister((Value)this.mask), ValueUtil.asRegister((Value)this.value));
            } else {
                AMD64Assembler.VexMoveOp o = (AMD64Assembler.VexMoveOp)this.op;
                o.emit(masm, this.size, this.address.toAddress(masm), ValueUtil.asRegister((Value)this.value), ValueUtil.asRegister((Value)this.mask));
            }
        }
    }

    public static class VectorStoreOp
    extends VectorMemOp {
        public static final LIRInstructionClass<VectorStoreOp> TYPE = LIRInstructionClass.create(VectorStoreOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public VectorStoreOp(AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AMD64AddressValue address, AllocatableValue input, LIRFrameState state) {
            super(TYPE, size, op, address, state);
            this.input = input;
        }

        @Override
        public void emitMemAccess(AMD64MacroAssembler masm) {
            this.op.emit((AMD64Assembler)masm, this.size, this.address.toAddress(masm), ValueUtil.asRegister((Value)this.input));
        }
    }

    public static final class VectorMaskedLoadOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<VectorMaskedLoadOp> TYPE = LIRInstructionClass.create(VectorMaskedLoadOp.class);
        protected final AVXKind.AVXSize size;
        protected final AMD64Assembler.VexOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue mask;
        @LIRInstruction.State
        protected LIRFrameState state;

        public VectorMaskedLoadOp(AVXKind.AVXSize size, AMD64Assembler.VexMaskedMoveOp op, AllocatableValue result, AMD64AddressValue address, AllocatableValue mask, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.size = size;
            this.op = op;
            this.result = result;
            this.address = address;
            this.mask = mask;
            this.state = state;
        }

        public VectorMaskedLoadOp(AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AllocatableValue result, AMD64AddressValue address, AllocatableValue mask, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.size = size;
            this.op = op;
            this.result = result;
            this.address = address;
            this.mask = mask;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            GraalError.guarantee(this.state == null, "Implicit exception not supported yet");
            AMD64Assembler.VexOp vexOp = this.op;
            if (vexOp instanceof AMD64Assembler.VexMaskedMoveOp) {
                AMD64Assembler.VexMaskedMoveOp o = (AMD64Assembler.VexMaskedMoveOp)vexOp;
                o.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.mask), this.address.toAddress(masm));
            } else {
                AMD64Assembler.VexMoveOp o = (AMD64Assembler.VexMoveOp)this.op;
                o.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), this.address.toAddress(masm), ValueUtil.asRegister((Value)this.mask), 1, 0);
            }
        }
    }

    public static final class VectorLoadOp
    extends VectorMemOp {
        public static final LIRInstructionClass<VectorLoadOp> TYPE = LIRInstructionClass.create(VectorLoadOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;

        public VectorLoadOp(AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AllocatableValue result, AMD64AddressValue address, LIRFrameState state) {
            super(TYPE, size, op, address, state);
            this.result = result;
        }

        @Override
        public void emitMemAccess(AMD64MacroAssembler masm) {
            this.op.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), this.address.toAddress(masm));
        }
    }

    public static abstract class VectorMemOp
    extends AMD64VectorInstruction {
        protected final AMD64Assembler.VexMoveOp op;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.State
        protected LIRFrameState state;

        protected VectorMemOp(LIRInstructionClass<? extends VectorMemOp> c, AVXKind.AVXSize size, AMD64Assembler.VexMoveOp op, AMD64AddressValue address, LIRFrameState state) {
            super(c, size);
            this.op = op;
            this.address = address;
            this.state = state;
        }

        protected abstract void emitMemAccess(AMD64MacroAssembler var1);

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.emitMemAccess(masm);
        }
    }

    @Opcode(value="VSTACKMOVE")
    public static final class StackMoveOp
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<StackMoveOp> TYPE = LIRInstructionClass.create(StackMoveOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue backupSlot;
        private Register scratch;
        private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;

        public StackMoveOp(AllocatableValue result, AllocatableValue input, Register scratch, AllocatableValue backupSlot, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.backupSlot = backupSlot;
            this.scratch = scratch;
            this.encoding = encoding;
            assert (result.getPlatformKind().getSizeInBytes() <= input.getPlatformKind().getSizeInBytes()) : "cannot move " + String.valueOf(input) + " into a larger Value " + String.valueOf(result);
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.AMD64SIMDInstructionEncoding backupEnc = AMD64VectorMove.maybeOverrideEvex(masm, this.encoding, this.backupSlot);
            AMD64VectorMove.move(crb, masm, this.backupSlot, (Value)this.scratch.asValue(this.backupSlot.getValueKind()), backupEnc);
            AMD64VectorMove.move(crb, masm, (AllocatableValue)this.scratch.asValue(this.getInput().getValueKind()), (Value)this.getInput(), this.encoding);
            AMD64VectorMove.move(crb, masm, this.getResult(), (Value)this.scratch.asValue(this.getResult().getValueKind()), this.encoding);
            AMD64VectorMove.move(crb, masm, (AllocatableValue)this.scratch.asValue(this.backupSlot.getValueKind()), (Value)this.backupSlot, backupEnc);
        }
    }

    @Opcode(value="VMOVE")
    public static class MoveFromArrayConstOp
    extends AMD64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<MoveFromArrayConstOp> TYPE = LIRInstructionClass.create(MoveFromArrayConstOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        private final DataPointerConstant input;
        private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;

        public MoveFromArrayConstOp(AllocatableValue result, DataPointerConstant input, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.encoding = encoding;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
            assert (kind.isXMM()) : "Can only move array to XMM register";
            int alignment = crb.dataBuilder.ensureValidDataAlignment(this.input.getAlignment());
            AMD64Assembler.VexMoveOp.VMOVDQU32.encoding(this.encoding).emit((AMD64Assembler)masm, AVXKind.getRegisterSize((Value)this.result), ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.recordDataReferenceInCode((Constant)this.input, alignment));
        }

        @Override
        public Constant getConstant() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public boolean canRematerializeToStack() {
            return false;
        }
    }

    @Opcode(value="VMOVE")
    public static class MoveFromConstOp
    extends AMD64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<MoveFromConstOp> TYPE = LIRInstructionClass.create(MoveFromConstOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        private final JavaConstant input;
        private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;

        public MoveFromConstOp(AllocatableValue result, JavaConstant input, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.encoding = encoding;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                AMD64VectorMove.const2reg(crb, masm, (RegisterValue)this.result, this.input, this.encoding);
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                AMD64Move.const2stack(crb, masm, (Value)this.result, this.input);
            }
        }

        @Override
        public Constant getConstant() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public boolean canRematerializeToStack() {
            return true;
        }
    }

    @Opcode(value="VMOVE")
    public static final class MoveFromRegOp
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<MoveFromRegOp> TYPE = LIRInstructionClass.create(MoveFromRegOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue input;
        private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;

        public MoveFromRegOp(AllocatableValue result, AllocatableValue input, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.encoding = encoding;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64VectorMove.move(crb, masm, this.result, (Value)this.input, this.encoding);
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    @Opcode(value="VMOVE")
    public static final class MoveToRegOp
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<MoveToRegOp> TYPE = LIRInstructionClass.create(MoveToRegOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;
        private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;

        public MoveToRegOp(AllocatableValue result, AllocatableValue input, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.encoding = encoding;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64VectorMove.move(crb, masm, this.result, (Value)this.input, this.encoding);
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }
}

