/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.vector;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.vector.AVX512Support;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AMD64VectorGather {

    public static class EvexVectorGatherOp
    extends AbstractGatherOp
    implements AVX512Support {
        public static final LIRInstructionClass<EvexVectorGatherOp> TYPE = LIRInstructionClass.create(EvexVectorGatherOp.class);
        @Opcode
        private final AMD64Assembler.EvexGatherOp opcode;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue mask;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue maskTemp;

        public EvexVectorGatherOp(AMD64Assembler.EvexGatherOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue base, AllocatableValue index, AllocatableValue mask) {
            super(TYPE, size, result, base, index);
            this.opcode = opcode;
            this.mask = mask;
            this.maskTemp = mask;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Address address = new AMD64Address(ValueUtil.asRegister((Value)this.base), ValueUtil.asRegister((Value)this.index), Stride.S1);
            this.opcode.emit(masm, this.size, ValueUtil.asRegister((Value)this.result), address, ValueUtil.asRegister((Value)this.mask), 0, 0);
        }

        @Override
        public AMD64Assembler.EvexGatherOp getOpcode() {
            return this.opcode;
        }

        @Override
        public AllocatableValue getOpmask() {
            return this.mask;
        }
    }

    public static class VexVectorGatherOp
    extends AbstractGatherOp {
        public static final LIRInstructionClass<VexVectorGatherOp> TYPE = LIRInstructionClass.create(VexVectorGatherOp.class);
        @Opcode
        private final AMD64Assembler.VexGatherOp opcode;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue mask;
        @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue maskTemp;

        public VexVectorGatherOp(AMD64Assembler.VexGatherOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue base, AllocatableValue index, AllocatableValue mask) {
            super(TYPE, size, result, base, index);
            this.opcode = opcode;
            this.mask = mask;
            this.maskTemp = mask;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Address address = new AMD64Address(ValueUtil.asRegister((Value)this.base), ValueUtil.asRegister((Value)this.index), Stride.S1);
            this.opcode.emit(masm, this.size, ValueUtil.asRegister((Value)this.result), address, ValueUtil.asRegister((Value)this.mask));
        }

        @Override
        public AMD64Assembler.VexGatherOp getOpcode() {
            return this.opcode;
        }
    }

    private static abstract class AbstractGatherOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AbstractGatherOp> TYPE = LIRInstructionClass.create(AbstractGatherOp.class);
        protected final AVXKind.AVXSize size;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue base;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue index;

        AbstractGatherOp(LIRInstructionClass<? extends AbstractGatherOp> c, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue base, AllocatableValue index) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
            this.size = size;
            this.result = result;
            this.base = base;
            this.index = index;
        }

        public abstract AMD64Assembler.VexOp getOpcode();
    }
}

