/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.vector;

import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AMD64VectorClearOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64VectorClearOp> TYPE = LIRInstructionClass.create(AMD64VectorClearOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    private final AMD64Assembler.AMD64SIMDInstructionEncoding encoding;
    private static final AMD64Assembler.VexRVROp[] KXOR_OPS = new AMD64Assembler.VexRVROp[]{AMD64Assembler.VexRVROp.KXORB, AMD64Assembler.VexRVROp.KXORW, AMD64Assembler.VexRVROp.KXORD, AMD64Assembler.VexRVROp.KXORQ};

    public AMD64VectorClearOp(AllocatableValue result, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
        this(TYPE, result, encoding);
    }

    protected AMD64VectorClearOp(LIRInstructionClass<? extends AMD64VectorClearOp> c, AllocatableValue result, AMD64Assembler.AMD64SIMDInstructionEncoding encoding) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
        this.result = result;
        this.encoding = encoding;
    }

    public static AMD64VectorClearOp clearMask(AllocatableValue result) {
        assert (((AMD64Kind)result.getPlatformKind()).isMask()) : "This method is only intended to be used to clear op mask values";
        return new AMD64VectorClearOp(result, AMD64Assembler.AMD64SIMDInstructionEncoding.VEX);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Kind kind = (AMD64Kind)this.result.getPlatformKind();
        Register register = ValueUtil.asRegister((Value)this.result);
        if (kind.isMask()) {
            KXOR_OPS[CodeUtil.log2((int)kind.getSizeInBytes())].emit(masm, register, register, register);
            return;
        }
        switch (kind.getScalar()) {
            case SINGLE: {
                AMD64Assembler.VexRVMOp.VXORPS.encoding(this.encoding).emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, register, register);
                break;
            }
            case DOUBLE: {
                AMD64Assembler.VexRVMOp.VXORPD.encoding(this.encoding).emit((AMD64Assembler)masm, AVXKind.getRegisterSize(kind), register, register, register);
                break;
            }
            default: {
                AMD64Assembler.VexRVMOp.VPXOR.encoding(this.encoding).emit((AMD64Assembler)masm, AVXKind.AVXSize.XMM, register, register, register);
            }
        }
    }
}

