/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.vector;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.vector.AMD64VectorInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AMD64VectorBinary {

    public static final class AVXOpMaskBinaryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXOpMaskBinaryOp> TYPE = LIRInstructionClass.create(AVXOpMaskBinaryOp.class);
        @Opcode
        private final AMD64Assembler.VexRVROp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;

        public AVXOpMaskBinaryOp(AMD64Assembler.VexRVROp opcode, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super(TYPE, AVXKind.AVXSize.XMM);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            this.opcode.emit(masm, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
        }
    }

    public static final class AVXBinaryMemoryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryMemoryOp> TYPE = LIRInstructionClass.create(AVXBinaryMemoryOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue y;
        @LIRInstruction.State
        protected LIRFrameState state;

        public AVXBinaryMemoryOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AMD64AddressValue y, LIRFrameState state) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.state != null) {
                crb.recordImplicitException(masm.position(), this.state);
            }
            this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), this.y.toAddress(masm));
        }
    }

    public static final class AVXBinaryConstFloatOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryConstFloatOp> TYPE = LIRInstructionClass.create(AVXBinaryConstFloatOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        protected ConstantValue y;

        public AVXBinaryConstFloatOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, ConstantValue y) {
            super(TYPE, size);
            assert (y.getPlatformKind() == AMD64Kind.SINGLE || y.getPlatformKind() == AMD64Kind.DOUBLE) : Assertions.errorMessage(new Object[]{y});
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.y.getPlatformKind() == AMD64Kind.SINGLE) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asFloatConstRef(this.y.getJavaConstant(), this.opcode.isPacked() ? AMD64BaseAssembler.OperandSize.PS.getBytes() : 4));
            } else {
                assert (this.y.getPlatformKind() == AMD64Kind.DOUBLE) : Assertions.errorMessage(new Object[]{this.y});
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asDoubleConstRef(this.y.getJavaConstant(), this.opcode.isPacked() ? AMD64BaseAssembler.OperandSize.PD.getBytes() : 8));
            }
        }
    }

    public static final class AVXBinaryConstOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryConstOp> TYPE = LIRInstructionClass.create(AVXBinaryConstOp.class);
        @Opcode
        private final AMD64Assembler.VexRRIOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        protected int y;

        public AVXBinaryConstOp(AMD64Assembler.VexRRIOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, int y) {
            super(TYPE, size);
            assert ((y & 0xFF) == y) : y;
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            this.opcode.emit(masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), this.y);
        }
    }

    public static final class AVXBinaryOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<AVXBinaryOp> TYPE = LIRInstructionClass.create(AVXBinaryOp.class);
        @Opcode
        private final AMD64Assembler.VexOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue y;

        public AVXBinaryOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        public AVXBinaryOp(AMD64Assembler.VexGeneralPurposeRMVOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.x = y;
            this.y = x;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.VexOp vexOp = this.opcode;
            Objects.requireNonNull(vexOp);
            AMD64Assembler.VexOp vexOp2 = vexOp;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AMD64Assembler.VexRVMOp.class, AMD64Assembler.VexGeneralPurposeRMVOp.class}, (Object)vexOp2, n)) {
                case 0: {
                    AMD64Assembler.VexRVMOp rvmOp = (AMD64Assembler.VexRVMOp)vexOp2;
                    if (ValueUtil.isRegister((Value)this.y)) {
                        rvmOp.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
                        break;
                    }
                    rvmOp.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.x), (AMD64Address)crb.asAddress((Value)this.y));
                    break;
                }
                case 1: {
                    AMD64Assembler.VexGeneralPurposeRMVOp rmvOp = (AMD64Assembler.VexGeneralPurposeRMVOp)vexOp2;
                    if (ValueUtil.isRegister((Value)this.y)) {
                        rmvOp.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.y), ValueUtil.asRegister((Value)this.x));
                        break;
                    }
                    rmvOp.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.asAddress((Value)this.y), ValueUtil.asRegister((Value)this.x));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue(this.opcode);
                }
            }
        }
    }
}

