/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.g1;

import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.g1.AMD64G1BarrierSetLIRTool;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/43a2f17342af8f5bf1f5823df9fa0bf0bdfdfce2/src/hotspot/cpu/x86/gc/g1/g1BarrierSetAssembler_x86.cpp#L266-L342", ignore="GR-58685", sha1="5691006914119b2a6047c6935a3d4fe656dc663f")
public class AMD64G1PostWriteBarrierOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64G1PostWriteBarrierOp> TYPE = LIRInstructionClass.create(AMD64G1PostWriteBarrierOp.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value address;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value newValue;
    @LIRInstruction.Temp
    private Value temp;
    @LIRInstruction.Temp
    private Value temp2;
    private final ForeignCallLinkage callTarget;
    private final boolean nonNull;
    private final AMD64G1BarrierSetLIRTool tool;

    public AMD64G1PostWriteBarrierOp(Value address, Value value, AllocatableValue temp, AllocatableValue temp2, ForeignCallLinkage callTarget, boolean nonNull, AMD64G1BarrierSetLIRTool tool) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.address = address;
        this.newValue = value;
        this.temp = temp;
        this.temp2 = temp2;
        this.callTarget = callTarget;
        this.nonNull = nonNull;
        this.tool = tool;
        assert (!address.equals((Object)value)) : "this can be filtered out statically";
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register storeAddress = ValueUtil.asRegister((Value)this.address);
        Register newval = ValueUtil.asRegister((Value)this.newValue);
        Register tmp = ValueUtil.asRegister((Value)this.temp);
        Register tmp2 = ValueUtil.asRegister((Value)this.temp2);
        Assembler.guaranteeDifferentRegisters(storeAddress, newval, tmp, tmp2);
        Label done = new Label();
        Label runtime = new Label();
        masm.movq(tmp, storeAddress);
        masm.xorq(tmp, newval);
        masm.shrq(tmp, this.tool.logOfHeapRegionGrainBytes());
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, done);
        if (!this.nonNull) {
            masm.testq(newval, newval);
            masm.jcc(AMD64Assembler.ConditionFlag.Equal, done);
        }
        Register cardAddress = tmp;
        this.tool.computeCard(cardAddress, storeAddress, tmp2, masm);
        masm.cmpb(new AMD64Address(cardAddress, 0), this.tool.youngCardValue());
        masm.jccb(AMD64Assembler.ConditionFlag.Equal, done);
        masm.membar(4);
        masm.cmpb(new AMD64Address(cardAddress, 0), this.tool.dirtyCardValue());
        masm.jccb(AMD64Assembler.ConditionFlag.Equal, done);
        if (GraalOptions.AssemblyGCBarriersSlowPathOnly.getValue(crb.getOptions()).booleanValue()) {
            masm.jmp(runtime);
        } else {
            masm.movb(new AMD64Address(cardAddress, 0), this.tool.dirtyCardValue());
            Register thread = this.tool.getThread(masm);
            AMD64Address cardQueueIndex = new AMD64Address(thread, this.tool.cardQueueIndexOffset());
            AMD64Address cardQueueBuffer = new AMD64Address(thread, this.tool.cardQueueBufferOffset());
            masm.movq(tmp2, cardQueueIndex);
            masm.testq(tmp2, tmp2);
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, runtime);
            masm.subq(tmp2, 8);
            masm.movq(cardQueueIndex, tmp2);
            masm.addq(tmp2, cardQueueBuffer);
            masm.movq(new AMD64Address(tmp2, 0), cardAddress);
        }
        masm.bind(done);
        crb.getLIR().addSlowPath(this, () -> {
            masm.bind(runtime);
            CallingConvention cc = this.callTarget.getOutgoingCallingConvention();
            AllocatableValue arg0 = cc.getArgument(0);
            if (arg0 instanceof StackSlot) {
                AMD64Address cArg0 = (AMD64Address)crb.asAddress((Value)arg0);
                masm.movq(cArg0, cardAddress);
            } else {
                GraalError.shouldNotReachHere("must be StackSlot: " + String.valueOf(arg0));
            }
            AMD64Call.directCall(crb, masm, this.tool.getCallTarget(this.callTarget), null, false, null);
            masm.jmp(done);
        });
    }
}

