/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64.g1;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.amd64.g1.AMD64G1BarrierSetLIRTool;
import jdk.graal.compiler.lir.amd64.g1.AMD64G1PostWriteBarrierOp;
import jdk.graal.compiler.lir.amd64.g1.AMD64G1PreWriteBarrierOp;
import jdk.graal.compiler.lir.gen.G1WriteBarrierSetLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;

public class AMD64G1BarrierSetLIRGenerator
implements G1WriteBarrierSetLIRGeneratorTool {
    private final AMD64G1BarrierSetLIRTool barrierSetLIRTool;

    public AMD64G1BarrierSetLIRGenerator(AMD64G1BarrierSetLIRTool barrierSetLIRTool) {
        this.barrierSetLIRTool = barrierSetLIRTool;
    }

    @Override
    public void emitPreWriteBarrier(LIRGeneratorTool lirTool, Value address, AllocatableValue expectedObject, boolean nonNull) {
        Variable temp = lirTool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        AllocatableValue temp2 = expectedObject.equals((Object)Value.ILLEGAL) ? lirTool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.QWORD)) : Value.ILLEGAL;
        OptionValues options = lirTool.getResult().getLIR().getOptions();
        AllocatableValue temp3 = GraalOptions.VerifyAssemblyGCBarriers.getValue(options) != false ? lirTool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.QWORD)) : Value.ILLEGAL;
        ForeignCallLinkage callTarget = lirTool.getForeignCalls().lookupForeignCall(this.barrierSetLIRTool.preWriteBarrierDescriptor());
        lirTool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        lirTool.append(new AMD64G1PreWriteBarrierOp(address, (Value)expectedObject, (Value)temp, temp2, temp3, callTarget, nonNull, this.barrierSetLIRTool));
    }

    @Override
    public void emitPostWriteBarrier(LIRGeneratorTool lirTool, Value address, Value value, boolean nonNull) {
        Variable temp = lirTool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        Variable temp2 = lirTool.newVariable(LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        ForeignCallLinkage callTarget = lirTool.getForeignCalls().lookupForeignCall(this.barrierSetLIRTool.postWriteBarrierDescriptor());
        lirTool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        lirTool.append(new AMD64G1PostWriteBarrierOp(address, value, temp, temp2, callTarget, nonNull, this.barrierSetLIRTool));
    }
}

