/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

@Opcode(value="ZERO_MEMORY")
public final class AMD64ZeroMemoryOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ZeroMemoryOp> TYPE = LIRInstructionClass.create(AMD64ZeroMemoryOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
    protected AMD64AddressValue pointer;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected RegisterValue length;
    @LIRInstruction.Temp
    protected Value pointerTemp;
    @LIRInstruction.Temp
    protected Value valueTemp;
    @LIRInstruction.Temp
    protected Value lengthTemp;

    public AMD64ZeroMemoryOp(AMD64AddressValue pointer, RegisterValue length) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.pointer = pointer;
        this.length = length;
        this.pointerTemp = AMD64.rdi.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        this.valueTemp = AMD64.rax.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        this.lengthTemp = AMD64.rcx.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        assert (AMD64.rcx.equals((Object)this.length.getRegister()));
        masm.leaq(AMD64.rdi, this.pointer.toAddress(masm));
        masm.xorq(AMD64.rax, AMD64.rax);
        masm.repStosb();
    }
}

