/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaConstant;

@Opcode(value="ZAP_REGISTER")
public final class AMD64ZapRegistersOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64ZapRegistersOp> TYPE = LIRInstructionClass.create(AMD64ZapRegistersOp.class);
    protected final Register[] zappedRegisters;
    protected final JavaConstant[] zapValues;

    public AMD64ZapRegistersOp(Register[] zappedRegisters, JavaConstant[] zapValues) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.zappedRegisters = zappedRegisters;
        this.zapValues = zapValues;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        for (int i = 0; i < this.zappedRegisters.length; ++i) {
            Register reg = this.zappedRegisters[i];
            if (reg == null) continue;
            if (reg.getRegisterCategory().equals((Object)AMD64.MASK)) {
                if (masm.supports(AMD64.CPUFeature.AVX512BW)) {
                    masm.kmovq(reg, (AMD64Address)crb.asLongConstRef(this.zapValues[i]));
                    continue;
                }
                assert (masm.supports(AMD64.CPUFeature.AVX512F));
                masm.kmovw(reg, (AMD64Address)crb.asLongConstRef(this.zapValues[i]));
                continue;
            }
            AMD64Move.const2reg(crb, masm, reg, this.zapValues[i], AMD64Kind.QWORD);
        }
    }
}

