/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import java.util.ArrayList;
import java.util.BitSet;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

public class AMD64VZeroUpper
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64VZeroUpper> TYPE = LIRInstructionClass.create(AMD64VZeroUpper.class);
    @LIRInstruction.Temp
    protected final RegisterValue[] xmmRegisters;

    public AMD64VZeroUpper(Value[] exclude, RegisterConfig registerConfig) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.xmmRegisters = AMD64VZeroUpper.initRegisterValues(exclude, registerConfig);
    }

    private static RegisterValue[] initRegisterValues(Value[] exclude, RegisterConfig registerConfig) {
        BitSet skippedRegs = new BitSet();
        if (exclude != null) {
            for (Value value : exclude) {
                if (!ValueUtil.isRegister((Value)value) || !ValueUtil.asRegister((Value)value).getRegisterCategory().equals((Object)AMD64.XMM)) continue;
                skippedRegs.set(ValueUtil.asRegister((Value)value).number);
            }
        }
        ArrayList<RegisterValue> regs = new ArrayList<RegisterValue>();
        for (Register r : registerConfig.getCallerSaveRegisters()) {
            if (!r.getRegisterCategory().equals((Object)AMD64.XMM) || skippedRegs.get(r.number)) continue;
            regs.add(r.asValue());
        }
        return regs.toArray(new RegisterValue[regs.size()]);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
        asm.vzeroupper();
    }
}

