/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.vector.AMD64VectorInstruction;
import jdk.graal.compiler.lir.amd64.vector.AMD64VectorMove;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AMD64Ternary {

    public static class ThreeOp
    extends AMD64VectorInstruction {
        public static final LIRInstructionClass<ThreeOp> TYPE = LIRInstructionClass.create(ThreeOp.class);
        @Opcode
        private final AMD64Assembler.VexRVMOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue z;

        public ThreeOp(AMD64Assembler.VexRVMOp opcode, AVXKind.AVXSize size, AllocatableValue result, AllocatableValue x, AllocatableValue y, AllocatableValue z) {
            super(TYPE, size);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.AMD64SIMDInstructionEncoding simdEncoding = AMD64Assembler.AMD64SIMDInstructionEncoding.forFeatures(masm.getFeatures());
            new AMD64VectorMove.MoveToRegOp(this.result, this.x, simdEncoding).emitCode(crb, masm);
            if (ValueUtil.isRegister((Value)this.z)) {
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.y), ValueUtil.asRegister((Value)this.z));
            } else {
                assert (ValueUtil.isStackSlot((Value)this.z));
                this.opcode.emit((AMD64Assembler)masm, this.size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.y), (AMD64Address)crb.asAddress((Value)this.z));
            }
        }
    }
}

