/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

@Opcode(value="CDQ")
public class AMD64SignExtendOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64SignExtendOp> TYPE = LIRInstructionClass.create(AMD64SignExtendOp.class);
    private final AMD64BaseAssembler.OperandSize size;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue highResult;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue lowResult;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue input;

    public AMD64SignExtendOp(AMD64BaseAssembler.OperandSize size, LIRKind resultKind, AllocatableValue input) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.size = size;
        this.highResult = AMD64.rdx.asValue((ValueKind)resultKind);
        this.lowResult = AMD64.rax.asValue((ValueKind)resultKind);
        this.input = input;
    }

    public AllocatableValue getHighResult() {
        return this.highResult;
    }

    public AllocatableValue getLowResult() {
        return this.lowResult;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (this.size == AMD64BaseAssembler.OperandSize.DWORD) {
            masm.cdql();
        } else {
            assert (this.size == AMD64BaseAssembler.OperandSize.QWORD) : this.size;
            masm.cdqq();
        }
    }

    @Override
    public void verify() {
        assert (ValueUtil.asRegister((Value)this.highResult).equals((Object)AMD64.rdx));
        assert (ValueUtil.asRegister((Value)this.lowResult).equals((Object)AMD64.rax));
        assert (ValueUtil.asRegister((Value)this.input).equals((Object)AMD64.rax));
    }
}

