/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64LIRHelper;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/f0b72f728d357a257074177fbea2f1ff70cf70f2/src/hotspot/cpu/x86/stubGenerator_x86_64_sha3.cpp#L42-L326", sha1="714247ae095f919159a8835d1435f497bbcd3643")
public final class AMD64SHA3Op
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64SHA3Op> TYPE = LIRInstructionClass.create(AMD64SHA3Op.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value blockSizeValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] gprTemps;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] xmmTemps;
    private final boolean multiBlock;
    static ArrayDataPointerConstant roundConstsAddr = AMD64LIRHelper.pointerConstant(16, new long[]{1L, 32898L, -9223372036854742902L, -9223372034707259392L, 32907L, 0x80000001L, -9223372034707259263L, -9223372036854743031L, 138L, 136L, 0x80008009L, 0x8000000AL, 0x8000808BL, -9223372036854775669L, -9223372036854742903L, -9223372036854743037L, -9223372036854743038L, -9223372036854775680L, 32778L, -9223372034707292150L, -9223372034707259263L, -9223372036854742912L, 0x80000001L, -9223372034707259384L});
    static ArrayDataPointerConstant permsAndRotsAddr = AMD64LIRHelper.pointerConstant(16, new long[]{9L, 2L, 11L, 0L, 1L, 2L, 3L, 4L, 8L, 1L, 9L, 2L, 11L, 4L, 12L, 0L, 9L, 2L, 10L, 3L, 11L, 4L, 12L, 0L, 8L, 9L, 2L, 3L, 4L, 5L, 6L, 7L, 0L, 8L, 9L, 10L, 15L, 0L, 0L, 0L, 4L, 5L, 8L, 9L, 6L, 7L, 10L, 11L, 0L, 1L, 2L, 3L, 13L, 0L, 0L, 0L, 2L, 3L, 0L, 1L, 11L, 0L, 0L, 0L, 4L, 5L, 6L, 7L, 14L, 0L, 0L, 0L, 14L, 15L, 12L, 13L, 4L, 0L, 0L, 0L, 1L, 6L, 62L, 55L, 28L, 20L, 27L, 36L, 3L, 45L, 10L, 15L, 25L, 8L, 39L, 41L, 44L, 43L, 21L, 18L, 2L, 61L, 56L, 14L, 12L, 8L, 9L, 10L, 11L, 5L, 6L, 7L, 9L, 10L, 11L, 12L, 8L, 5L, 6L, 7L});

    public AMD64SHA3Op(AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue blockSizeValue) {
        this(bufValue, stateValue, blockSizeValue, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AMD64SHA3Op(AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue blockSizeValue, AllocatableValue ofsValue, AllocatableValue limitValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.blockSizeValue = blockSizeValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.multiBlock = multiBlock;
        if (multiBlock) {
            GraalError.guarantee(ValueUtil.asRegister((Value)bufValue).equals((Object)AMD64.rdi), "expect bufValue at rdi, but was %s", (Object)bufValue);
            GraalError.guarantee(ValueUtil.asRegister((Value)ofsValue).equals((Object)AMD64.rcx), "expect ofsValue at rcx, but was %s", (Object)ofsValue);
            this.gprTemps = new Value[]{AMD64.rax.asValue(), AMD64.rcx.asValue(), AMD64.rdi.asValue(), AMD64.r10.asValue(), AMD64.r11.asValue()};
        } else {
            this.gprTemps = new Value[]{AMD64.rax.asValue(), AMD64.r10.asValue(), AMD64.r11.asValue()};
        }
        this.xmmTemps = new Value[]{AMD64.k1.asValue(), AMD64.k2.asValue(), AMD64.k3.asValue(), AMD64.k4.asValue(), AMD64.k5.asValue(), AMD64.xmm0.asValue(), AMD64.xmm1.asValue(), AMD64.xmm2.asValue(), AMD64.xmm3.asValue(), AMD64.xmm4.asValue(), AMD64.xmm5.asValue(), AMD64.xmm6.asValue(), AMD64.xmm17.asValue(), AMD64.xmm18.asValue(), AMD64.xmm19.asValue(), AMD64.xmm20.asValue(), AMD64.xmm20.asValue(), AMD64.xmm21.asValue(), AMD64.xmm22.asValue(), AMD64.xmm23.asValue(), AMD64.xmm24.asValue(), AMD64.xmm25.asValue(), AMD64.xmm26.asValue(), AMD64.xmm27.asValue(), AMD64.xmm28.asValue(), AMD64.xmm29.asValue(), AMD64.xmm30.asValue(), AMD64.xmm31.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register buf = ValueUtil.asRegister((Value)this.bufValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        Register blockSize = ValueUtil.asRegister((Value)this.blockSizeValue);
        Register permsAndRots = AMD64.r10;
        Register roundConsts = AMD64.r11;
        Register constant2use = AMD64.r13;
        Register roundsLeft = AMD64.r14;
        Label sha3Loop = new Label();
        Label rounds24Loop = new Label();
        Label block104 = new Label();
        Label block136 = new Label();
        Label block144 = new Label();
        Label block168 = new Label();
        masm.push(AMD64.r12);
        masm.push(AMD64.r13);
        masm.push(AMD64.r14);
        masm.leaq(permsAndRots, AMD64LIRHelper.recordExternalAddress(crb, permsAndRotsAddr));
        masm.leaq(roundConsts, AMD64LIRHelper.recordExternalAddress(crb, roundConstsAddr));
        masm.movl(AMD64.rax, 31);
        masm.kmovw(AMD64.k5, AMD64.rax);
        masm.kshiftrw(AMD64.k4, AMD64.k5, 1);
        masm.kshiftrw(AMD64.k3, AMD64.k5, 2);
        masm.kshiftrw(AMD64.k2, AMD64.k5, 3);
        masm.kshiftrw(AMD64.k1, AMD64.k5, 4);
        masm.evmovdqu64(AMD64.xmm0, AMD64.k5, new AMD64Address(state, 0));
        masm.evmovdqu64(AMD64.xmm1, AMD64.k5, new AMD64Address(state, 40));
        masm.evmovdqu64(AMD64.xmm2, AMD64.k5, new AMD64Address(state, 80));
        masm.evmovdqu64(AMD64.xmm3, AMD64.k5, new AMD64Address(state, 120));
        masm.evmovdqu64(AMD64.xmm4, AMD64.k5, new AMD64Address(state, 160));
        masm.evmovdqu64(AMD64.xmm17, new AMD64Address(permsAndRots, 0));
        masm.evmovdqu64(AMD64.xmm18, new AMD64Address(permsAndRots, 64));
        masm.evmovdqu64(AMD64.xmm19, new AMD64Address(permsAndRots, 128));
        masm.evmovdqu64(AMD64.xmm20, new AMD64Address(permsAndRots, 192));
        masm.evmovdqu64(AMD64.xmm21, new AMD64Address(permsAndRots, 256));
        masm.evmovdqu64(AMD64.xmm22, new AMD64Address(permsAndRots, 320));
        masm.evmovdqu64(AMD64.xmm23, new AMD64Address(permsAndRots, 384));
        masm.evmovdqu64(AMD64.xmm24, new AMD64Address(permsAndRots, 448));
        masm.evmovdqu64(AMD64.xmm25, new AMD64Address(permsAndRots, 512));
        masm.evmovdqu64(AMD64.xmm26, new AMD64Address(permsAndRots, 576));
        masm.evmovdqu64(AMD64.xmm27, new AMD64Address(permsAndRots, 640));
        masm.evmovdqu64(AMD64.xmm28, new AMD64Address(permsAndRots, 704));
        masm.evmovdqu64(AMD64.xmm29, new AMD64Address(permsAndRots, 768));
        masm.evmovdqu64(AMD64.xmm30, new AMD64Address(permsAndRots, 832));
        masm.evmovdqu64(AMD64.xmm31, new AMD64Address(permsAndRots, 896));
        masm.bind(sha3Loop);
        masm.movl(roundsLeft, 24);
        masm.movq(constant2use, roundConsts);
        masm.evpxorq(AMD64.xmm0, AMD64.k5, AMD64.xmm0, new AMD64Address(buf, 0));
        masm.cmplAndJcc(blockSize, 72, AMD64Assembler.ConditionFlag.NotEqual, block104, false);
        masm.evpxorq(AMD64.xmm1, AMD64.k4, AMD64.xmm1, new AMD64Address(buf, 40));
        masm.jmp(rounds24Loop);
        masm.bind(block104);
        masm.cmplAndJcc(blockSize, 104, AMD64Assembler.ConditionFlag.NotEqual, block136, false);
        masm.evpxorq(AMD64.xmm1, AMD64.k5, AMD64.xmm1, new AMD64Address(buf, 40));
        masm.evpxorq(AMD64.xmm2, AMD64.k3, AMD64.xmm2, new AMD64Address(buf, 80));
        masm.jmp(rounds24Loop);
        masm.bind(block136);
        masm.cmplAndJcc(blockSize, 136, AMD64Assembler.ConditionFlag.NotEqual, block144, false);
        masm.evpxorq(AMD64.xmm1, AMD64.k5, AMD64.xmm1, new AMD64Address(buf, 40));
        masm.evpxorq(AMD64.xmm2, AMD64.k5, AMD64.xmm2, new AMD64Address(buf, 80));
        masm.evpxorq(AMD64.xmm3, AMD64.k2, AMD64.xmm3, new AMD64Address(buf, 120));
        masm.jmp(rounds24Loop);
        masm.bind(block144);
        masm.cmplAndJcc(blockSize, 144, AMD64Assembler.ConditionFlag.NotEqual, block168, false);
        masm.evpxorq(AMD64.xmm1, AMD64.k5, AMD64.xmm1, new AMD64Address(buf, 40));
        masm.evpxorq(AMD64.xmm2, AMD64.k5, AMD64.xmm2, new AMD64Address(buf, 80));
        masm.evpxorq(AMD64.xmm3, AMD64.k3, AMD64.xmm3, new AMD64Address(buf, 120));
        masm.jmp(rounds24Loop);
        masm.bind(block168);
        masm.evpxorq(AMD64.xmm1, AMD64.k5, AMD64.xmm1, new AMD64Address(buf, 40));
        masm.evpxorq(AMD64.xmm2, AMD64.k5, AMD64.xmm2, new AMD64Address(buf, 80));
        masm.evpxorq(AMD64.xmm3, AMD64.k5, AMD64.xmm3, new AMD64Address(buf, 120));
        masm.evpxorq(AMD64.xmm4, AMD64.k1, AMD64.xmm4, new AMD64Address(buf, 160));
        masm.bind(rounds24Loop);
        masm.subl(roundsLeft, 1);
        masm.evmovdqu16(AMD64.xmm5, AMD64.xmm0);
        masm.evpternlogq(AMD64.xmm5, 150, AMD64.xmm1, AMD64.xmm2);
        masm.evpternlogq(AMD64.xmm5, 150, AMD64.xmm3, AMD64.xmm4);
        masm.evprolq(AMD64.xmm6, AMD64.xmm5, 1);
        masm.evpermt2q(AMD64.xmm5, AMD64.xmm30, AMD64.xmm5);
        masm.evpermt2q(AMD64.xmm6, AMD64.xmm31, AMD64.xmm6);
        masm.evpternlogq(AMD64.xmm0, 150, AMD64.xmm5, AMD64.xmm6);
        masm.evpternlogq(AMD64.xmm1, 150, AMD64.xmm5, AMD64.xmm6);
        masm.evpternlogq(AMD64.xmm2, 150, AMD64.xmm5, AMD64.xmm6);
        masm.evpternlogq(AMD64.xmm3, 150, AMD64.xmm5, AMD64.xmm6);
        masm.evpternlogq(AMD64.xmm4, 150, AMD64.xmm5, AMD64.xmm6);
        masm.evpermt2q(AMD64.xmm4, AMD64.xmm17, AMD64.xmm3);
        masm.evpermt2q(AMD64.xmm3, AMD64.xmm18, AMD64.xmm2);
        masm.evpermt2q(AMD64.xmm2, AMD64.xmm17, AMD64.xmm1);
        masm.evpermt2q(AMD64.xmm1, AMD64.xmm19, AMD64.xmm0);
        masm.evpermt2q(AMD64.xmm4, AMD64.xmm20, AMD64.xmm2);
        masm.evprolvq(AMD64.xmm1, AMD64.xmm1, AMD64.xmm27);
        masm.evprolvq(AMD64.xmm3, AMD64.xmm3, AMD64.xmm28);
        masm.evprolvq(AMD64.xmm4, AMD64.xmm4, AMD64.xmm29);
        masm.evmovdqu16(AMD64.xmm2, AMD64.xmm1);
        masm.evmovdqu16(AMD64.xmm5, AMD64.xmm3);
        masm.evpermt2q(AMD64.xmm0, AMD64.xmm21, AMD64.xmm4);
        masm.evpermt2q(AMD64.xmm1, AMD64.xmm22, AMD64.xmm3);
        masm.evpermt2q(AMD64.xmm5, AMD64.xmm22, AMD64.xmm2);
        masm.evmovdqu16(AMD64.xmm3, AMD64.xmm1);
        masm.evmovdqu16(AMD64.xmm2, AMD64.xmm5);
        masm.evpermt2q(AMD64.xmm1, AMD64.xmm23, AMD64.xmm4);
        masm.evpermt2q(AMD64.xmm2, AMD64.xmm24, AMD64.xmm4);
        masm.evpermt2q(AMD64.xmm3, AMD64.xmm25, AMD64.xmm4);
        masm.evpermt2q(AMD64.xmm4, AMD64.xmm26, AMD64.xmm5);
        masm.evpermt2q(AMD64.xmm5, AMD64.xmm31, AMD64.xmm0);
        masm.evpermt2q(AMD64.xmm6, AMD64.xmm31, AMD64.xmm5);
        masm.evpternlogq(AMD64.xmm0, 180, AMD64.xmm6, AMD64.xmm5);
        masm.evpermt2q(AMD64.xmm5, AMD64.xmm31, AMD64.xmm1);
        masm.evpermt2q(AMD64.xmm6, AMD64.xmm31, AMD64.xmm5);
        masm.evpternlogq(AMD64.xmm1, 180, AMD64.xmm6, AMD64.xmm5);
        masm.evpxorq(AMD64.xmm0, AMD64.k1, AMD64.xmm0, new AMD64Address(constant2use, 0));
        masm.addq(constant2use, 8);
        masm.evpermt2q(AMD64.xmm5, AMD64.xmm31, AMD64.xmm2);
        masm.evpermt2q(AMD64.xmm6, AMD64.xmm31, AMD64.xmm5);
        masm.evpternlogq(AMD64.xmm2, 180, AMD64.xmm6, AMD64.xmm5);
        masm.evpermt2q(AMD64.xmm5, AMD64.xmm31, AMD64.xmm3);
        masm.evpermt2q(AMD64.xmm6, AMD64.xmm31, AMD64.xmm5);
        masm.evpternlogq(AMD64.xmm3, 180, AMD64.xmm6, AMD64.xmm5);
        masm.evpermt2q(AMD64.xmm5, AMD64.xmm31, AMD64.xmm4);
        masm.evpermt2q(AMD64.xmm6, AMD64.xmm31, AMD64.xmm5);
        masm.evpternlogq(AMD64.xmm4, 180, AMD64.xmm6, AMD64.xmm5);
        masm.cmplAndJcc(roundsLeft, 0, AMD64Assembler.ConditionFlag.NotEqual, rounds24Loop, false);
        if (this.multiBlock) {
            Register ofs = ValueUtil.asRegister((Value)this.ofsValue);
            Register limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.addq(buf, blockSize);
            masm.addl(ofs, blockSize);
            masm.cmplAndJcc(ofs, limit, AMD64Assembler.ConditionFlag.LessEqual, sha3Loop, false);
            masm.movq(AMD64.rax, ofs);
        } else {
            masm.xorq(AMD64.rax, AMD64.rax);
        }
        masm.evmovdqu64(new AMD64Address(state, 0), AMD64.k5, AMD64.xmm0);
        masm.evmovdqu64(new AMD64Address(state, 40), AMD64.k5, AMD64.xmm1);
        masm.evmovdqu64(new AMD64Address(state, 80), AMD64.k5, AMD64.xmm2);
        masm.evmovdqu64(new AMD64Address(state, 120), AMD64.k5, AMD64.xmm3);
        masm.evmovdqu64(new AMD64Address(state, 160), AMD64.k5, AMD64.xmm4);
        masm.pop(AMD64.r14);
        masm.pop(AMD64.r13);
        masm.pop(AMD64.r12);
    }
}

