/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.amd64.AMD64LIRHelper;
import jdk.graal.compiler.lir.amd64.AMD64MathIntrinsicUnaryOp;
import jdk.graal.compiler.lir.asm.ArrayDataPointerConstant;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;

@SyncPort(from="https://github.com/openjdk/jdk/blob/212e32931cafe446d94219d6c3ffd92261984dff/src/hotspot/cpu/x86/stubGenerator_x86_64_tanh.cpp#L31-L500", sha1="b2eb58437ef628ce35348a90c3300b4c1e06341a")
public final class AMD64MathTanhOp
extends AMD64MathIntrinsicUnaryOp {
    public static final LIRInstructionClass<AMD64MathTanhOp> TYPE = LIRInstructionClass.create(AMD64MathTanhOp.class);
    private static ArrayDataPointerConstant halfMask = AMD64LIRHelper.pointerConstant(16, new int[]{-134217728, Integer.MAX_VALUE});
    private static ArrayDataPointerConstant oneMask = AMD64LIRHelper.pointerConstant(16, new int[]{0, 0x3FF00000});
    private static ArrayDataPointerConstant twoMask = AMD64LIRHelper.pointerConstant(16, new int[]{0, 0x40000000});
    private static ArrayDataPointerConstant threeMask = AMD64LIRHelper.pointerConstant(16, new int[]{0, -16, 0, -16});
    private static ArrayDataPointerConstant rMask = AMD64LIRHelper.pointerConstant(16, new int[]{-262144, -1, -262144, -1});
    private static ArrayDataPointerConstant l2e = AMD64LIRHelper.pointerConstant(16, new int[]{0x60000000, 1082594631});
    private static ArrayDataPointerConstant l2eOff8 = AMD64LIRHelper.pointerConstant(16, new int[]{-128065724, 1055174155});
    private static ArrayDataPointerConstant shifter = AMD64LIRHelper.pointerConstant(16, new int[]{0, 1127743488, 0, -1019740160});
    private static ArrayDataPointerConstant cv = AMD64LIRHelper.pointerConstant(16, new int[]{-410360015, -1126836097, -687562561, -1104385272});
    private static ArrayDataPointerConstant cvOff16 = AMD64LIRHelper.pointerConstant(16, new int[]{1874480759, 1032041131, -8206962, 1053736893});
    private static ArrayDataPointerConstant cvOff32 = AMD64LIRHelper.pointerConstant(16, new int[]{-17155601, -1083822526, 0, 0});
    private static ArrayDataPointerConstant pv = AMD64LIRHelper.pointerConstant(16, new int[]{236289503, 1064135997, 463583772, -1079270982});
    private static ArrayDataPointerConstant pvOff16 = AMD64LIRHelper.pointerConstant(16, new int[]{1441186365, -1081989405, 0x11111111, 1069617425});
    private static ArrayDataPointerConstant pvOff32 = AMD64LIRHelper.pointerConstant(16, new int[]{-2010377990, 1066820852, 0x55555555, -1076538027});
    private static ArrayDataPointerConstant t2NegF = AMD64LIRHelper.pointerConstant(16, new int[]{0, 0x3FF00000, 0, 0, 1797923801, 1072687577, 1950547427, 1013229059, 730821105, 1072681922, -1771734553, 1012067188, 915592468, 1072676282, 352947894, -1133942925, -2120314664, 1072670657, -207252706, 1014450259, 35929225, 1072665048, -1485179255, -1135530328, -1382236652, 1072659453, -804899574, -1131562222, 2038973688, 1072653874, 892941374, 1016046459, 1533953344, 1072648310, 769171851, 1015665633, 1222472308, 1072642761, 1054357470, -1133946278, 929806999, 1072637227, -1089630653, 1015259557, 481706282, 1072631708, 1696079173, -1132256768, -295609817, 1072626203, -2036025680, 1015924724, -1575451376, 1072620714, -1534634355, 1015137933, 764307441, 1072615240, -1273909876, -1131637773, -2038642066, 1072609780, 580117746, 1015317295, -1566273318, 1072604335, 396109971, -1131504605, 2009970496, 1072598905, -2135927631, -1132394348, -70824829, 1072593489, -905146910, 1015207202, 610758006, 1072588089, 1965209397, -1133101064, -410304522, 1072582702, -2136355697, 1014210185, 991358482, 1072577331, 838715019, -1131809628, 351641897, 1072571974, -2122705770, -1131956697, 1796832535, 1072566631, -1118011580, -1134381783, 863738719, 1072561303, 1326992220, -1132354099, 1679558232, 1072555989, -1904625009, -1131633326, -217992096, 1072550689, 2029000899, 1015208535, -700808427, 1072545404, -1838445596, -1131710735, 64696965, 1072540134, 1768797490, 1015816960, 1912561781, 1072534877, -1147472194, 1015678253, 382305176, 1072529635, -1947344920, -1132388671, -396171565, 1072524406, 1249994144, 1011869818, -587488121, 1072519192, -681887993, 1014164738, -355819050, 1072513992, -1084615148, 1015274323, 135105010, 1072508807, 1906148728, -1131591557, 721996136, 1072503635, 563754734, 1015371318, 1242007932, 1072498477, 1132034716, -1131627465, 1532734324, 1072493333, -1200750761, -1131804439, 1432208378, 1072488203, 1401068914, -1132603333, 778901109, 1072483087, -2046783341, -1133698545, -588279703, 1072477984, -773240356, 1013253067, 1464976603, 1072472896, -787674891, -1132989762, -1811486795, 1072467821, 1216371780, 1013034172, -1987524301, 1072462760, -1104849575, -1132562757, 777507147, 1072457713, -12043091, 1015187533, 2029714210, 1072452679, 613660079, 1015099143, 1610600570, 1072447659, -528234998, 1015760183, -637901524, 1072442652, 399025623, -1132010218, -578465124, 1072437659, -1991227171, 1014042725, 1631695677, 1072432680, -1577334220, -1132623270, 1540824585, 1072427714, 1064017011, -1131479606, -1007443449, 1072422761, 1625971539, -1137957341, -1874083374, 1072417822, 2049810052, 1014119888, -1214615777, 1072412896, -915840508, -1137749295, 815859274, 1072407984, 240396590, -1131479853, -232306204, 1072403084, 1422616006, -1131711978, -218407353, 1072398198, 2119478331, -1134208945, 703710506, 1072393326, 1384660846, 1015195891, -1914349254, 1072388466, -1145410077, -1131646497, 364333489, 1072383620, -371229552, -1133545923, -1202776581, 1072378786, 814012168, -1135443874, 1822067026, 1072373966, 1241994956, 1015340290, 697153126, 1072369159, 1283515429, -1131684107, -433917185, 1072364364, 254893773, -1132154116, -1722100819, 1072359583, 878562433, 1015521741, 977020788, 1072354815, -1229866779, 1015541563, -1076628614, 1072350059, -890802992, -1132490188, 557149882, 1072345317, -622246587, 1014537265, 1434058175, 1072340587, 251133233, 1015085769, 1405169241, 1072335870, -1296427607, -1132136345, 321958744, 1072331166, -893033529, 1015794558, -1963696046, 1072326474, 812057446, 1012207446, -1304550051, 1072321795, -611499551, -1131597970, -2142893352, 1072317129, 1486860576, -1131763840, -330683085, 1072312475, 2111583915, 1015427164, -309413701, 1072307834, -292821234, 1015834136, 2069751141, 1072303206, 1562170675, -1132242615, -1928858978, 1072298590, -1426982194, -1133205042, 434316067, 1072293987, 2028358766, 1013458122, 424392917, 1072289396, -1545764301, -1132128578, -2103185264, 1072284817, -1334709570, 1013742662, 1297350157, 1072280251, 1308022040, -1131554738, 1892288442, 1072275697, -1848711630, -1132366915, -461757790, 1072271155, -1572046612, 1013754842, -1612820912, 1072266626, 2082178513, -1131603877, -1703513933, 1072262109, 2132396182, -1135893098, -876064241, 1072257604, -1767509959, -1134146692, 727685349, 1072253112, 2038246809, -1132608554, -1328691739, 1072248631, -2118811972, -1135124537, 1403662306, 1072244163, -1506157697, -1133296289, 194117574, 1072239707, 777528612, -1131555207, -802673526, 1072235262, -2046935086, 1015386826, -1726646474, 1072230830, -1562142868, 1014352915, 1577608921, 1072226410, 1875489510, -1131998902, 380978316, 1072222002, 854188970, -1134504610, -1160374408, 1072217605, -62700434, 1015991134, 1110089947, 1072213221, 1451641639, 1015474673, -1535617009, 1072208848, 1148526634, 1015894933, -645241191, 1072204487, -209930950, 1015649474, -651058122, 1072200138, -757381187, 1014354647, -1690004755, 1072195801, -1680542022, -1131428104, 396319521, 1072191476, -122546480, -1135892664, 1176749997, 1072187162, -1555968517, -1132931452, 515457527, 1072182860, 836709333, 1015651226, -1723019757, 1072178569, -736808232, -1131590627, -1378810151, 1072174290, 219487565, 1015309367, 1413356050, 1072170023, 1651349291, -1132299130, -2070821743, 1072165767, -812445266, -1133478127, 919555682, 1072161523, -1172997762, 1012948226, 1660913392, 1072157290, -76367692, 1015135707, 19972402, 1072153069, -787067434, 1016009292, 158781403, 1072148859, -2073502584, -1131680843, 1944781191, 1072144660, -301688529, -1133243017, 950803702, 1072140473, 1655364926, 1015237032, 1339972927, 1072136297, 167908909, 1015572152, -1314165239, 1072132132, 378619896, 1015773303, 1447192521, 1072127979, 1462857171, -1132452775, 903334909, 1072123837, 1636462108, 1015039997, 1218806132, 1072119706, 1818613052, -1132418855, -2031431542, 1072115586, 752233586, -1132328288, -387162252, 1072111477, -2037876071, -1133416889, 1727278727, 1072107380, -732256673, 1011471940, -112094076, 1072103293, 629542646, -1132970993, -1738982683, 1072099218, -1642411854, -1132414604, 1013258799, 1072095154, 1748797611, -1134838214, -573278651, 1072091100, -1225690359, 1015839401, 1963711167, 1072087058, 1744767757, -1134393002, -92989634, 1072083026, 748330254, 1013594357, 1719614413, 1072079006, 330458198, -1131684556, -1315007176, 1072074996, -1695857571, 1014498493, -733173389, 1072070997, 1157054053, 1011890350, -955763722, 1072067009, 1483497780, -1132558542, -2108349915, 1072063032, -2024203212, -1131694583, -21196873, 1072059065, -911786487, -1131748395, 885834528, 1072055110, 1973258547, -1132705732, 488188413, 1072051165, -1095146267, 1015564048, -1338354299, 1072047230, 2118169751, -1132231743, -422709516, 1072043306, 1253592103, 1015958334, -1183392759, 1072039393, -1688805817, -1132207550, 551349105, 1072035491, -473051246, -1132860707, 363667784, 1072031599, 813753950, 1015785209, -1868985453, 1072027717, -1464576445, -1131620697, -1973860681, 1072023846, -2123790686, 1009535771, -72844797, 1072019985, 1277378074, -1131710559, -582462423, 1072016135, 88491949, 1015427660, 671025100, 1072012296, -462952945, -1131945266, -728250371, 1072008466, 1536826856, 1014142433, -605895473, 1072004647, -1973962300, -1132414580, 917841882, 1072000839, 18715565, 1015659308, -571928366, 1071997040, 378465264, -1132397714, -899837425, 1071993252, -269621861, -1132631908, -185160409, 1071989474, 422403966, 1014469229, 1453150082, 1071985707, 498154669, -1133479234, -398504209, 1071981949, 1139797873, -1133733491, -1563466174, 1071978202, 1774031855, -1132497275, 2135241198, 1071974465, 1236747871, 1013589147, 1990012071, 1071970738, -765896733, -1132154103, -2116506625, 1071967021, 777878098, -1132124803, -1711416051, 1071963314, -1133873101, 1015606491, -1206402796, 1071959617, 1762311517, 1015045673, -717870553, 1071955930, -1343470878, 1013793687, -361908265, 1071952253, 2133366768, -1133435464, -254290978, 1071948586, -204358058, 1015663458, -510480686, 1071944929, 1581883040, -1133268343, -1245627184, 1071941282, -1232051472, 1013170595, 1720398391, 1071937645, -314288333, -1131667216, -316866473, 1071934017, -781940106, 1015845963, 1118294578, 1071930400, -2097471602, -1135057895, 1617004845, 1071926792, 82804944, 1010342778, 1065662932, 1071923194, -1761296381, 1014530238, -649025385, 1071919605, -480282215, -1133393955, 654919306, 1071916027, -1062005539, -1131919827, 569847338, 1071912458, 472945272, -1135676567, -1016618972, 1071908898, -1225469880, 1014750712, 78413852, 1071905349, -111740429, -1131950045, -551792267, 1071901808, 2072812490, -1132792221, 1276261410, 1071898278, 300981948, 1014684169, 1156440435, 1071894757, -1943516047, 1013967056, -1022121755, 1071891245, 928852419, -1131479048, -1075024652, 1071887743, -495976680, 1015368806, 887463927, 1071884251, -698223133, -1134173130, 460407023, 1071880768, -57792204, -1131828827, 1829099622, 1071877294, 1016661181, -1131506291, 589198666, 1071873830, -1630621124, -1131809334, 926591435, 1071870375, -1086133534, -1132053782, -1562474437, 1071866929, -1603487650, -1132711612, 1603444721, 1071863493, 1548633640, -1132765970, 1726216749, 1071860066, -1828159068, -1133290891, -1302063361, 1071856648, -2076812890, 1015228193, 1000925746, 1071853240, 1018491672, -1131657752, -62072783, 1071849840, -1911028612, 1014668519, -303123715, 1071846450, -202113839, 1014585763, 171030293, 1071843070, -768507164, 1014428778, 1253935211, 1071839698, 1395382931, -1135264683, -1455542442, 1071836335, 1171596163, 1013041679, 526652809, 1071832982, -71507560, 1015879375, -1495006453, 1071829637, 1423655381, 1015022151, 964107055, 1071826302, -1494527708, -1132134075, -790963824, 1071822975, -700966236, -1137636644, 1724976915, 1071819658, 420909223, -1131849917, -182460703, 1071816349, -1347612075, 1014371048, 1972484976, 1071813050, 675290301, -1133327246, -504011903, 1071809759, -1942024834, -1131787206, 874372905, 1071806478, 100263788, 1015940732, 1709341917, 1071803205, -1723799079, 1014152499, 1897844341, 1071799941, 1254300460, 1015275938, 1337108031, 1071796686, -1091242844, 1014677845, -75361270, 1071793439, -1860392554, 1014681548, 1853186616, 1071790202, -1228470925, 1015656574, -1569123631, 1071786973, 1433917087, 1014838523, -1854022506, 1071783753, -1802197522, 1014147454, 897099801, 1071780542, 754756297, 1015241005, -2006807338, 1071777339, -2125822827, 1014876021, -2076651955, 1071774145, -1600671908, -1131678428, 586995997, 1071770960, 41662348, -1132339304, 1588871207, 1071767783, 143439582, -1132003880, 828946858, 1071764615, 10642492, 1015939438, -1792533397, 1071761455, -2146371383, 1015023991, -2080088876, 1071758304, 892270087, -1131850874, -132937188, 1071755161, -1531538816, 1015529349, -344994955, 1071752027, 2068408548, 1014913868, 1480023343, 1071748902, -2047771128, 1015327453, 948735466, 1071745785, -778629268, -1132392413, -2037007424, 1071742676, -492021148, 1012964927, 1014845819, 1071739576, -1177056650, -1133408191, 1416741826, 1071736484, -2098587086, 1011413563, -928674223, 1071733400, -1175540982, 1014120554, -1823526610, 1071730325, 968836267, -1132752408, -1364644384, 1071727258, -1695467874, -1132253249, 351405227, 1071724200, -1169629968, -1135144817, -1066651188, 1071721149, -1284725305, -1136544492, -1419892042, 1071718107, -150733966, -1131633580, -804103343, 1071715073, 960797498, -1132018416, 685187902, 1071712048, 378731989, 1014843115, -1342254309, 1071709030, -1001472645, -1134846995, 1608493509, 1071706021, -1135345125, -1132159559, 852742562, 1071703020, 667253586, 1009793559, 590962156, 1071700027, -465620630, -1131691699, 728909815, 1071697042, 383930225, 1015029468, 1172597893, 1071694065, 114433263, 1015347593, 1828292879, 1071691096, 1255956747, 1015588398, -1692452583, 1071688135, -2026037960, 1014354284, -892931197, 1071685182, 405889334, 1015105656, -161085472, 1071682237, -2146811951, -1132035997, 410360776, 1071679301, 1269990655, 1011975870, 728934454, 1071676372, 1413842688, 1014178612, 702412510, 1071673451, -491701209, -1132686881, 238821257, 1071670538, 1469694871, -1132082309, -753564300, 1071667632, -1535789979, 1014854626, 1928746161, 1071664735, 983617676, 1014285177, -395411579, 1071661845, 427280750, -1132420324, 772914124, 1071658964, -290594534, 1012230161, 1048019041, 1071656090, 1398474845, -1134456701, 339411585, 1071653224, 264588982, -1133330639, -1443155147, 1071650365, -1699164745, 1015767337, -94716737, 1071647514, -1486839951, -1133185358});

    public AMD64MathTanhOp() {
        super(TYPE, AMD64.r8, AMD64.rax, AMD64.rcx, AMD64.rdx, AMD64.xmm0, AMD64.xmm1, AMD64.xmm2, AMD64.xmm3, AMD64.xmm4, AMD64.xmm5, AMD64.xmm6, AMD64.xmm7);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Label l2TAGPACKET001 = new Label();
        Label l2TAGPACKET101 = new Label();
        Label l2TAGPACKET201 = new Label();
        Label l2TAGPACKET301 = new Label();
        Label l2TAGPACKET401 = new Label();
        Label l2TAGPACKET501 = new Label();
        Label lB12 = new Label();
        Label lB14 = new Label();
        masm.bind(lB12);
        masm.movsd(AMD64.xmm3, AMD64LIRHelper.recordExternalAddress(crb, halfMask));
        masm.xorpd(AMD64.xmm4, AMD64.xmm4);
        masm.movsd(AMD64.xmm1, AMD64LIRHelper.recordExternalAddress(crb, l2e));
        masm.movsd(AMD64.xmm2, AMD64LIRHelper.recordExternalAddress(crb, l2eOff8));
        masm.movl(AMD64.rax, 32768);
        masm.pinsrw(AMD64.xmm4, AMD64.rax, 3);
        masm.movsd(AMD64.xmm6, AMD64LIRHelper.recordExternalAddress(crb, shifter));
        masm.pextrw(AMD64.rcx, AMD64.xmm0, 3);
        masm.andpd(AMD64.xmm3, AMD64.xmm0);
        masm.andnpd(AMD64.xmm4, AMD64.xmm0);
        masm.pshufd(AMD64.xmm5, AMD64.xmm4, 68);
        masm.movl(AMD64.rdx, 32768);
        masm.andl(AMD64.rdx, AMD64.rcx);
        masm.andl(AMD64.rcx, Short.MAX_VALUE);
        masm.subl(AMD64.rcx, 16304);
        masm.cmpl(AMD64.rcx, 144);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, l2TAGPACKET001);
        masm.subsd(AMD64.xmm4, AMD64.xmm3);
        masm.mulsd(AMD64.xmm3, AMD64.xmm1);
        masm.mulsd(AMD64.xmm2, AMD64.xmm5);
        masm.cvtsd2siq(AMD64.rax, AMD64.xmm3);
        masm.movq(AMD64.xmm7, AMD64.xmm3);
        masm.addsd(AMD64.xmm3, AMD64.xmm6);
        masm.mulsd(AMD64.xmm1, AMD64.xmm4);
        masm.movsd(AMD64.xmm4, AMD64LIRHelper.recordExternalAddress(crb, oneMask));
        masm.subsd(AMD64.xmm3, AMD64.xmm6);
        masm.xorpd(AMD64.xmm0, AMD64.xmm0);
        masm.addsd(AMD64.xmm2, AMD64.xmm1);
        masm.subsd(AMD64.xmm7, AMD64.xmm3);
        masm.movdqu(AMD64.xmm6, AMD64LIRHelper.recordExternalAddress(crb, cv));
        masm.addsd(AMD64.xmm2, AMD64.xmm7);
        masm.movl(AMD64.rcx, 255);
        masm.andl(AMD64.rcx, AMD64.rax);
        masm.addl(AMD64.rcx, AMD64.rcx);
        masm.leaq(AMD64.r8, AMD64LIRHelper.recordExternalAddress(crb, t2NegF));
        masm.movdqu(AMD64.xmm5, new AMD64Address(AMD64.r8, AMD64.rcx, Stride.S8));
        masm.shrl(AMD64.rax, 4);
        masm.andl(AMD64.rax, 65520);
        masm.subl(AMD64.rax, 16368);
        masm.negl(AMD64.rax);
        masm.pinsrw(AMD64.xmm0, AMD64.rax, 3);
        masm.movdqu(AMD64.xmm1, AMD64LIRHelper.recordExternalAddress(crb, cvOff16));
        masm.pshufd(AMD64.xmm0, AMD64.xmm0, 68);
        masm.mulpd(AMD64.xmm0, AMD64.xmm5);
        masm.movsd(AMD64.xmm7, AMD64LIRHelper.recordExternalAddress(crb, cvOff32));
        masm.pshufd(AMD64.xmm2, AMD64.xmm2, 68);
        masm.movq(AMD64.xmm5, AMD64.xmm4);
        masm.addsd(AMD64.xmm4, AMD64.xmm0);
        masm.mulpd(AMD64.xmm6, AMD64.xmm2);
        masm.mulsd(AMD64.xmm7, AMD64.xmm2);
        masm.mulpd(AMD64.xmm2, AMD64.xmm2);
        masm.addpd(AMD64.xmm1, AMD64.xmm6);
        masm.mulsd(AMD64.xmm2, AMD64.xmm2);
        masm.movsd(AMD64.xmm3, AMD64LIRHelper.recordExternalAddress(crb, oneMask));
        masm.mulpd(AMD64.xmm1, AMD64.xmm2);
        masm.pshufd(AMD64.xmm6, AMD64.xmm1, 78);
        masm.addsd(AMD64.xmm1, AMD64.xmm6);
        masm.movq(AMD64.xmm6, AMD64.xmm1);
        masm.addsd(AMD64.xmm1, AMD64.xmm7);
        masm.mulsd(AMD64.xmm1, AMD64.xmm0);
        masm.addsd(AMD64.xmm1, AMD64.xmm4);
        masm.andpd(AMD64.xmm4, AMD64LIRHelper.recordExternalAddress(crb, threeMask));
        masm.divsd(AMD64.xmm5, AMD64.xmm1);
        masm.subsd(AMD64.xmm3, AMD64.xmm4);
        masm.pshufd(AMD64.xmm1, AMD64.xmm0, 238);
        masm.addsd(AMD64.xmm3, AMD64.xmm0);
        masm.movq(AMD64.xmm2, AMD64.xmm4);
        masm.addsd(AMD64.xmm3, AMD64.xmm1);
        masm.mulsd(AMD64.xmm1, AMD64.xmm7);
        masm.mulsd(AMD64.xmm7, AMD64.xmm0);
        masm.addsd(AMD64.xmm3, AMD64.xmm1);
        masm.addsd(AMD64.xmm4, AMD64.xmm7);
        masm.movsd(AMD64.xmm1, AMD64LIRHelper.recordExternalAddress(crb, rMask));
        masm.mulsd(AMD64.xmm6, AMD64.xmm0);
        masm.andpd(AMD64.xmm4, AMD64LIRHelper.recordExternalAddress(crb, threeMask));
        masm.addsd(AMD64.xmm3, AMD64.xmm6);
        masm.movq(AMD64.xmm6, AMD64.xmm4);
        masm.subsd(AMD64.xmm2, AMD64.xmm4);
        masm.addsd(AMD64.xmm2, AMD64.xmm7);
        masm.movsd(AMD64.xmm7, AMD64LIRHelper.recordExternalAddress(crb, oneMask));
        masm.andpd(AMD64.xmm5, AMD64.xmm1);
        masm.addsd(AMD64.xmm3, AMD64.xmm2);
        masm.mulsd(AMD64.xmm4, AMD64.xmm5);
        masm.xorpd(AMD64.xmm2, AMD64.xmm2);
        masm.mulsd(AMD64.xmm3, AMD64.xmm5);
        masm.subsd(AMD64.xmm6, AMD64LIRHelper.recordExternalAddress(crb, twoMask));
        masm.subsd(AMD64.xmm4, AMD64.xmm7);
        masm.xorl(AMD64.rdx, 32768);
        masm.pinsrw(AMD64.xmm2, AMD64.rdx, 3);
        masm.addsd(AMD64.xmm4, AMD64.xmm3);
        masm.mulsd(AMD64.xmm6, AMD64.xmm5);
        masm.movq(AMD64.xmm1, AMD64.xmm3);
        masm.mulsd(AMD64.xmm3, AMD64.xmm4);
        masm.movq(AMD64.xmm0, AMD64.xmm6);
        masm.mulsd(AMD64.xmm6, AMD64.xmm4);
        masm.subsd(AMD64.xmm1, AMD64.xmm3);
        masm.subsd(AMD64.xmm1, AMD64.xmm6);
        masm.addsd(AMD64.xmm0, AMD64.xmm1);
        masm.xorpd(AMD64.xmm0, AMD64.xmm2);
        masm.jmp(lB14);
        masm.bind(l2TAGPACKET001);
        masm.addl(AMD64.rcx, 960);
        masm.cmpl(AMD64.rcx, 1104);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, l2TAGPACKET101);
        masm.movdqu(AMD64.xmm2, AMD64LIRHelper.recordExternalAddress(crb, pv));
        masm.pshufd(AMD64.xmm1, AMD64.xmm0, 68);
        masm.movdqu(AMD64.xmm3, AMD64LIRHelper.recordExternalAddress(crb, pvOff16));
        masm.mulpd(AMD64.xmm1, AMD64.xmm1);
        masm.movdqu(AMD64.xmm4, AMD64LIRHelper.recordExternalAddress(crb, pvOff32));
        masm.mulpd(AMD64.xmm2, AMD64.xmm1);
        masm.pshufd(AMD64.xmm5, AMD64.xmm1, 68);
        masm.addpd(AMD64.xmm2, AMD64.xmm3);
        masm.mulsd(AMD64.xmm5, AMD64.xmm5);
        masm.mulpd(AMD64.xmm2, AMD64.xmm1);
        masm.mulsd(AMD64.xmm5, AMD64.xmm5);
        masm.addpd(AMD64.xmm2, AMD64.xmm4);
        masm.mulpd(AMD64.xmm2, AMD64.xmm5);
        masm.pshufd(AMD64.xmm5, AMD64.xmm2, 238);
        masm.addsd(AMD64.xmm2, AMD64.xmm5);
        masm.mulsd(AMD64.xmm2, AMD64.xmm0);
        masm.addsd(AMD64.xmm0, AMD64.xmm2);
        masm.jmp(lB14);
        masm.bind(l2TAGPACKET101);
        masm.addl(AMD64.rcx, 15344);
        masm.cmpl(AMD64.rcx, 16448);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, l2TAGPACKET201);
        masm.cmpl(AMD64.rcx, 16);
        masm.jcc(AMD64Assembler.ConditionFlag.Below, l2TAGPACKET301);
        masm.xorpd(AMD64.xmm2, AMD64.xmm2);
        masm.movl(AMD64.rax, 17392);
        masm.pinsrw(AMD64.xmm2, AMD64.rax, 3);
        masm.mulsd(AMD64.xmm2, AMD64.xmm0);
        masm.addsd(AMD64.xmm2, AMD64.xmm0);
        masm.jmp(lB14);
        masm.bind(l2TAGPACKET301);
        masm.movq(AMD64.xmm2, AMD64.xmm0);
        masm.mulsd(AMD64.xmm2, AMD64.xmm2);
        masm.jmp(lB14);
        masm.bind(l2TAGPACKET201);
        masm.cmpl(AMD64.rcx, 32752);
        masm.jcc(AMD64Assembler.ConditionFlag.AboveEqual, l2TAGPACKET401);
        masm.xorpd(AMD64.xmm2, AMD64.xmm2);
        masm.movl(AMD64.rcx, 15344);
        masm.pinsrw(AMD64.xmm2, AMD64.rcx, 3);
        masm.movq(AMD64.xmm3, AMD64.xmm2);
        masm.mulsd(AMD64.xmm2, AMD64.xmm2);
        masm.addsd(AMD64.xmm2, AMD64.xmm3);
        masm.bind(l2TAGPACKET501);
        masm.xorpd(AMD64.xmm0, AMD64.xmm0);
        masm.orl(AMD64.rdx, 16368);
        masm.pinsrw(AMD64.xmm0, AMD64.rdx, 3);
        masm.jmp(lB14);
        masm.bind(l2TAGPACKET401);
        masm.movq(AMD64.xmm2, AMD64.xmm0);
        masm.movdl(AMD64.rax, AMD64.xmm0);
        masm.psrlq(AMD64.xmm2, 20);
        masm.movdl(AMD64.rcx, AMD64.xmm2);
        masm.orl(AMD64.rcx, AMD64.rax);
        masm.cmpl(AMD64.rcx, 0);
        masm.jcc(AMD64Assembler.ConditionFlag.Equal, l2TAGPACKET501);
        masm.addsd(AMD64.xmm0, AMD64.xmm0);
        masm.bind(lB14);
    }
}

