/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

public final class AMD64BitCountOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64BitCountOp> TYPE = LIRInstructionClass.create(AMD64BitCountOp.class);
    @LIRInstruction.Def
    protected Value dstValue;
    @LIRInstruction.Alive
    protected Value srcValue;
    @LIRInstruction.Temp
    protected Value rtmpValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value rtmp1Value;

    public AMD64BitCountOp(LIRGeneratorTool tool, Value dstValue, Value srcValue) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.dstValue = dstValue;
        this.srcValue = srcValue;
        this.rtmpValue = tool.newVariable(srcValue.getValueKind());
        this.rtmp1Value = srcValue.getPlatformKind() == AMD64Kind.DWORD ? Value.ILLEGAL : tool.newVariable(srcValue.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register dst = ValueUtil.asRegister((Value)this.dstValue);
        Register src = ValueUtil.asRegister((Value)this.srcValue);
        Register rtmp = ValueUtil.asRegister((Value)this.rtmpValue);
        switch ((AMD64Kind)this.srcValue.getPlatformKind()) {
            case DWORD: {
                masm.movl(dst, src);
                masm.movl(rtmp, src);
                masm.shrl(rtmp, 1);
                masm.andl(rtmp, 0x55555555);
                masm.subl(dst, rtmp);
                masm.movl(rtmp, dst);
                masm.andl(rtmp, 0x33333333);
                masm.shrl(dst, 2);
                masm.andl(dst, 0x33333333);
                masm.addl(rtmp, dst);
                masm.movl(dst, rtmp);
                masm.shrl(dst, 4);
                masm.addl(dst, rtmp);
                masm.andl(dst, 0xF0F0F0F);
                masm.movl(rtmp, dst);
                masm.shrl(rtmp, 8);
                masm.addl(rtmp, dst);
                masm.movl(dst, rtmp);
                masm.shrl(dst, 16);
                masm.addl(dst, rtmp);
                masm.andl(dst, 63);
                break;
            }
            default: {
                Register longImm = ValueUtil.asRegister((Value)this.rtmp1Value);
                masm.movq(dst, src);
                masm.movq(rtmp, src);
                masm.shrq(dst, 1);
                masm.movq(longImm, 0x5555555555555555L);
                masm.andq(dst, longImm);
                masm.subq(rtmp, dst);
                masm.movq(dst, rtmp);
                masm.movq(longImm, 0x3333333333333333L);
                masm.andq(dst, longImm);
                masm.shrq(rtmp, 2);
                masm.andq(rtmp, longImm);
                masm.addq(dst, rtmp);
                masm.movq(rtmp, dst);
                masm.shrq(rtmp, 4);
                masm.addq(rtmp, dst);
                masm.movq(longImm, 0xF0F0F0F0F0F0F0FL);
                masm.andq(rtmp, longImm);
                masm.movq(dst, rtmp);
                masm.shrq(dst, 8);
                masm.addq(dst, rtmp);
                masm.movq(rtmp, dst);
                masm.shrq(rtmp, 16);
                masm.addq(rtmp, dst);
                masm.movq(dst, rtmp);
                masm.shrq(dst, 32);
                masm.addq(dst, rtmp);
                masm.andl(dst, 127);
            }
        }
    }
}

