/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/79345bbbae2564f9f523859d1227a1784293b20f/src/hotspot/cpu/x86/stubGenerator_x86_64.cpp#L3269-L3321", sha1="2f3b577fa7f0ced9cc2514af80d2c2833ab7caf2"), @SyncPort(from="https://github.com/openjdk/jdk/blob/959fa4a1a35a1bb650ec5888efaf3d0fc8cfb025/src/hotspot/cpu/x86/macroAssembler_x86.cpp#L7780-L7814", sha1="e68b8c7bdb37d4bd1350c7e1219fdcb419d2618a"), @SyncPort(from="https://github.com/openjdk/jdk/blob/959fa4a1a35a1bb650ec5888efaf3d0fc8cfb025/src/hotspot/cpu/x86/macroAssembler_x86.cpp#L8032-L8209", sha1="d89ad721deb560178359f86e8c6c96ffc6530878")})
public final class AMD64BigIntegerMulAddOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64BigIntegerMulAddOp> TYPE = LIRInstructionClass.create(AMD64BigIntegerMulAddOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value outValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value inValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value offsetValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value kValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value tmp1Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] tmpValues;

    public AMD64BigIntegerMulAddOp(Value outValue, Value inValue, Value offsetValue, Value lenValue, Value kValue, Register heapBaseRegister) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        GraalError.guarantee(ValueUtil.asRegister((Value)outValue).equals((Object)AMD64.rdi), "expect outValue at rdi, but was %s", (Object)outValue);
        GraalError.guarantee(ValueUtil.asRegister((Value)inValue).equals((Object)AMD64.rsi), "expect inValue at rsi, but was %s", (Object)inValue);
        GraalError.guarantee(ValueUtil.asRegister((Value)offsetValue).equals((Object)AMD64.r11), "expect outValue at r11, but was %s", (Object)offsetValue);
        GraalError.guarantee(ValueUtil.asRegister((Value)lenValue).equals((Object)AMD64.rcx), "expect outValue at rcx, but was %s", (Object)lenValue);
        GraalError.guarantee(ValueUtil.asRegister((Value)kValue).equals((Object)AMD64.r8), "expect outValue at r8, but was %s", (Object)kValue);
        this.outValue = outValue;
        this.inValue = inValue;
        this.offsetValue = offsetValue;
        this.lenValue = lenValue;
        this.kValue = kValue;
        this.result = AMD64.rax.asValue(lenValue.getValueKind());
        this.tmp1Value = AMD64.r12.equals((Object)heapBaseRegister) ? AMD64.r14.asValue() : AMD64.r12.asValue();
        this.tmpValues = new Value[]{AMD64.rax.asValue(), AMD64.rcx.asValue(), AMD64.rdx.asValue(), AMD64.rbx.asValue(), AMD64.rsi.asValue(), AMD64.rdi.asValue(), AMD64.r8.asValue(), AMD64.r9.asValue(), AMD64.r10.asValue(), AMD64.r11.asValue(), AMD64.r13.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        GraalError.guarantee(this.outValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid outValue kind: %s", (Object)this.outValue);
        GraalError.guarantee(this.inValue.getPlatformKind().equals((Object)AMD64Kind.QWORD), "Invalid inValue kind: %s", (Object)this.inValue);
        GraalError.guarantee(this.offsetValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid offsetValue kind: %s", (Object)this.offsetValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.kValue.getPlatformKind().equals((Object)AMD64Kind.DWORD), "Invalid kValue kind: %s", (Object)this.kValue);
        Register out = ValueUtil.asRegister((Value)this.outValue);
        Register in = ValueUtil.asRegister((Value)this.inValue);
        Register offset = ValueUtil.asRegister((Value)this.offsetValue);
        Register len = ValueUtil.asRegister((Value)this.lenValue);
        Register k = ValueUtil.asRegister((Value)this.kValue);
        Register tmp1 = ValueUtil.asRegister((Value)this.tmp1Value);
        Register tmp2 = AMD64.r13;
        Register tmp3 = AMD64.r9;
        Register tmp4 = AMD64.r10;
        Register tmp5 = AMD64.rbx;
        AMD64BigIntegerMulAddOp.mulAdd(masm, out, in, offset, len, k, tmp1, tmp2, tmp3, tmp4, tmp5, AMD64.rdx, AMD64.rax);
    }

    static boolean useBMI2Instructions(AMD64MacroAssembler masm) {
        return masm.supports(AMD64.CPUFeature.BMI2) && masm.supports(AMD64.CPUFeature.AVX);
    }

    static void multiplyAdd64Bmi2(AMD64MacroAssembler masm, Register sum, Register op1, Register op2, Register carry, Register tmp2) {
        GraalError.guarantee(AMD64.rdx.equals((Object)op2), "expect op2 to be rdx, but was %s", (Object)op2);
        masm.mulxq(tmp2, op1, op1);
        masm.addq(sum, carry);
        masm.adcq(tmp2, 0);
        masm.addq(sum, op1);
        masm.adcq(tmp2, 0);
        masm.movq(carry, tmp2);
    }

    static void multiplyAdd64(AMD64MacroAssembler masm, Register sum, Register op1, Register op2, Register carry, Register rdxReg, Register raxReg) {
        masm.movq(raxReg, op2);
        masm.mulq(op1);
        masm.addq(sum, carry);
        masm.adcq(rdxReg, 0);
        masm.addq(sum, raxReg);
        masm.adcq(rdxReg, 0);
        masm.movq(carry, rdxReg);
    }

    static void mulAdd128X32Loop(AMD64MacroAssembler masm, Register out, Register in, Register offset, Register len, Register tmp1, Register tmp2, Register tmp3, Register tmp4, Register tmp5, Register rdxReg, Register raxReg) {
        Label lFirstLoop = new Label();
        Label lFirstLoopExit = new Label();
        masm.movl(tmp1, len);
        masm.shrl(tmp1, 2);
        masm.bind(lFirstLoop);
        masm.sublAndJcc(tmp1, 1, AMD64Assembler.ConditionFlag.Negative, lFirstLoopExit, true);
        masm.subl(len, 4);
        masm.subl(offset, 4);
        Register op2 = tmp2;
        Register sum = tmp3;
        Register op1 = tmp4;
        Register carry = tmp5;
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            op2 = rdxReg;
        }
        masm.movq(op1, new AMD64Address(in, len, Stride.S4, 8));
        masm.rorq(op1, 32);
        masm.movq(sum, new AMD64Address(out, offset, Stride.S4, 8));
        masm.rorq(sum, 32);
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            AMD64BigIntegerMulAddOp.multiplyAdd64Bmi2(masm, sum, op1, op2, carry, raxReg);
        } else {
            AMD64BigIntegerMulAddOp.multiplyAdd64(masm, sum, op1, op2, carry, rdxReg, raxReg);
        }
        masm.rorq(sum, 32);
        masm.movq(new AMD64Address(out, offset, Stride.S4, 8), sum);
        masm.movq(op1, new AMD64Address(in, len, Stride.S4, 0));
        masm.rorq(op1, 32);
        masm.movq(sum, new AMD64Address(out, offset, Stride.S4, 0));
        masm.rorq(sum, 32);
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            AMD64BigIntegerMulAddOp.multiplyAdd64Bmi2(masm, sum, op1, op2, carry, raxReg);
        } else {
            AMD64BigIntegerMulAddOp.multiplyAdd64(masm, sum, op1, op2, carry, rdxReg, raxReg);
        }
        masm.rorq(sum, 32);
        masm.movq(new AMD64Address(out, offset, Stride.S4, 0), sum);
        masm.jmp(lFirstLoop);
        masm.bind(lFirstLoopExit);
    }

    static void mulAdd(AMD64MacroAssembler masm, Register out, Register in, Register offs, Register len, Register k, Register tmp1, Register tmp2, Register tmp3, Register tmp4, Register tmp5, Register rdxReg, Register raxReg) {
        Label lCarry = new Label();
        Label lLastIn = new Label();
        Label lDone = new Label();
        Register op2 = tmp2;
        Register sum = tmp3;
        Register op1 = tmp4;
        Register carry = tmp5;
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            op2 = rdxReg;
            masm.movl(op2, k);
        } else {
            masm.movl(op2, k);
        }
        masm.xorq(carry, carry);
        AMD64BigIntegerMulAddOp.mulAdd128X32Loop(masm, out, in, offs, len, tmp1, tmp2, tmp3, tmp4, tmp5, rdxReg, raxReg);
        masm.declAndJcc(len, AMD64Assembler.ConditionFlag.Negative, lCarry, true);
        masm.declAndJcc(len, AMD64Assembler.ConditionFlag.Negative, lLastIn, true);
        masm.movq(op1, new AMD64Address(in, len, Stride.S4, 0));
        masm.rorq(op1, 32);
        masm.subl(offs, 2);
        masm.movq(sum, new AMD64Address(out, offs, Stride.S4, 0));
        masm.rorq(sum, 32);
        if (AMD64BigIntegerMulAddOp.useBMI2Instructions(masm)) {
            AMD64BigIntegerMulAddOp.multiplyAdd64Bmi2(masm, sum, op1, op2, carry, raxReg);
        } else {
            AMD64BigIntegerMulAddOp.multiplyAdd64(masm, sum, op1, op2, carry, rdxReg, raxReg);
        }
        masm.rorq(sum, 32);
        masm.movq(new AMD64Address(out, offs, Stride.S4, 0), sum);
        masm.testlAndJcc(len, len, AMD64Assembler.ConditionFlag.Zero, lCarry, true);
        masm.bind(lLastIn);
        masm.movl(op1, new AMD64Address(in, 0));
        masm.movl(sum, new AMD64Address(out, offs, Stride.S4, -4));
        masm.movl(raxReg, k);
        masm.mull(op1);
        masm.addl(sum, carry);
        masm.adcl(rdxReg, 0);
        masm.addl(sum, raxReg);
        masm.adcl(rdxReg, 0);
        masm.movl(carry, rdxReg);
        masm.movl(new AMD64Address(out, offs, Stride.S4, -4), sum);
        masm.bind(lCarry);
        masm.movl(AMD64.rax, carry);
        masm.bind(lDone);
    }
}

