/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc.lsra.ssa;

import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.alloc.lsra.LinearScan;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanEliminateSpillMovePhase;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanLifetimeAnalysisPhase;
import jdk.graal.compiler.lir.alloc.lsra.LinearScanResolveDataFlowPhase;
import jdk.graal.compiler.lir.alloc.lsra.MoveResolver;
import jdk.graal.compiler.lir.alloc.lsra.ssa.SSALinearScanEliminateSpillMovePhase;
import jdk.graal.compiler.lir.alloc.lsra.ssa.SSALinearScanLifetimeAnalysisPhase;
import jdk.graal.compiler.lir.alloc.lsra.ssa.SSALinearScanResolveDataFlowPhase;
import jdk.graal.compiler.lir.alloc.lsra.ssa.SSAMoveResolver;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.gen.MoveFactory;
import jdk.graal.compiler.lir.ssa.SSAUtil;
import jdk.vm.ci.code.TargetDescription;

public final class SSALinearScan
extends LinearScan {
    public SSALinearScan(TargetDescription target, LIRGenerationResult res, MoveFactory spillMoveFactory, RegisterAllocationConfig regAllocConfig, int[] sortedBlocks, boolean neverSpillConstants) {
        super(target, res, spillMoveFactory, regAllocConfig, sortedBlocks, neverSpillConstants);
    }

    @Override
    protected MoveResolver createMoveResolver() {
        SSAMoveResolver moveResolver = new SSAMoveResolver(this);
        assert (moveResolver.checkEmpty());
        return moveResolver;
    }

    @Override
    protected LinearScanLifetimeAnalysisPhase createLifetimeAnalysisPhase() {
        return new SSALinearScanLifetimeAnalysisPhase(this);
    }

    @Override
    protected LinearScanResolveDataFlowPhase createResolveDataFlowPhase() {
        return new SSALinearScanResolveDataFlowPhase(this);
    }

    @Override
    protected LinearScanEliminateSpillMovePhase createSpillMoveEliminationPhase() {
        return new SSALinearScanEliminateSpillMovePhase(this);
    }

    @Override
    protected void beforeSpillMoveElimination() {
        try (DebugContext.Scope s1 = this.debug.scope("Remove Phi In");){
            for (int blockId : this.sortedBlocks()) {
                BasicBlock<?> toBlock = this.getLIR().getBlockById(blockId);
                if (toBlock.getPredecessorCount() <= 1) continue;
                SSAUtil.removePhiIn(this.getLIR(), toBlock);
            }
        }
    }
}

