/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc.lsra;

import jdk.graal.compiler.lir.alloc.lsra.Interval;
import jdk.graal.compiler.lir.alloc.lsra.Range;
import jdk.graal.compiler.lir.debug.IntervalDumper;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

class LinearScanIntervalDumper
implements IntervalDumper {
    private final Interval[] intervals;

    LinearScanIntervalDumper(Interval[] intervals) {
        this.intervals = intervals;
    }

    @Override
    public void visitIntervals(IntervalDumper.IntervalVisitor visitor) {
        for (Interval interval : this.intervals) {
            if (interval == null) continue;
            LinearScanIntervalDumper.printInterval(interval, visitor);
        }
    }

    private static void printInterval(Interval interval, IntervalDumper.IntervalVisitor visitor) {
        AllocatableValue hint = interval.locationHint(false) != null ? interval.locationHint((boolean)false).operand : null;
        AllocatableValue operand = interval.operand;
        String type = ValueUtil.isRegister((Value)operand) ? "fixed" : operand.getValueKind().getPlatformKind().toString();
        visitor.visitIntervalStart((Value)interval.splitParent().operand, (Value)operand, (Value)interval.location(), (Value)hint, type);
        Range cur = interval.first();
        while (!cur.isEndMarker()) {
            visitor.visitRange(cur.from, cur.to);
            cur = cur.next;
            assert (cur != null) : "range list not closed with range sentinel";
        }
        int prev = -1;
        Interval.UsePosList usePosList = interval.usePosList();
        for (int i = usePosList.size() - 1; i >= 0; --i) {
            assert (prev < usePosList.usePos(i)) : "use positions not sorted";
            visitor.visitUsePos(usePosList.usePos(i), (Object)usePosList.registerPriority(i));
            prev = usePosList.usePos(i);
        }
        visitor.visitIntervalEnd((Object)interval.spillState());
    }
}

