/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.alloc;

import java.util.EnumSet;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.AllocationPhase;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Value;

public class AllocationStageVerifier
extends AllocationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.verifyLIR(lirGenRes.getLIR());
    }

    protected void verifyLIR(LIR lir) {
        for (BasicBlock block : lir.getControlFlowGraph().getBlocks()) {
            this.verifyBlock(lir, block);
        }
    }

    protected void verifyBlock(LIR lir, BasicBlock<?> block) {
        for (LIRInstruction inst : lir.getLIRforBlock(block)) {
            this.verifyInstruction(inst);
        }
    }

    protected void verifyInstruction(LIRInstruction inst) {
        inst.visitEachInput(this::verifyOperands);
        inst.visitEachOutput(this::verifyOperands);
        inst.visitEachAlive(this::verifyOperands);
        inst.visitEachTemp(this::verifyOperands);
    }

    protected void verifyOperands(LIRInstruction instruction, Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
        assert (!LIRValueUtil.isVirtualStackSlot(value) && !LIRValueUtil.isVariable(value)) : "Virtual values not allowed after allocation stage: " + String.valueOf(value);
    }
}

