/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import java.util.function.Consumer;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="SPIN_WAIT")
@SyncPort(from="https://github.com/openjdk/jdk/blob/96a0502d624e3eff1b00a7c63e8b3a27870b475e/src/hotspot/cpu/aarch64/vm_version_aarch64.cpp#L54-L70", sha1="92f81ed500658553a2ef2e7c48633094d95ba974")
public final class AArch64SpinWaitOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64SpinWaitOp> TYPE = LIRInstructionClass.create(AArch64SpinWaitOp.class);
    private final Consumer<AArch64MacroAssembler> instruction;
    private final int count;

    public AArch64SpinWaitOp(Consumer<AArch64MacroAssembler> instruction, int count) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.instruction = instruction;
        this.count = count;
        GraalError.guarantee(count > 0, "count should be positive");
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        for (int i = 0; i < this.count; ++i) {
            this.instruction.accept(masm);
        }
    }
}

