/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public enum AArch64PermuteOp {
    TBL,
    ZIPLOW,
    ZIPHIGH,
    ZIPEVEN,
    ZIPODD,
    UNZIPEVEN,
    UNZIPODD;


    public static class ASIMDBinaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDBinaryOp> TYPE = LIRInstructionClass.create(ASIMDBinaryOp.class);
        @Opcode
        private final AArch64PermuteOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;

        public ASIMDBinaryOp(AArch64PermuteOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register resultReg = ValueUtil.asRegister((Value)this.result);
            Register aReg = ValueUtil.asRegister((Value)this.a);
            Register bReg = ValueUtil.asRegister((Value)this.b);
            switch (this.op.ordinal()) {
                case 0: {
                    masm.neon.tblVVV(size, resultReg, aReg, bReg);
                    break;
                }
                case 1: {
                    masm.neon.zip1VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case 2: {
                    masm.neon.zip2VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case 3: {
                    masm.neon.trn1VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case 4: {
                    masm.neon.trn2VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case 5: {
                    masm.neon.uzp1VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                case 6: {
                    masm.neon.uzp2VVV(size, eSize, resultReg, aReg, bReg);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
                }
            }
        }
    }
}

