/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@Opcode(value="MATH_SIGNUM")
public final class AArch64MathSignumOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64MathSignumOp> TYPE = LIRInstructionClass.create(AArch64MathSignumOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value result;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value scratch;

    public AArch64MathSignumOp(LIRGeneratorTool tool, Value result, AllocatableValue input) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.input = input;
        this.scratch = tool.newVariable(LIRKind.value(input.getPlatformKind()));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register resultReg = ValueUtil.asRegister((Value)this.result);
        Register inputReg = ValueUtil.asRegister((Value)this.input);
        Register floatScratch = ValueUtil.asRegister((Value)this.scratch);
        int size = this.result.getPlatformKind().getSizeInBytes() * 8;
        masm.fmov(size, floatScratch, 0.0);
        masm.neon.facgtSSS(AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind()), resultReg, inputReg, floatScratch);
        masm.neon.ushrSSI(AArch64ASIMDAssembler.ElementSize.DoubleWord, resultReg, resultReg, 1);
        masm.fmov(size, floatScratch, 1.0);
        masm.neon.bslVVV(AArch64ASIMDAssembler.ASIMDSize.HalfReg, resultReg, floatScratch, inputReg);
    }
}

