/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@SyncPort(from="https://github.com/openjdk/jdk/blob/1d117f65f06456ae571aecc146542c2f79d402cf/src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp#L3394-L3628", sha1="bfad27e36c2940a087613608054bac43345a57e7")
public final class AArch64MD5Op
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64MD5Op> TYPE = LIRInstructionClass.create(AArch64MD5Op.class);
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value bufValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value stateValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value limitValue;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value resultValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value bufTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private Value ofsTempValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;
    private final boolean multiBlock;

    public AArch64MD5Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue) {
        this(tool, bufValue, stateValue, Value.ILLEGAL, Value.ILLEGAL, Value.ILLEGAL, false);
    }

    public AArch64MD5Op(LIRGeneratorTool tool, AllocatableValue bufValue, AllocatableValue stateValue, AllocatableValue ofsValue, AllocatableValue limitValue, AllocatableValue resultValue, boolean multiBlock) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.bufValue = bufValue;
        this.stateValue = stateValue;
        this.ofsValue = ofsValue;
        this.limitValue = limitValue;
        this.resultValue = resultValue;
        this.multiBlock = multiBlock;
        if (multiBlock) {
            this.bufTempValue = tool.newVariable(bufValue.getValueKind());
            this.ofsTempValue = tool.newVariable(ofsValue.getValueKind());
        } else {
            this.bufTempValue = Value.ILLEGAL;
            this.ofsTempValue = Value.ILLEGAL;
        }
        this.temps = new Value[]{AArch64.r4.asValue(), AArch64.r5.asValue(), AArch64.r6.asValue(), AArch64.r7.asValue(), AArch64.r10.asValue(), AArch64.r11.asValue(), AArch64.r12.asValue(), AArch64.r13.asValue(), AArch64.r14.asValue(), AArch64.r15.asValue(), AArch64.r16.asValue(), AArch64.r17.asValue(), AArch64.r19.asValue(), AArch64.r20.asValue(), AArch64.r21.asValue(), AArch64.r22.asValue()};
    }

    private static void regCacheExtractU32(AArch64MacroAssembler masm, Register[] regCache, Register dest, int i) {
        masm.ubfx(64, dest, regCache[i / 2], 32 * (i % 2), 32);
    }

    private static void md5FF(AArch64MacroAssembler masm, Register[] regCache, Register reg1, Register reg2, Register reg3, Register reg4, int k, int s, int t, Register rscratch1, Register rscratch2, Register rscratch3, Register rscratch4) {
        masm.eor(32, rscratch3, reg3, reg4);
        masm.mov(rscratch2, t);
        masm.and(32, rscratch3, rscratch3, reg2);
        masm.add(32, rscratch4, reg1, rscratch2);
        AArch64MD5Op.regCacheExtractU32(masm, regCache, rscratch1, k);
        masm.ubfx(64, rscratch1, regCache[k / 2], 32 * (k % 2), 32);
        masm.eor(32, rscratch3, rscratch3, reg4);
        masm.add(32, rscratch4, rscratch4, rscratch1);
        masm.add(32, rscratch3, rscratch3, rscratch4);
        masm.ror(32, rscratch2, rscratch3, 32 - s);
        masm.add(32, reg1, rscratch2, reg2);
    }

    private static void md5GG(AArch64MacroAssembler masm, Register[] regCache, Register reg1, Register reg2, Register reg3, Register reg4, int k, int s, int t, Register rscratch1, Register rscratch2, Register rscratch3, Register rscratch4) {
        AArch64MD5Op.regCacheExtractU32(masm, regCache, rscratch1, k);
        masm.mov(rscratch2, t);
        masm.add(32, rscratch4, reg1, rscratch2);
        masm.add(32, rscratch4, rscratch4, rscratch1);
        masm.bic(32, rscratch2, reg3, reg4);
        masm.and(32, rscratch3, reg2, reg4);
        masm.add(32, rscratch2, rscratch2, rscratch4);
        masm.add(32, rscratch2, rscratch2, rscratch3);
        masm.ror(32, rscratch2, rscratch2, 32 - s);
        masm.add(32, reg1, rscratch2, reg2);
    }

    private static void md5HH(AArch64MacroAssembler masm, Register[] regCache, Register reg1, Register reg2, Register reg3, Register reg4, int k, int s, int t, Register rscratch1, Register rscratch2, Register rscratch3, Register rscratch4) {
        masm.eor(32, rscratch3, reg3, reg4);
        masm.mov(rscratch2, t);
        masm.add(32, rscratch4, reg1, rscratch2);
        AArch64MD5Op.regCacheExtractU32(masm, regCache, rscratch1, k);
        masm.eor(32, rscratch3, rscratch3, reg2);
        masm.add(32, rscratch4, rscratch4, rscratch1);
        masm.add(32, rscratch3, rscratch3, rscratch4);
        masm.ror(32, rscratch2, rscratch3, 32 - s);
        masm.add(32, reg1, rscratch2, reg2);
    }

    private static void md5II(AArch64MacroAssembler masm, Register[] regCache, Register reg1, Register reg2, Register reg3, Register reg4, int k, int s, int t, Register rscratch1, Register rscratch2, Register rscratch3, Register rscratch4) {
        masm.mov(rscratch3, t);
        masm.orn(32, rscratch2, reg2, reg4);
        masm.add(32, rscratch4, reg1, rscratch3);
        AArch64MD5Op.regCacheExtractU32(masm, regCache, rscratch1, k);
        masm.eor(32, rscratch3, rscratch2, reg3);
        masm.add(32, rscratch4, rscratch4, rscratch1);
        masm.add(32, rscratch3, rscratch3, rscratch4);
        masm.ror(32, rscratch2, rscratch3, 32 - s);
        masm.add(32, reg1, rscratch2, reg2);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register limit;
        Register ofs;
        Register buf;
        GraalError.guarantee(this.bufValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid bufValue kind: %s", (Object)this.bufValue);
        GraalError.guarantee(this.stateValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid stateValue kind: %s", (Object)this.stateValue);
        Register state = ValueUtil.asRegister((Value)this.stateValue);
        if (this.multiBlock) {
            GraalError.guarantee(this.ofsValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid ofsValue kind: %s", (Object)this.ofsValue);
            GraalError.guarantee(this.limitValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid limitValue kind: %s", (Object)this.limitValue);
            buf = ValueUtil.asRegister((Value)this.bufTempValue);
            ofs = ValueUtil.asRegister((Value)this.ofsTempValue);
            limit = ValueUtil.asRegister((Value)this.limitValue);
            masm.mov(64, buf, ValueUtil.asRegister((Value)this.bufValue));
            masm.mov(32, ofs, ValueUtil.asRegister((Value)this.ofsValue));
        } else {
            buf = ValueUtil.asRegister((Value)this.bufValue);
            ofs = Register.None;
            limit = Register.None;
        }
        Register a = AArch64.r4;
        Register b = AArch64.r5;
        Register c = AArch64.r6;
        Register d = AArch64.r7;
        Register rscratch3 = AArch64.r10;
        Register rscratch4 = AArch64.r11;
        Register[] stateRegs = new Register[]{AArch64.r12, AArch64.r13};
        Register[] regCache = new Register[]{AArch64.r14, AArch64.r15, AArch64.r16, AArch64.r17, AArch64.r19, AArch64.r20, AArch64.r21, AArch64.r22};
        try (AArch64MacroAssembler.ScratchRegister scratchReg1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister scratchReg2 = masm.getScratchRegister();){
            Register rscratch1 = scratchReg1.getRegister();
            Register rscratch2 = scratchReg2.getRegister();
            masm.ldp(64, stateRegs[0], stateRegs[1], AArch64Address.createPairBaseRegisterOnlyAddress(64, state));
            masm.ubfx(64, a, stateRegs[0], 0, 32);
            masm.ubfx(64, b, stateRegs[0], 32, 32);
            masm.ubfx(64, c, stateRegs[1], 0, 32);
            masm.ubfx(64, d, stateRegs[1], 32, 32);
            Label labelMD5Loop = new Label();
            masm.bind(labelMD5Loop);
            for (int i = 0; i < 8; i += 2) {
                masm.ldp(64, regCache[i], regCache[i + 1], AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_PAIR_SIGNED_SCALED, buf, 8 * i));
            }
            AArch64MD5Op.md5FF(masm, regCache, a, b, c, d, 0, 7, -680876936, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, d, a, b, c, 1, 12, -389564586, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, c, d, a, b, 2, 17, 606105819, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, b, c, d, a, 3, 22, -1044525330, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, a, b, c, d, 4, 7, -176418897, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, d, a, b, c, 5, 12, 1200080426, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, c, d, a, b, 6, 17, -1473231341, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, b, c, d, a, 7, 22, -45705983, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, a, b, c, d, 8, 7, 1770035416, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, d, a, b, c, 9, 12, -1958414417, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, c, d, a, b, 10, 17, -42063, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, b, c, d, a, 11, 22, -1990404162, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, a, b, c, d, 12, 7, 1804603682, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, d, a, b, c, 13, 12, -40341101, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, c, d, a, b, 14, 17, -1502002290, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5FF(masm, regCache, b, c, d, a, 15, 22, 1236535329, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, a, b, c, d, 1, 5, -165796510, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, d, a, b, c, 6, 9, -1069501632, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, c, d, a, b, 11, 14, 643717713, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, b, c, d, a, 0, 20, -373897302, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, a, b, c, d, 5, 5, -701558691, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, d, a, b, c, 10, 9, 38016083, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, c, d, a, b, 15, 14, -660478335, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, b, c, d, a, 4, 20, -405537848, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, a, b, c, d, 9, 5, 568446438, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, d, a, b, c, 14, 9, -1019803690, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, c, d, a, b, 3, 14, -187363961, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, b, c, d, a, 8, 20, 1163531501, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, a, b, c, d, 13, 5, -1444681467, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, d, a, b, c, 2, 9, -51403784, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, c, d, a, b, 7, 14, 1735328473, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5GG(masm, regCache, b, c, d, a, 12, 20, -1926607734, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, a, b, c, d, 5, 4, -378558, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, d, a, b, c, 8, 11, -2022574463, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, c, d, a, b, 11, 16, 1839030562, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, b, c, d, a, 14, 23, -35309556, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, a, b, c, d, 1, 4, -1530992060, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, d, a, b, c, 4, 11, 1272893353, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, c, d, a, b, 7, 16, -155497632, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, b, c, d, a, 10, 23, -1094730640, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, a, b, c, d, 13, 4, 681279174, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, d, a, b, c, 0, 11, -358537222, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, c, d, a, b, 3, 16, -722521979, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, b, c, d, a, 6, 23, 76029189, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, a, b, c, d, 9, 4, -640364487, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, d, a, b, c, 12, 11, -421815835, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, c, d, a, b, 15, 16, 530742520, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5HH(masm, regCache, b, c, d, a, 2, 23, -995338651, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, a, b, c, d, 0, 6, -198630844, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, d, a, b, c, 7, 10, 1126891415, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, c, d, a, b, 14, 15, -1416354905, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, b, c, d, a, 5, 21, -57434055, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, a, b, c, d, 12, 6, 1700485571, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, d, a, b, c, 3, 10, -1894986606, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, c, d, a, b, 10, 15, -1051523, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, b, c, d, a, 1, 21, -2054922799, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, a, b, c, d, 8, 6, 1873313359, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, d, a, b, c, 15, 10, -30611744, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, c, d, a, b, 6, 15, -1560198380, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, b, c, d, a, 13, 21, 1309151649, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, a, b, c, d, 4, 6, -145523070, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, d, a, b, c, 11, 10, -1120210379, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, c, d, a, b, 2, 15, 718787259, rscratch1, rscratch2, rscratch3, rscratch4);
            AArch64MD5Op.md5II(masm, regCache, b, c, d, a, 9, 21, -343485551, rscratch1, rscratch2, rscratch3, rscratch4);
            masm.add(32, a, stateRegs[0], a);
            masm.ubfx(64, rscratch2, stateRegs[0], 32, 32);
            masm.add(32, b, rscratch2, b);
            masm.add(32, c, stateRegs[1], c);
            masm.ubfx(64, rscratch4, stateRegs[1], 32, 32);
            masm.add(32, d, rscratch4, d);
            masm.orr(64, stateRegs[0], a, b, AArch64Assembler.ShiftType.LSL, 32);
            masm.orr(64, stateRegs[1], c, d, AArch64Assembler.ShiftType.LSL, 32);
            if (this.multiBlock) {
                masm.add(64, buf, buf, 64);
                masm.add(32, ofs, ofs, 64);
                masm.cmp(32, ofs, limit);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.LE, labelMD5Loop);
                masm.mov(32, ValueUtil.asRegister((Value)this.resultValue), ofs);
            }
            masm.stp(64, stateRegs[0], stateRegs[1], AArch64Address.createPairBaseRegisterOnlyAddress(64, state));
        }
    }
}

