/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Address;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.lir.SyncPorts;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;

@SyncPorts(value={@SyncPort(from="https://github.com/openjdk/jdk/blob/1d117f65f06456ae571aecc146542c2f79d402cf/src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp#L4739-L4758", sha1="57f40186d75104a5e607d6fc047bbd50ef246590"), @SyncPort(from="https://github.com/openjdk/jdk/blob/79345bbbae2564f9f523859d1227a1784293b20f/src/hotspot/cpu/aarch64/macroAssembler_aarch64.cpp#L4235-L4271", sha1="33649be9177daf5f0b4817d807458a5ff8c00365")})
public final class AArch64BigIntegerMulAddOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64BigIntegerMulAddOp> TYPE = LIRInstructionClass.create(AArch64BigIntegerMulAddOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    private Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value outValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value inValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value offsetValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value lenValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value kValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value outValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value inValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value offsetValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value lenValueTemp;

    public AArch64BigIntegerMulAddOp(LIRGeneratorTool tool, Value outValue, Value inValue, Value offsetValue, Value lenValue, Value kValue, Value resultValue) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.outValue = outValue;
        this.inValue = inValue;
        this.offsetValue = offsetValue;
        this.lenValue = lenValue;
        this.kValue = kValue;
        this.resultValue = resultValue;
        this.outValueTemp = tool.newVariable(outValue.getValueKind());
        this.inValueTemp = tool.newVariable(inValue.getValueKind());
        this.offsetValueTemp = tool.newVariable(offsetValue.getValueKind());
        this.lenValueTemp = tool.newVariable(lenValue.getValueKind());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        GraalError.guarantee(this.outValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid outValue kind: %s", (Object)this.outValue);
        GraalError.guarantee(this.inValue.getPlatformKind().equals((Object)AArch64Kind.QWORD), "Invalid inValue kind: %s", (Object)this.inValue);
        GraalError.guarantee(this.offsetValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid offsetValue kind: %s", (Object)this.offsetValue);
        GraalError.guarantee(this.lenValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid lenValue kind: %s", (Object)this.lenValue);
        GraalError.guarantee(this.kValue.getPlatformKind().equals((Object)AArch64Kind.DWORD), "Invalid kValue kind: %s", (Object)this.kValue);
        Register out = ValueUtil.asRegister((Value)this.outValueTemp);
        Register in = ValueUtil.asRegister((Value)this.inValueTemp);
        Register offset = ValueUtil.asRegister((Value)this.offsetValueTemp);
        Register len = ValueUtil.asRegister((Value)this.lenValueTemp);
        Register k = ValueUtil.asRegister((Value)this.kValue);
        masm.mov(64, out, ValueUtil.asRegister((Value)this.outValue));
        masm.mov(64, in, ValueUtil.asRegister((Value)this.inValue));
        masm.mov(32, offset, ValueUtil.asRegister((Value)this.offsetValue));
        masm.mov(32, len, ValueUtil.asRegister((Value)this.lenValue));
        try (AArch64MacroAssembler.ScratchRegister sr1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sr2 = masm.getScratchRegister();){
            Register rscratch1 = sr1.getRegister();
            Register rscratch2 = sr2.getRegister();
            Label labelLoop = new Label();
            Label labelEnd = new Label();
            masm.cmp(64, len, AArch64.zr);
            masm.csel(64, out, AArch64.zr, out, AArch64Assembler.ConditionFlag.EQ);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelEnd);
            masm.add(64, in, in, len, AArch64Assembler.ShiftType.LSL, 2);
            masm.add(64, offset, out, offset, AArch64Assembler.ShiftType.LSL, 2);
            masm.mov(64, out, AArch64.zr);
            masm.bind(labelLoop);
            masm.ldr(32, rscratch1, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_PRE_INDEXED, in, -4));
            masm.madd(64, rscratch1, rscratch1, k, out);
            masm.ldr(32, rscratch2, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_PRE_INDEXED, offset, -4));
            masm.add(64, rscratch1, rscratch1, rscratch2);
            masm.str(32, rscratch1, AArch64Address.createBaseRegisterOnlyAddress(32, offset));
            masm.lsr(64, out, rscratch1, 32L);
            masm.subs(64, len, len, 1);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, labelLoop);
            masm.bind(labelEnd);
            masm.mov(32, ValueUtil.asRegister((Value)this.resultValue), out);
        }
    }
}

