/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import java.util.function.Consumer;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.LIRValueUtil;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRFlags;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGenerator;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AArch64AtomicMove {
    public static void moveSPAndEmitCode(AArch64MacroAssembler masm, Register input, Consumer<Register> codeGen) {
        if (input.equals((Object)AArch64.sp)) {
            try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
                Register newInput = scratch.getRegister();
                masm.mov(64, newInput, AArch64.sp);
                codeGen.accept(newInput);
            }
        } else {
            codeGen.accept(input);
        }
    }

    public static AArch64LIRInstruction createAtomicReadAndAdd(LIRGenerator gen, AArch64Kind kind, AllocatableValue result, AllocatableValue address, Value delta) {
        if (AArch64LIRFlags.useLSE((AArch64)gen.target().arch)) {
            return new AtomicReadAndAddLSEOp(kind, result, address, gen.asAllocatable(delta));
        }
        return new AtomicReadAndAddOp(kind, result, address, delta);
    }

    @Opcode(value="ATOMIC_READ_AND_ADD")
    public static final class AtomicReadAndAddLSEOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndAddLSEOp> TYPE = LIRInstructionClass.create(AtomicReadAndAddLSEOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue deltaValue;

        AtomicReadAndAddLSEOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, AllocatableValue delta) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.deltaValue = delta;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            AArch64AtomicMove.moveSPAndEmitCode(masm, ValueUtil.asRegister((Value)this.deltaValue), delta -> masm.ldadd(memAccessSize, (Register)delta, result, address, true, true));
        }
    }

    @Opcode(value="ATOMIC_READ_AND_ADD")
    public static final class AtomicReadAndAddOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndAddOp> TYPE = LIRInstructionClass.create(AtomicReadAndAddOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value deltaValue;

        AtomicReadAndAddOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, Value delta) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.deltaValue = delta;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            int addSize = Math.max(memAccessSize, 32);
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Label retry = new Label();
            masm.bind(retry);
            masm.loadExclusive(memAccessSize, result, address, false);
            try (AArch64MacroAssembler.ScratchRegister scratchRegister1 = masm.getScratchRegister();){
                Register scratch1 = scratchRegister1.getRegister();
                if (LIRValueUtil.isConstantValue(this.deltaValue)) {
                    long delta = LIRValueUtil.asConstantValue(this.deltaValue).getJavaConstant().asLong();
                    masm.add(addSize, scratch1, result, delta);
                } else {
                    masm.add(addSize, scratch1, result, ValueUtil.asRegister((Value)this.deltaValue));
                }
                try (AArch64MacroAssembler.ScratchRegister scratchRegister2 = masm.getScratchRegister();){
                    Register scratch2 = scratchRegister2.getRegister();
                    masm.storeExclusive(memAccessSize, scratch2, scratch1, address, true);
                    masm.cbnz(32, scratch2, retry);
                }
            }
            masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
        }
    }

    @Opcode(value="ATOMIC_READ_AND_WRITE")
    public static class AtomicReadAndWriteOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndWriteOp> TYPE = LIRInstructionClass.create(AtomicReadAndWriteOp.class);
        protected final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue newValue;

        protected AtomicReadAndWriteOp(LIRInstructionClass<? extends AArch64LIRInstruction> c, AArch64Kind kind, AllocatableValue result, AllocatableValue address, AllocatableValue newValue) {
            super(c);
            assert (kind.isInteger());
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.newValue = newValue;
        }

        public AtomicReadAndWriteOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, AllocatableValue newValue) {
            this(TYPE, kind, result, address, newValue);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AtomicReadAndWriteOp.emitSwap(masm, this.accessKind, ValueUtil.asRegister((Value)this.addressValue), ValueUtil.asRegister((Value)this.resultValue), ValueUtil.asRegister((Value)this.newValue));
        }

        protected static void emitSwap(AArch64MacroAssembler masm, AArch64Kind accessKind, Register address, Register result, Register newValue) {
            int memAccessSize = accessKind.getSizeInBytes() * 8;
            AArch64AtomicMove.moveSPAndEmitCode(masm, newValue, value -> {
                if (AArch64LIRFlags.useLSE(masm)) {
                    masm.swp(memAccessSize, (Register)value, result, address, true, true);
                } else {
                    try (AArch64MacroAssembler.ScratchRegister scratchRegister = masm.getScratchRegister();){
                        Register scratch = scratchRegister.getRegister();
                        Label retry = new Label();
                        masm.bind(retry);
                        masm.loadExclusive(memAccessSize, result, address, false);
                        masm.storeExclusive(memAccessSize, scratch, (Register)value, address, true);
                        masm.cbnz(32, scratch, retry);
                        masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
                    }
                }
            });
        }
    }

    @Opcode(value="CAS")
    public static class CompareAndSwapOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CompareAndSwapOp> TYPE = LIRInstructionClass.create(CompareAndSwapOp.class);
        protected final AArch64Kind accessKind;
        protected final MemoryOrderMode memoryOrder;
        protected final boolean setConditionFlags;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected Value expectedValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue newValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;

        protected CompareAndSwapOp(LIRInstructionClass<? extends AArch64LIRInstruction> c, AArch64Kind accessKind, MemoryOrderMode memoryOrder, boolean setConditionFlags, AllocatableValue result, Value expectedValue, AllocatableValue newValue, AllocatableValue addressValue) {
            super(c);
            this.accessKind = accessKind;
            this.memoryOrder = memoryOrder;
            this.setConditionFlags = setConditionFlags;
            this.resultValue = result;
            this.expectedValue = expectedValue;
            this.newValue = newValue;
            this.addressValue = addressValue;
        }

        public CompareAndSwapOp(AArch64Kind accessKind, MemoryOrderMode memoryOrder, boolean setConditionFlags, AllocatableValue result, Value expectedValue, AllocatableValue newValue, AllocatableValue addressValue) {
            this(TYPE, accessKind, memoryOrder, setConditionFlags, result, expectedValue, newValue, addressValue);
        }

        private static void emitCompare(AArch64MacroAssembler masm, int memAccessSize, Register result, Register expected) {
            switch (memAccessSize) {
                case 8: {
                    masm.cmp(32, result, expected, AArch64Assembler.ExtendType.UXTB, 0);
                    break;
                }
                case 16: {
                    masm.cmp(32, result, expected, AArch64Assembler.ExtendType.UXTH, 0);
                    break;
                }
                case 32: 
                case 64: {
                    masm.cmp(memAccessSize, result, expected);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue(memAccessSize);
                }
            }
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register expected = ValueUtil.asRegister((Value)this.expectedValue);
            CompareAndSwapOp.emitCompareAndSwap(masm, this.accessKind, address, result, expected, ValueUtil.asRegister((Value)this.newValue), this.memoryOrder, this.setConditionFlags);
        }

        protected static void emitCompareAndSwap(AArch64MacroAssembler masm, AArch64Kind accessKind, Register address, Register result, Register expected, Register newValue, MemoryOrderMode memoryOrder, boolean setConditionFlags) {
            boolean acquire;
            assert (accessKind.isInteger());
            int memAccessSize = accessKind.getSizeInBytes() * 8;
            boolean release = switch (memoryOrder) {
                case MemoryOrderMode.PLAIN, MemoryOrderMode.OPAQUE -> {
                    acquire = false;
                    yield false;
                }
                case MemoryOrderMode.ACQUIRE -> {
                    acquire = true;
                    yield false;
                }
                case MemoryOrderMode.RELEASE -> {
                    acquire = false;
                    yield true;
                }
                case MemoryOrderMode.RELEASE_ACQUIRE, MemoryOrderMode.VOLATILE -> {
                    acquire = true;
                    yield true;
                }
                default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)memoryOrder);
            };
            int moveSize = Math.max(memAccessSize, 32);
            if (AArch64LIRFlags.useLSE(masm)) {
                masm.mov(moveSize, result, expected);
                AArch64AtomicMove.moveSPAndEmitCode(masm, newValue, newVal -> masm.cas(memAccessSize, result, (Register)newVal, address, acquire, release));
                if (setConditionFlags) {
                    CompareAndSwapOp.emitCompare(masm, memAccessSize, result, expected);
                }
            } else {
                try (AArch64MacroAssembler.ScratchRegister scratchRegister1 = masm.getScratchRegister();
                     AArch64MacroAssembler.ScratchRegister scratchRegister2 = masm.getScratchRegister();){
                    Label retry = new Label();
                    masm.bind(retry);
                    Register scratch2 = scratchRegister2.getRegister();
                    Register newValueReg = newValue;
                    if (newValueReg.equals((Object)AArch64.sp)) {
                        masm.mov(moveSize, scratch2, newValueReg);
                        newValueReg = scratch2;
                    }
                    masm.loadExclusive(memAccessSize, result, address, false);
                    CompareAndSwapOp.emitCompare(masm, memAccessSize, result, expected);
                    masm.csel(moveSize, scratch2, newValueReg, result, AArch64Assembler.ConditionFlag.EQ);
                    Register scratch1 = scratchRegister1.getRegister();
                    masm.storeExclusive(memAccessSize, scratch1, scratch2, address, acquire || release);
                    masm.cbnz(32, scratch1, retry);
                }
                if (acquire) {
                    masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
                }
            }
        }
    }
}

