/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;

public enum AArch64ArithmeticOp {
    NEG,
    NEGS,
    NOT,
    ADD(ARMv8ConstantCategory.ADDSUBTRACT),
    ADDS(ARMv8ConstantCategory.ADDSUBTRACT),
    SUB(ARMv8ConstantCategory.ADDSUBTRACT),
    SUBS(ARMv8ConstantCategory.ADDSUBTRACT),
    MUL,
    MULVS,
    MNEG,
    DIV,
    SMULH,
    UMULH,
    SMULL,
    SMNEGL,
    MADD,
    MSUB,
    FMADD,
    FMSUB,
    SMADDL,
    SMSUBL,
    REM,
    UDIV,
    UREM,
    SMAX,
    SMIN,
    UMAX,
    UMIN,
    AND(ARMv8ConstantCategory.LOGICAL),
    ANDS(ARMv8ConstantCategory.LOGICAL),
    OR(ARMv8ConstantCategory.LOGICAL),
    XOR(ARMv8ConstantCategory.LOGICAL),
    TST(ARMv8ConstantCategory.LOGICAL),
    BIC,
    ORN,
    EON,
    LSL(ARMv8ConstantCategory.SHIFT),
    LSR(ARMv8ConstantCategory.SHIFT),
    ASR(ARMv8ConstantCategory.SHIFT),
    ROR(ARMv8ConstantCategory.SHIFT),
    ABS,
    FADD,
    FSUB,
    FMUL,
    FDIV,
    FNEG,
    FABS,
    FRINTM,
    FRINTN,
    FRINTP,
    FRINTZ,
    FMAX,
    FMIN,
    FSQRT;

    public final ARMv8ConstantCategory category;

    private AArch64ArithmeticOp(ARMv8ConstantCategory category) {
        this.category = category;
    }

    private AArch64ArithmeticOp() {
        this(ARMv8ConstantCategory.NONE);
    }

    private static void emitRem(AArch64MacroAssembler masm, int size, Register dst, Register n, Register d) {
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            Register scratchReg = scratch.getRegister();
            masm.sdiv(size, scratchReg, n, d);
            masm.msub(size, dst, scratchReg, d, n);
        }
    }

    private static void emitURem(AArch64MacroAssembler masm, int size, Register dst, Register n, Register d) {
        try (AArch64MacroAssembler.ScratchRegister scratch = masm.getScratchRegister();){
            Register scratchReg = scratch.getRegister();
            masm.udiv(size, scratchReg, n, d);
            masm.msub(size, dst, scratchReg, d, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void emitMulvs(AArch64MacroAssembler masm, int size, Register dst, Register x, Register y) {
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();
             AArch64MacroAssembler.ScratchRegister sc2 = masm.getScratchRegister();){
            switch (size) {
                case 64: {
                    Register temp1 = sc1.getRegister();
                    Register temp2 = sc2.getRegister();
                    masm.mul(64, temp1, x, y);
                    masm.smulh(64, temp2, x, y);
                    masm.subs(64, AArch64.zr, temp2, temp1, AArch64Assembler.ShiftType.ASR, 63);
                    masm.mov(64, dst, temp1);
                    masm.mov(temp1, Integer.MIN_VALUE);
                    masm.csel(32, temp1, temp1, AArch64.zr, AArch64Assembler.ConditionFlag.NE);
                    masm.compare(32, temp1, 1);
                    return;
                }
                case 32: {
                    Register temp1 = sc1.getRegister();
                    masm.smaddl(temp1, x, y, AArch64.zr);
                    masm.mov(32, dst, temp1);
                    masm.subs(64, AArch64.zr, temp1, temp1, AArch64Assembler.ExtendType.SXTW, 0);
                    masm.mov(temp1, Integer.MIN_VALUE);
                    masm.csel(32, temp1, temp1, AArch64.zr, AArch64Assembler.ConditionFlag.NE);
                    masm.compare(32, temp1, 1);
                    return;
                }
            }
            return;
        }
    }

    public static AArch64LIRInstruction generateASIMDBinaryInstruction(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
        switch (op.ordinal()) {
            case 37: 
            case 38: {
                return new ASIMDBinaryTwoStepOp(op, result, a, b);
            }
        }
        return new ASIMDBinaryOp(op, result, a, b);
    }

    public static enum ARMv8ConstantCategory {
        NONE,
        LOGICAL,
        ADDSUBTRACT,
        SHIFT;

    }

    public static class ASIMDBinaryTwoStepOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDBinaryTwoStepOp> TYPE = LIRInstructionClass.create(ASIMDBinaryTwoStepOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;

        ASIMDBinaryTwoStepOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src1 = ValueUtil.asRegister((Value)this.a);
            Register src2 = ValueUtil.asRegister((Value)this.b);
            switch (this.op.ordinal()) {
                case 37: {
                    masm.neon.negVV(size, eSize, dst, src2);
                    masm.neon.ushlVVV(size, eSize, dst, src1, dst);
                    break;
                }
                case 38: {
                    masm.neon.negVV(size, eSize, dst, src2);
                    masm.neon.sshlVVV(size, eSize, dst, src1, dst);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class ASIMDBinaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDBinaryOp> TYPE = LIRInstructionClass.create(ASIMDBinaryOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;

        ASIMDBinaryOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src1 = ValueUtil.asRegister((Value)this.a);
            Register src2 = ValueUtil.asRegister((Value)this.b);
            switch (this.op.ordinal()) {
                case 28: {
                    masm.neon.andVVV(size, dst, src1, src2);
                    break;
                }
                case 30: {
                    masm.neon.orrVVV(size, dst, src1, src2);
                    break;
                }
                case 33: {
                    masm.neon.bicVVV(size, dst, src1, src2);
                    break;
                }
                case 34: {
                    masm.neon.ornVVV(size, dst, src1, src2);
                    break;
                }
                case 31: {
                    masm.neon.eorVVV(size, dst, src1, src2);
                    break;
                }
                case 3: {
                    masm.neon.addVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 5: {
                    masm.neon.subVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 36: {
                    masm.neon.ushlVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 7: {
                    masm.neon.mulVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 32: {
                    masm.neon.cmtstVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 9: {
                    masm.neon.mulVVV(size, eSize, dst, src1, src2);
                    masm.neon.negVV(size, eSize, dst, dst);
                    break;
                }
                case 24: {
                    masm.neon.smaxVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 25: {
                    masm.neon.sminVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 26: {
                    masm.neon.umaxVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 27: {
                    masm.neon.uminVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 41: {
                    masm.neon.faddVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 42: {
                    masm.neon.fsubVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 43: {
                    masm.neon.fmulVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 44: {
                    masm.neon.fdivVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 51: {
                    masm.neon.fmaxVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 52: {
                    masm.neon.fminVVV(size, eSize, dst, src1, src2);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class ASIMDMultiplyAddSubOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDMultiplyAddSubOp> TYPE = LIRInstructionClass.create(ASIMDMultiplyAddSubOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue c;

        public ASIMDMultiplyAddSubOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b, AllocatableValue c) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
            this.c = c;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src1 = ValueUtil.asRegister((Value)this.a);
            Register src2 = ValueUtil.asRegister((Value)this.b);
            masm.neon.moveVV(size, dst, ValueUtil.asRegister((Value)this.c));
            switch (this.op.ordinal()) {
                case 15: {
                    masm.neon.mlaVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 16: {
                    masm.neon.mlsVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 17: {
                    masm.neon.fmlaVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 18: {
                    masm.neon.fmlsVVV(size, eSize, dst, src1, src2);
                    break;
                }
                case 19: {
                    masm.neon.smlalVVV(eSize, dst, src1, src2);
                    break;
                }
                case 20: {
                    masm.neon.smlslVVV(eSize, dst, src1, src2);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
                }
            }
        }
    }

    public static class ASIMDBinaryConstOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDBinaryConstOp> TYPE = LIRInstructionClass.create(ASIMDBinaryConstOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        private final JavaConstant b;

        public ASIMDBinaryConstOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, JavaConstant b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.a);
            long immValue = this.b.asLong();
            int clampedShift = AArch64MacroAssembler.clampShiftAmt(eSize == AArch64ASIMDAssembler.ElementSize.DoubleWord ? 64 : 32, immValue);
            switch (this.op.ordinal()) {
                case 30: {
                    masm.neon.moveVV(size, dst, src);
                    masm.neon.orrVI(size, eSize, dst, immValue);
                    break;
                }
                case 33: {
                    masm.neon.moveVV(size, dst, src);
                    masm.neon.bicVI(size, eSize, dst, immValue);
                    break;
                }
                case 36: {
                    masm.neon.shlVVI(size, eSize, dst, src, clampedShift);
                    break;
                }
                case 37: {
                    masm.neon.ushrVVI(size, eSize, dst, src, clampedShift);
                    break;
                }
                case 38: {
                    masm.neon.sshrVVI(size, eSize, dst, src, clampedShift);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class ASIMDUnaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDUnaryOp> TYPE = LIRInstructionClass.create(ASIMDUnaryOp.class);
        @Opcode
        private final AArch64ArithmeticOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;

        public ASIMDUnaryOp(AArch64ArithmeticOp opcode, AllocatableValue result, AllocatableValue x) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.x);
            switch (this.opcode.ordinal()) {
                case 2: {
                    masm.neon.notVV(size, dst, src);
                    break;
                }
                case 0: {
                    masm.neon.negVV(size, eSize, dst, src);
                    break;
                }
                case 45: {
                    masm.neon.fnegVV(size, eSize, dst, src);
                    break;
                }
                case 40: {
                    masm.neon.absVV(size, eSize, dst, src);
                    break;
                }
                case 46: {
                    masm.neon.fabsVV(size, eSize, dst, src);
                    break;
                }
                case 53: {
                    masm.neon.fsqrtVV(size, eSize, dst, src);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.opcode.name());
                }
            }
        }
    }

    public static class MultiplyAddSubOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<MultiplyAddSubOp> TYPE = LIRInstructionClass.create(MultiplyAddSubOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src2;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src3;

        public MultiplyAddSubOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AllocatableValue src3) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.src1 = src1;
            this.src2 = src2;
            this.src3 = src3;
            assert (MultiplyAddSubOp.checkParameters(op, result, src1, src2, src3));
        }

        private static boolean checkParameters(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AllocatableValue src3) {
            int dstSize = result.getPlatformKind().getSizeInBytes() * 8;
            int src1Size = src1.getPlatformKind().getSizeInBytes() * 8;
            int src2Size = src2.getPlatformKind().getSizeInBytes() * 8;
            int src3Size = src3.getPlatformKind().getSizeInBytes() * 8;
            switch (op.ordinal()) {
                case 19: 
                case 20: {
                    assert (dstSize == 64 && src3Size == 64) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "src3", src3, "src3Size", src3Size);
                    assert (src1Size == 32 && src2Size == 32) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "src3", src3, "src3Size", src3Size);
                    break;
                }
                case 15: 
                case 16: {
                    assert (dstSize == 64 || dstSize == 32) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "src3", src3, "src3Size", src3Size);
                    assert (dstSize <= src1Size && dstSize <= src2Size && dstSize <= src3Size) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "src3", src3, "src3Size", src3Size);
                    break;
                }
                case 17: {
                    assert (dstSize == 64 || dstSize == 32) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "src3", src3, "src3Size", src3Size);
                    assert (dstSize == src1Size && dstSize == src2Size && dstSize == src3Size) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "src3", src3, "src3Size", src3Size);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)op);
                }
            }
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.src1.getPlatformKind() == this.src2.getPlatformKind()) : Assertions.errorMessageContext("result", this.result, "src1", this.src1, "src2", this.src2);
            int dstSize = this.result.getPlatformKind().getSizeInBytes() * 8;
            int src1Size = this.src1.getPlatformKind().getSizeInBytes() * 8;
            int src2Size = this.src2.getPlatformKind().getSizeInBytes() * 8;
            int src3Size = this.src3.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op.ordinal()) {
                case 15: {
                    masm.madd(dstSize, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case 16: {
                    masm.msub(dstSize, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case 17: {
                    masm.fmadd(dstSize, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case 19: {
                    assert (dstSize == 64 && src3Size == 64) : Assertions.errorMessageContext("result", this.result, "src1", this.src1, "src2", this.src2, "src2Size", src2Size, "src3", this.src3, "src3Size", src3Size);
                    assert (src1Size == 32 && src2Size == 32) : Assertions.errorMessageContext("result", this.result, "src1", this.src1, "src2", this.src2, "src2Size", src2Size, "src3", this.src3, "src3Size", src3Size);
                    masm.smaddl(ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                case 20: {
                    assert (dstSize == 64 && src3Size == 64) : Assertions.errorMessageContext("result", this.result, "src1", this.src1, "src2", this.src2, "src2Size", src2Size, "src3", this.src3, "src3Size", src3Size);
                    assert (src1Size == 32 && src2Size == 32) : Assertions.errorMessageContext("result", this.result, "src1", this.src1, "src2", this.src2, "src2Size", src2Size, "src3", this.src3, "src3Size", src3Size);
                    masm.smsubl(ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), ValueUtil.asRegister((Value)this.src3));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
                }
            }
        }
    }

    public static class ExtendedAddSubShiftOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ExtendedAddSubShiftOp> TYPE = LIRInstructionClass.create(ExtendedAddSubShiftOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src2;
        private final AArch64Assembler.ExtendType extendType;
        private final int shiftAmt;

        public ExtendedAddSubShiftOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AArch64Assembler.ExtendType extendType, int shiftAmt) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.src1 = src1;
            this.src2 = src2;
            this.extendType = extendType;
            this.shiftAmt = shiftAmt;
            assert (ExtendedAddSubShiftOp.checkParameters(op, result, src1, src2, extendType, shiftAmt));
        }

        private static boolean checkParameters(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AArch64Assembler.ExtendType extendType, int shiftAmt) {
            int dstSize = result.getPlatformKind().getSizeInBytes() * 8;
            int src1Size = src1.getPlatformKind().getSizeInBytes() * 8;
            int src2Size = src2.getPlatformKind().getSizeInBytes() * 8;
            assert (op == ADD || op == SUB) : op;
            assert (shiftAmt >= 0 && shiftAmt <= 4) : Assertions.errorMessageContext("shiftAmt", shiftAmt);
            assert (dstSize == 32 || dstSize == 64) : Assertions.errorMessageContext("dstSize", dstSize);
            assert (dstSize <= src1Size) : Assertions.errorMessageContext("dstSize", dstSize, "src1Size", src1Size);
            switch (extendType) {
                case UXTB: 
                case SXTB: {
                    assert (src2Size >= 8) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size);
                    break;
                }
                case UXTH: 
                case SXTH: {
                    assert (src2Size >= 16) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size);
                    break;
                }
                case UXTW: 
                case SXTW: {
                    assert (src2Size >= 32) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size);
                    break;
                }
                case UXTX: 
                case SXTX: {
                    assert (dstSize == 64) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "dstSize", dstSize);
                    assert (src2Size == 64) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size, "dstSize", dstSize);
                    break;
                }
            }
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op.ordinal()) {
                case 3: {
                    masm.add(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.extendType, this.shiftAmt);
                    break;
                }
                case 5: {
                    masm.sub(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.extendType, this.shiftAmt);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
                }
            }
        }
    }

    public static class BinaryShiftOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<BinaryShiftOp> TYPE = LIRInstructionClass.create(BinaryShiftOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src1;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue src2;
        private final AArch64Assembler.ShiftType shiftType;
        private final int shiftAmt;

        public BinaryShiftOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue src1, AllocatableValue src2, AArch64Assembler.ShiftType shiftType, int shiftAmt) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.src1 = src1;
            this.src2 = src2;
            this.shiftType = shiftType;
            this.shiftAmt = shiftAmt;
            assert (BinaryShiftOp.checkParameters(result, src1, src2));
        }

        private static boolean checkParameters(AllocatableValue result, AllocatableValue src1, AllocatableValue src2) {
            int dstSize = result.getPlatformKind().getSizeInBytes() * 8;
            int src1Size = src1.getPlatformKind().getSizeInBytes() * 8;
            int src2Size = src2.getPlatformKind().getSizeInBytes() * 8;
            assert (dstSize == 32 || dstSize == 64) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size);
            assert (dstSize == src1Size && dstSize == src2Size) : Assertions.errorMessageContext("result", result, "src1", src1, "src2", src2, "src2Size", src2Size);
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op.ordinal()) {
                case 3: {
                    masm.add(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case 5: {
                    masm.sub(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case 28: {
                    masm.and(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case 30: {
                    masm.orr(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case 31: {
                    masm.eor(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case 33: {
                    masm.bic(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case 34: {
                    masm.orn(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                case 35: {
                    masm.eon(size, ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.src1), ValueUtil.asRegister((Value)this.src2), this.shiftType, this.shiftAmt);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class BinaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<BinaryOp> TYPE = LIRInstructionClass.create(BinaryOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue b;

        public BinaryOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
            assert (BinaryOp.checkParameters(op, result, a, b));
        }

        private static boolean checkParameters(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, AllocatableValue b) {
            int dstSize = result.getPlatformKind().getSizeInBytes() * 8;
            int src1Size = a.getPlatformKind().getSizeInBytes() * 8;
            int src2Size = b.getPlatformKind().getSizeInBytes() * 8;
            switch (op.ordinal()) {
                case 13: 
                case 14: {
                    assert (dstSize == 64 && src1Size == 32 && src2Size == 32) : Assertions.errorMessageContext("a", a, "b", b, "dstSize", dstSize, "src2Size", src2Size);
                    break;
                }
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 51: 
                case 52: {
                    assert (dstSize == 32 || dstSize == 64) : Assertions.errorMessageContext("a", a, "b", b, "dstSize", dstSize);
                    assert (dstSize == src1Size && dstSize == src2Size) : Assertions.errorMessageContext("a", a, "b", b, "dstSize", dstSize, "src2Size", src2Size);
                    break;
                }
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    assert (dstSize == 32 || dstSize == 64) : Assertions.errorMessageContext("a", a, "b", b, "dstSize", dstSize);
                    assert (dstSize <= src1Size) : Assertions.errorMessageContext("dstSize", dstSize, "src1Size", src1Size);
                    break;
                }
                default: {
                    assert (dstSize == 32 || dstSize == 64) : dstSize;
                    assert (dstSize <= src1Size && dstSize <= src2Size) : Assertions.errorMessageContext("dstSize", dstSize, "src2Size", src2Size);
                    break;
                }
            }
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src1 = ValueUtil.asRegister((Value)this.a);
            Register src2 = ValueUtil.asRegister((Value)this.b);
            int dstSize = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.op.ordinal()) {
                case 3: {
                    masm.add(dstSize, dst, src1, src2);
                    break;
                }
                case 4: {
                    masm.adds(dstSize, dst, src1, src2);
                    break;
                }
                case 5: {
                    masm.sub(dstSize, dst, src1, src2);
                    break;
                }
                case 6: {
                    masm.subs(dstSize, dst, src1, src2);
                    break;
                }
                case 7: {
                    masm.mul(dstSize, dst, src1, src2);
                    break;
                }
                case 12: {
                    masm.umulh(dstSize, dst, src1, src2);
                    break;
                }
                case 11: {
                    masm.smulh(dstSize, dst, src1, src2);
                    break;
                }
                case 9: {
                    masm.mneg(dstSize, dst, src1, src2);
                    break;
                }
                case 13: {
                    masm.smull(dst, src1, src2);
                    break;
                }
                case 14: {
                    masm.smnegl(dst, src1, src2);
                    break;
                }
                case 10: {
                    masm.sdiv(dstSize, dst, src1, src2);
                    break;
                }
                case 22: {
                    masm.udiv(dstSize, dst, src1, src2);
                    break;
                }
                case 28: {
                    masm.and(dstSize, dst, src1, src2);
                    break;
                }
                case 29: {
                    masm.ands(dstSize, dst, src1, src2);
                    break;
                }
                case 30: {
                    masm.orr(dstSize, dst, src1, src2);
                    break;
                }
                case 31: {
                    masm.eor(dstSize, dst, src1, src2);
                    break;
                }
                case 33: {
                    masm.bic(dstSize, dst, src1, src2);
                    break;
                }
                case 32: {
                    assert (dst.equals((Object)AArch64.zr));
                    masm.tst(dstSize, src1, src2);
                    break;
                }
                case 34: {
                    masm.orn(dstSize, dst, src1, src2);
                    break;
                }
                case 35: {
                    masm.eon(dstSize, dst, src1, src2);
                    break;
                }
                case 36: {
                    masm.lsl(dstSize, dst, src1, src2);
                    break;
                }
                case 37: {
                    masm.lsr(dstSize, dst, src1, src2);
                    break;
                }
                case 38: {
                    masm.asr(dstSize, dst, src1, src2);
                    break;
                }
                case 39: {
                    masm.ror(dstSize, dst, src1, src2);
                    break;
                }
                case 41: {
                    masm.fadd(dstSize, dst, src1, src2);
                    break;
                }
                case 42: {
                    masm.fsub(dstSize, dst, src1, src2);
                    break;
                }
                case 43: {
                    masm.fmul(dstSize, dst, src1, src2);
                    break;
                }
                case 44: {
                    masm.fdiv(dstSize, dst, src1, src2);
                    break;
                }
                case 51: {
                    masm.fmax(dstSize, dst, src1, src2);
                    break;
                }
                case 52: {
                    masm.fmin(dstSize, dst, src1, src2);
                    break;
                }
                case 21: {
                    AArch64ArithmeticOp.emitRem(masm, dstSize, dst, src1, src2);
                    break;
                }
                case 23: {
                    AArch64ArithmeticOp.emitURem(masm, dstSize, dst, src1, src2);
                    break;
                }
                case 8: {
                    AArch64ArithmeticOp.emitMulvs(masm, dstSize, dst, src1, src2);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class BinaryConstOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<BinaryConstOp> TYPE = LIRInstructionClass.create(BinaryConstOp.class);
        @Opcode
        private final AArch64ArithmeticOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue a;
        private final JavaConstant b;

        public BinaryConstOp(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, JavaConstant b) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.a = a;
            this.b = b;
            assert (BinaryConstOp.checkParameters(op, result, a, b));
        }

        private static boolean checkParameters(AArch64ArithmeticOp op, AllocatableValue result, AllocatableValue a, JavaConstant b) {
            int dstSize = result.getPlatformKind().getSizeInBytes() * 8;
            int srcSize = a.getPlatformKind().getSizeInBytes() * 8;
            long immediate = b.asLong();
            switch (op.ordinal()) {
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    assert (AArch64MacroAssembler.isAddSubtractImmediate(immediate, true));
                    break;
                }
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    assert (AArch64MacroAssembler.isLogicalImmediate(dstSize, immediate));
                    break;
                }
            }
            assert (dstSize == 32 || dstSize == 64) : dstSize;
            if (op == AND || op == ANDS) {
                assert (dstSize <= srcSize || (NumUtil.getNbitNumberLong(srcSize) & immediate) == immediate) : Assertions.errorMessageContext("dstSize", dstSize, "srcSize", srcSize, "immediate", immediate);
            } else assert (dstSize <= srcSize) : Assertions.errorMessageContext("dstSize", dstSize, "srcSize", srcSize);
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.op.category != ARMv8ConstantCategory.NONE) : this.op.category;
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.a);
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            long immediate = this.b.asLong();
            switch (this.op.ordinal()) {
                case 3: {
                    masm.add(size, dst, src, NumUtil.safeToInt(immediate));
                    break;
                }
                case 5: {
                    masm.sub(size, dst, src, NumUtil.safeToInt(immediate));
                    break;
                }
                case 4: {
                    masm.adds(size, dst, src, NumUtil.safeToInt(immediate));
                    break;
                }
                case 6: {
                    masm.subs(size, dst, src, NumUtil.safeToInt(immediate));
                    break;
                }
                case 28: {
                    long mask = NumUtil.getNbitNumberLong(size);
                    if ((immediate & mask) == mask) {
                        masm.mov(size, dst, src);
                        break;
                    }
                    masm.and(size, dst, src, immediate);
                    break;
                }
                case 29: {
                    masm.ands(size, dst, src, immediate);
                    break;
                }
                case 30: {
                    masm.orr(size, dst, src, immediate);
                    break;
                }
                case 31: {
                    masm.eor(size, dst, src, immediate);
                    break;
                }
                case 32: {
                    assert (dst.equals((Object)AArch64.zr));
                    masm.tst(size, src, immediate);
                    break;
                }
                case 36: {
                    masm.lsl(size, dst, src, immediate);
                    break;
                }
                case 37: {
                    masm.lsr(size, dst, src, immediate);
                    break;
                }
                case 38: {
                    masm.asr(size, dst, src, immediate);
                    break;
                }
                case 39: {
                    masm.ror(size, dst, src, immediate);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.op.name());
                }
            }
        }
    }

    public static class UnaryOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<UnaryOp> TYPE = LIRInstructionClass.create(UnaryOp.class);
        @Opcode
        private final AArch64ArithmeticOp opcode;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;

        public UnaryOp(AArch64ArithmeticOp opcode, AllocatableValue result, AllocatableValue x) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.opcode = opcode;
            this.result = result;
            this.x = x;
            assert (UnaryOp.checkParameters(result, x));
        }

        private static boolean checkParameters(AllocatableValue result, AllocatableValue input) {
            int dstSize = result.getPlatformKind().getSizeInBytes() * 8;
            int srcSize = input.getPlatformKind().getSizeInBytes() * 8;
            assert (dstSize == 32 || dstSize == 64) : dstSize;
            assert (dstSize <= srcSize) : Assertions.errorMessageContext("result", result, "src", input);
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register src = ValueUtil.asRegister((Value)this.x);
            int size = this.result.getPlatformKind().getSizeInBytes() * 8;
            switch (this.opcode.ordinal()) {
                case 0: {
                    masm.sub(size, dst, AArch64.zr, src);
                    break;
                }
                case 1: {
                    masm.subs(size, dst, AArch64.zr, src);
                    break;
                }
                case 45: {
                    masm.fneg(size, dst, src);
                    break;
                }
                case 2: {
                    masm.not(size, dst, src);
                    break;
                }
                case 40: {
                    masm.compare(size, src, 0);
                    masm.csneg(size, dst, src, src, AArch64Assembler.ConditionFlag.GE);
                    break;
                }
                case 46: {
                    masm.fabs(size, dst, src);
                    break;
                }
                case 47: {
                    masm.frintm(size, dst, src);
                    break;
                }
                case 48: {
                    masm.frintn(size, dst, src);
                    break;
                }
                case 49: {
                    masm.frintp(size, dst, src);
                    break;
                }
                case 50: {
                    masm.frintz(size, dst, src);
                    break;
                }
                case 53: {
                    masm.fsqrt(size, dst, src);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("op=" + this.opcode.name());
                }
            }
        }
    }
}

