/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64ASIMDAssembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public enum AArch64AcrossVectorOp {
    ADDV,
    SADDLV,
    UADDLV,
    UMAX;


    public static class ASIMDOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDOp> TYPE = LIRInstructionClass.create(ASIMDOp.class);
        @Opcode
        private final AArch64AcrossVectorOp op;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        public ASIMDOp(AArch64AcrossVectorOp op, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.input.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.input.getPlatformKind());
            Register resultReg = ValueUtil.asRegister((Value)this.result);
            Register inputReg = ValueUtil.asRegister((Value)this.input);
            switch (this.op.ordinal()) {
                case 0: {
                    masm.neon.addvSV(size, eSize, resultReg, inputReg);
                    break;
                }
                case 1: {
                    assert (AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind()) == eSize.expand()) : Assertions.errorMessage(new Object[]{this.result, eSize});
                    masm.neon.saddlvSV(size, eSize, resultReg, inputReg);
                    break;
                }
                case 2: {
                    assert (AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind()) == eSize.expand()) : Assertions.errorMessage(new Object[]{this.result, eSize});
                    masm.neon.uaddlvSV(size, eSize, resultReg, inputReg);
                    break;
                }
                case 3: {
                    masm.neon.umaxvSV(size, eSize, resultReg, inputReg);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.op);
                }
            }
        }
    }
}

