/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.vm.ci.code.TargetDescription;

public final class NullCheckOptimizer
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR ir = lirGenRes.getLIR();
        int[] blockIndices = ir.getBlocks();
        NullCheckOptimizer.foldNullChecks(ir, blockIndices, target.implicitNullCheckLimit);
    }

    private static void foldNullChecks(LIR ir, int[] blockIds, int implicitNullCheckLimit) {
        for (int blockId : blockIds) {
            BasicBlock<?> block;
            ArrayList<LIRInstruction> list;
            if (LIR.isBlockDeleted(blockId) || (list = ir.getLIRforBlock(block = ir.getBlockById(blockId))).isEmpty()) continue;
            LIRInstruction lastInstruction = list.get(0);
            for (int i = 0; i < list.size(); ++i) {
                StandardOp.NullCheck nullCheck;
                StandardOp.ImplicitNullCheck implicitNullCheck;
                LIRInstruction instruction = list.get(i);
                if (instruction instanceof StandardOp.ImplicitNullCheck && lastInstruction instanceof StandardOp.NullCheck && (implicitNullCheck = (StandardOp.ImplicitNullCheck)((Object)instruction)).makeNullCheckFor((nullCheck = (StandardOp.NullCheck)((Object)lastInstruction)).getCheckedValue(), nullCheck.getState(), implicitNullCheckLimit)) {
                    list.remove(i - 1);
                    if (i < list.size()) {
                        instruction = list.get(i);
                    }
                }
                lastInstruction = instruction;
            }
        }
    }
}

