/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.StandardOp;

public final class LabelRef {
    private final LIR lir;
    private final BasicBlock<?> block;
    private final int suxIndex;

    public static LabelRef forSuccessor(LIR lir, BasicBlock<?> block, int suxIndex) {
        return new LabelRef(lir, block, suxIndex);
    }

    private LabelRef(LIR lir, BasicBlock<?> block, int suxIndex) {
        this.lir = lir;
        this.block = block;
        this.suxIndex = suxIndex;
    }

    public BasicBlock<?> getSourceBlock() {
        return this.block;
    }

    public BasicBlock<?> getTargetBlock() {
        return this.block.getSuccessorAt(this.suxIndex);
    }

    public Label label() {
        return ((StandardOp.LabelOp)this.lir.getLIRforBlock(this.getTargetBlock()).get(0)).getLabel();
    }

    public String toString() {
        return String.valueOf(this.getSourceBlock()) + " -> " + String.valueOf(this.suxIndex < this.block.getSuccessorCount() ? this.getTargetBlock() : "?");
    }
}

