/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import jdk.graal.compiler.core.common.FieldIntrospection;
import jdk.graal.compiler.core.common.Fields;
import jdk.graal.compiler.core.common.FieldsScanner;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.CompositeValue;
import jdk.graal.compiler.lir.ConstantValue;
import jdk.graal.compiler.lir.InstructionValueConsumer;
import jdk.graal.compiler.lir.InstructionValueProcedure;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.Variable;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;

abstract class LIRIntrospection<T>
extends FieldIntrospection<T> {
    private static final Class<Value> VALUE_CLASS = Value.class;
    private static final Class<ConstantValue> CONSTANT_VALUE_CLASS = ConstantValue.class;
    private static final Class<Variable> VARIABLE_CLASS = Variable.class;
    private static final Class<RegisterValue> REGISTER_VALUE_CLASS = RegisterValue.class;
    private static final Class<StackSlot> STACK_SLOT_CLASS = StackSlot.class;
    private static final Class<Value[]> VALUE_ARRAY_CLASS = Value[].class;
    protected Values values;

    LIRIntrospection(Class<T> clazz) {
        super(clazz);
    }

    private static boolean verifyAssignment(LIRInstruction inst, Value newValue, EnumSet<LIRInstruction.OperandFlag> flags) {
        Class<Object> type = newValue.getClass();
        if (!flags.contains((Object)LIRInstruction.OperandFlag.REG)) assert (!type.isAssignableFrom(REGISTER_VALUE_CLASS) && !type.isAssignableFrom(VARIABLE_CLASS)) : "Cannot assign RegisterValue / Variable to field without REG flag: " + String.valueOf(inst) + " newValue=" + String.valueOf(newValue);
        if (!flags.contains((Object)LIRInstruction.OperandFlag.STACK)) assert (!type.isAssignableFrom(STACK_SLOT_CLASS)) : "Cannot assign StackSlot to field without STACK flag: " + String.valueOf(inst) + " newValue=" + String.valueOf(newValue);
        if (!flags.contains((Object)LIRInstruction.OperandFlag.CONST)) assert (!type.isAssignableFrom(CONSTANT_VALUE_CLASS)) : "Cannot assign Constant to field without CONST flag: " + String.valueOf(inst) + " newValue=" + String.valueOf(newValue);
        return true;
    }

    protected static void forEach(LIRInstruction inst, Values values, LIRInstruction.OperandMode mode, InstructionValueProcedure proc) {
        for (int i = 0; i < values.getCount(); ++i) {
            assert (LIRInstruction.ALLOWED_FLAGS.get((Object)mode).containsAll(values.getFlags(i)));
            if (i < values.getDirectCount()) {
                CompositeValue newValue;
                Value value = values.getValue(inst, i);
                if (value instanceof CompositeValue) {
                    CompositeValue composite = (CompositeValue)value;
                    newValue = composite.forEachComponent(inst, mode, proc);
                } else {
                    newValue = proc.doValue(inst, value, mode, values.getFlags(i));
                }
                if (value.identityEquals((Value)newValue)) continue;
                if (!(value instanceof CompositeValue)) assert (LIRIntrospection.verifyAssignment(inst, newValue, values.getFlags(i)));
                GraalError.guarantee(newValue.getPlatformKind().equals((Object)value.getPlatformKind()), "New assignment changes PlatformKind");
                values.setValue(inst, i, newValue);
                continue;
            }
            Value[] valueArray = values.getValueArray(inst, i);
            for (int j = 0; j < valueArray.length; ++j) {
                CompositeValue newValue;
                Value value = valueArray[j];
                if (value instanceof CompositeValue) {
                    CompositeValue composite = (CompositeValue)value;
                    newValue = composite.forEachComponent(inst, mode, proc);
                } else {
                    newValue = proc.doValue(inst, value, mode, values.getFlags(i));
                }
                if (value.identityEquals((Value)newValue)) continue;
                GraalError.guarantee(newValue.getPlatformKind().equals((Object)value.getPlatformKind()), "New assignment changes PlatformKind");
                valueArray[j] = newValue;
            }
        }
    }

    protected static void visitEach(LIRInstruction inst, Values values, LIRInstruction.OperandMode mode, InstructionValueConsumer proc) {
        for (int i = 0; i < values.getCount(); ++i) {
            assert (LIRInstruction.ALLOWED_FLAGS.get((Object)mode).containsAll(values.getFlags(i)));
            if (i < values.getDirectCount()) {
                Value value = values.getValue(inst, i);
                if (value instanceof CompositeValue) {
                    CompositeValue composite = (CompositeValue)value;
                    composite.visitEachComponent(inst, mode, proc);
                    continue;
                }
                proc.visitValue(inst, value, mode, values.getFlags(i));
                continue;
            }
            Value[] valueArray = values.getValueArray(inst, i);
            for (int j = 0; j < valueArray.length; ++j) {
                Value value = valueArray[j];
                if (value instanceof CompositeValue) {
                    CompositeValue composite = (CompositeValue)value;
                    composite.visitEachComponent(inst, mode, proc);
                    continue;
                }
                proc.visitValue(inst, value, mode, values.getFlags(i));
            }
        }
    }

    protected static void appendValues(StringBuilder sb, Object obj, String start, String end, String startMultiple, String endMultiple, boolean elideSingleName, String[] prefix, Fields ... fieldsList) {
        int total = 0;
        for (Fields fields : fieldsList) {
            total += fields.getCount();
        }
        if (total == 0) {
            return;
        }
        sb.append(start);
        if (total > 1) {
            sb.append(startMultiple);
        }
        String sep = "";
        int i = 0;
        for (Fields fields : fieldsList) {
            for (int j = 0; j < fields.getCount(); ++j) {
                sb.append(sep).append(prefix[i]);
                if (!elideSingleName || total > 1) {
                    sb.append(fields.getName(j)).append(": ");
                }
                sb.append(LIRIntrospection.getFieldString(obj, j, fields));
                sep = ", ";
            }
            ++i;
        }
        if (total > 1) {
            sb.append(endMultiple);
        }
        sb.append(end);
    }

    protected static String getFieldString(Object obj, int index, Fields fields) {
        Object value = fields.get(obj, index);
        Class<?> type = fields.getType(index);
        if (value == null || type.isPrimitive() || !type.isArray()) {
            return String.valueOf(value);
        }
        if (type == int[].class) {
            return Arrays.toString((int[])value);
        }
        if (type == double[].class) {
            return Arrays.toString((double[])value);
        }
        if (type == byte[].class) {
            byte[] byteValue = (byte[])value;
            if (LIRIntrospection.isPrintableAsciiString(byteValue)) {
                return LIRIntrospection.toString(byteValue);
            }
            return Arrays.toString(byteValue);
        }
        if (!type.getComponentType().isPrimitive()) {
            return Arrays.toString((Object[])value);
        }
        assert (false) : "unhandled field type: " + String.valueOf(type);
        return "";
    }

    private static boolean isPrintableAsciiString(byte[] array) {
        for (byte b : array) {
            char c = (char)b;
            if (c == '\u0000' || c >= ' ' && c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static String toString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        for (byte b : bytes) {
            if (b == 0) {
                sb.append("\\0");
                continue;
            }
            if (b == 34) {
                sb.append("\\\"");
                continue;
            }
            if (b == 10) {
                sb.append("\\n");
                continue;
            }
            sb.append((char)b);
        }
        sb.append('\"');
        return sb.toString();
    }

    protected static final class Values
    extends Fields {
        private final int directCount;
        private final EnumSet<LIRInstruction.OperandFlag>[] flags;
        private static final Values EMPTY_VALUES = new Values(0, Collections.emptyList());

        private Values(int directCount, List<ValueFieldInfo> fields) {
            super(fields);
            this.directCount = directCount;
            this.flags = new EnumSet[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                this.flags[i] = fields.get((int)i).flags;
            }
        }

        public static Values create(int directCount, ArrayList<ValueFieldInfo> fields) {
            if (directCount == 0 && fields.size() == 0) {
                return EMPTY_VALUES;
            }
            return new Values(directCount, fields);
        }

        public static Values create(OperandModeAnnotation mode) {
            return Values.create(mode.directCount, mode.values);
        }

        public int getDirectCount() {
            return this.directCount;
        }

        public EnumSet<LIRInstruction.OperandFlag> getFlags(int i) {
            return this.flags[i];
        }

        protected Value getValue(Object obj, int index) {
            return (Value)this.getObject(obj, index);
        }

        protected void setValue(Object obj, int index, Value value) {
            this.putObjectChecked(obj, index, value);
        }

        protected Value[] getValueArray(Object obj, int index) {
            return (Value[])this.getObject(obj, index);
        }
    }

    protected static abstract class LIRFieldsScanner
    extends FieldsScanner {
        public final EconomicMap<Class<? extends Annotation>, OperandModeAnnotation> valueAnnotations;
        public final ArrayList<FieldsScanner.FieldInfo> states = new ArrayList();

        public LIRFieldsScanner(FieldsScanner.CalcOffset calc) {
            super(calc);
            this.valueAnnotations = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        }

        protected OperandModeAnnotation getOperandModeAnnotation(Field field) {
            OperandModeAnnotation result = null;
            MapCursor cursor = this.valueAnnotations.getEntries();
            while (cursor.advance()) {
                Object annotation = field.getAnnotation((Class)cursor.getKey());
                if (annotation == null) continue;
                assert (result == null) : "Field has two operand mode annotations: " + String.valueOf(field);
                result = (OperandModeAnnotation)cursor.getValue();
            }
            return result;
        }

        protected abstract EnumSet<LIRInstruction.OperandFlag> getFlags(Field var1);

        @Override
        protected void scanField(Field field, long offset) {
            Class<?> type = field.getType();
            if (VALUE_CLASS.isAssignableFrom(type) && !CONSTANT_VALUE_CLASS.isAssignableFrom(type)) {
                assert (!Modifier.isFinal(field.getModifiers())) : "Value field must not be declared final because it is modified by register allocator: " + String.valueOf(field);
                OperandModeAnnotation annotation = this.getOperandModeAnnotation(field);
                assert (annotation != null) : "Field must have operand mode annotation: " + String.valueOf(field);
                EnumSet<LIRInstruction.OperandFlag> flags = this.getFlags(field);
                assert (LIRFieldsScanner.verifyFlags(field, type, flags));
                annotation.values.add(new ValueFieldInfo(offset, field.getName(), type, field.getDeclaringClass(), flags));
                ++annotation.directCount;
            } else if (VALUE_ARRAY_CLASS.isAssignableFrom(type)) {
                OperandModeAnnotation annotation = this.getOperandModeAnnotation(field);
                assert (annotation != null) : "Field must have operand mode annotation: " + String.valueOf(field);
                EnumSet<LIRInstruction.OperandFlag> flags = this.getFlags(field);
                assert (LIRFieldsScanner.verifyFlags(field, type.getComponentType(), flags));
                annotation.values.add(new ValueFieldInfo(offset, field.getName(), type, field.getDeclaringClass(), flags));
            } else {
                assert (this.getOperandModeAnnotation(field) == null) : "Field must not have operand mode annotation: " + String.valueOf(field);
                assert (field.getAnnotation(LIRInstruction.State.class) == null) : "Field must not have state annotation: " + String.valueOf(field);
                super.scanField(field, offset);
            }
        }

        private static boolean verifyFlags(Field field, Class<?> type, EnumSet<LIRInstruction.OperandFlag> flags) {
            if (flags.contains((Object)LIRInstruction.OperandFlag.REG)) assert (type.isAssignableFrom(REGISTER_VALUE_CLASS) || type.isAssignableFrom(VARIABLE_CLASS)) : "Cannot assign RegisterValue / Variable to field with REG flag:" + String.valueOf(field);
            if (flags.contains((Object)LIRInstruction.OperandFlag.STACK)) assert (type.isAssignableFrom(STACK_SLOT_CLASS)) : "Cannot assign StackSlot to field with STACK flag:" + String.valueOf(field);
            if (flags.contains((Object)LIRInstruction.OperandFlag.CONST)) assert (type.isAssignableFrom(CONSTANT_VALUE_CLASS)) : "Cannot assign Constant to field with CONST flag:" + String.valueOf(field);
            return true;
        }
    }

    protected static class OperandModeAnnotation {
        public int directCount;
        public final ArrayList<ValueFieldInfo> values = new ArrayList();

        protected OperandModeAnnotation() {
        }
    }

    protected static class ValueFieldInfo
    extends FieldsScanner.FieldInfo {
        final EnumSet<LIRInstruction.OperandFlag> flags;

        public ValueFieldInfo(long offset, String name, Class<?> type, Class<?> declaringClass, EnumSet<LIRInstruction.OperandFlag> flags) {
            super(offset, name, type, declaringClass);
            assert (VALUE_ARRAY_CLASS.isAssignableFrom(type) || VALUE_CLASS.isAssignableFrom(type));
            this.flags = flags;
        }

        @Override
        public int compareTo(FieldsScanner.FieldInfo o) {
            if (VALUE_ARRAY_CLASS.isAssignableFrom(o.type)) {
                if (!VALUE_ARRAY_CLASS.isAssignableFrom(this.type)) {
                    return -1;
                }
            } else if (VALUE_ARRAY_CLASS.isAssignableFrom(this.type)) {
                return 1;
            }
            return super.compareTo(o);
        }

        @Override
        public String toString() {
            return super.toString() + String.valueOf(this.flags);
        }
    }
}

