/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import jdk.graal.compiler.core.common.Fields;
import jdk.graal.compiler.core.common.FieldsScanner;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.InstructionStateProcedure;
import jdk.graal.compiler.lir.InstructionValueConsumer;
import jdk.graal.compiler.lir.InstructionValueProcedure;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRIntrospection;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.StandardOp;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.Value;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class LIRInstructionClass<T>
extends LIRIntrospection<T> {
    private static final Class<LIRInstruction> INSTRUCTION_CLASS = LIRInstruction.class;
    private static final Class<LIRFrameState> STATE_CLASS = LIRFrameState.class;
    private final LIRIntrospection.Values uses;
    private final LIRIntrospection.Values alives;
    private final LIRIntrospection.Values temps;
    private final LIRIntrospection.Values defs;
    private final Fields states;
    private final boolean isMoveOp;
    private final boolean isValueMoveOp;
    private final boolean isLoadConstantOp;
    private String opcodeConstant;
    private int opcodeIndex;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <T extends LIRInstruction> LIRInstructionClass<T> create(Class<T> c) {
        return new LIRInstructionClass<T>(c);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private LIRInstructionClass(Class<T> clazz) {
        this(clazz, new FieldsScanner.DefaultCalcOffset());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public LIRInstructionClass(Class<T> clazz, FieldsScanner.CalcOffset calcOffset) {
        super(clazz);
        assert (INSTRUCTION_CLASS.isAssignableFrom(clazz));
        LIRInstructionFieldsScanner ifs = new LIRInstructionFieldsScanner(calcOffset);
        ifs.scan(clazz);
        this.uses = LIRIntrospection.Values.create((LIRIntrospection.OperandModeAnnotation)ifs.valueAnnotations.get(LIRInstruction.Use.class));
        this.alives = LIRIntrospection.Values.create((LIRIntrospection.OperandModeAnnotation)ifs.valueAnnotations.get(LIRInstruction.Alive.class));
        this.temps = LIRIntrospection.Values.create((LIRIntrospection.OperandModeAnnotation)ifs.valueAnnotations.get(LIRInstruction.Temp.class));
        this.defs = LIRIntrospection.Values.create((LIRIntrospection.OperandModeAnnotation)ifs.valueAnnotations.get(LIRInstruction.Def.class));
        this.states = Fields.create(ifs.states);
        this.data = Fields.create(ifs.data);
        this.opcodeConstant = ifs.opcodeConstant;
        this.opcodeIndex = ifs.opcodeField == null ? -1 : ifs.data.indexOf(ifs.opcodeField);
        this.isMoveOp = StandardOp.MoveOp.class.isAssignableFrom(clazz);
        this.isValueMoveOp = StandardOp.ValueMoveOp.class.isAssignableFrom(clazz);
        this.isLoadConstantOp = StandardOp.LoadConstantOp.class.isAssignableFrom(clazz);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static <T> LIRInstructionClass<T> get(Class<T> clazz) {
        try {
            Field field = clazz.getDeclaredField("TYPE");
            field.setAccessible(true);
            LIRInstructionClass result = (LIRInstructionClass)field.get(null);
            if (result == null) {
                throw GraalError.shouldNotReachHere("TYPE field not initialized for class " + clazz.getTypeName());
            }
            return result;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Fields[] getAllFields() {
        assert (this.values == null);
        return new Fields[]{this.data, this.uses, this.alives, this.temps, this.defs, this.states};
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getClass().getSimpleName()).append(" ").append(this.getClazz().getSimpleName()).append(" use[");
        this.uses.appendFields(str);
        str.append("] alive[");
        this.alives.appendFields(str);
        str.append("] temp[");
        this.temps.appendFields(str);
        str.append("] def[");
        this.defs.appendFields(str);
        str.append("] state[");
        this.states.appendFields(str);
        str.append("] data[");
        this.data.appendFields(str);
        str.append("]");
        return str.toString();
    }

    final String getOpcode(LIRInstruction obj) {
        if (this.opcodeConstant != null) {
            return this.opcodeConstant;
        }
        assert (this.opcodeIndex != -1);
        return String.valueOf(this.data.getObject(obj, this.opcodeIndex));
    }

    final boolean hasOperands() {
        return this.uses.getCount() > 0 || this.alives.getCount() > 0 || this.temps.getCount() > 0 || this.defs.getCount() > 0;
    }

    final boolean hasState(LIRInstruction obj) {
        for (int i = 0; i < this.states.getCount(); ++i) {
            if (this.states.getObject(obj, i) == null) continue;
            return true;
        }
        return false;
    }

    final void forEachUse(LIRInstruction obj, InstructionValueProcedure proc) {
        LIRInstructionClass.forEach(obj, this.uses, LIRInstruction.OperandMode.USE, proc);
    }

    final void forEachAlive(LIRInstruction obj, InstructionValueProcedure proc) {
        LIRInstructionClass.forEach(obj, this.alives, LIRInstruction.OperandMode.ALIVE, proc);
    }

    final void forEachTemp(LIRInstruction obj, InstructionValueProcedure proc) {
        LIRInstructionClass.forEach(obj, this.temps, LIRInstruction.OperandMode.TEMP, proc);
    }

    final void forEachDef(LIRInstruction obj, InstructionValueProcedure proc) {
        LIRInstructionClass.forEach(obj, this.defs, LIRInstruction.OperandMode.DEF, proc);
    }

    final void visitEachUse(LIRInstruction obj, InstructionValueConsumer proc) {
        LIRInstructionClass.visitEach(obj, this.uses, LIRInstruction.OperandMode.USE, proc);
    }

    final void visitEachAlive(LIRInstruction obj, InstructionValueConsumer proc) {
        LIRInstructionClass.visitEach(obj, this.alives, LIRInstruction.OperandMode.ALIVE, proc);
    }

    final void visitEachTemp(LIRInstruction obj, InstructionValueConsumer proc) {
        LIRInstructionClass.visitEach(obj, this.temps, LIRInstruction.OperandMode.TEMP, proc);
    }

    final void visitEachDef(LIRInstruction obj, InstructionValueConsumer proc) {
        LIRInstructionClass.visitEach(obj, this.defs, LIRInstruction.OperandMode.DEF, proc);
    }

    final void forEachState(LIRInstruction obj, InstructionValueProcedure proc) {
        for (int i = 0; i < this.states.getCount(); ++i) {
            LIRFrameState state = (LIRFrameState)this.states.getObject(obj, i);
            if (state == null) continue;
            state.forEachState(obj, proc);
        }
    }

    final void visitEachState(LIRInstruction obj, InstructionValueConsumer proc) {
        for (int i = 0; i < this.states.getCount(); ++i) {
            LIRFrameState state = (LIRFrameState)this.states.getObject(obj, i);
            if (state == null) continue;
            state.visitEachState(obj, proc);
        }
    }

    final void forEachState(LIRInstruction obj, InstructionStateProcedure proc) {
        for (int i = 0; i < this.states.getCount(); ++i) {
            LIRFrameState state = (LIRFrameState)this.states.getObject(obj, i);
            if (state == null) continue;
            proc.doState(obj, state);
        }
    }

    final Value forEachRegisterHint(LIRInstruction obj, LIRInstruction.OperandMode mode, InstructionValueProcedure proc) {
        LIRIntrospection.Values hints;
        if (mode == LIRInstruction.OperandMode.USE) {
            hints = this.defs;
        } else if (mode == LIRInstruction.OperandMode.DEF) {
            hints = this.uses;
        } else {
            return null;
        }
        for (int i = 0; i < hints.getCount(); ++i) {
            if (i < hints.getDirectCount()) {
                Value hintValue = hints.getValue(obj, i);
                Value result = proc.doValue(obj, hintValue, null, null);
                if (result == null) continue;
                return result;
            }
            Value[] hintValues = hints.getValueArray(obj, i);
            for (int j = 0; j < hintValues.length; ++j) {
                Value hintValue = hintValues[j];
                Value result = proc.doValue(obj, hintValue, null, null);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    String toString(LIRInstruction obj) {
        int i;
        StringBuilder result = new StringBuilder();
        LIRInstructionClass.appendValues(result, obj, "", " = ", "(", ")", true, new String[]{""}, this.defs);
        result.append(String.valueOf(this.getOpcode(obj)).toUpperCase(Locale.ROOT));
        LIRInstructionClass.appendValues(result, obj, " ", "", "(", ")", false, new String[]{"", "~"}, this.uses, this.alives);
        LIRInstructionClass.appendValues(result, obj, " ", "", "{", "}", false, new String[]{""}, this.temps);
        for (i = 0; i < this.data.getCount(); ++i) {
            if (i == this.opcodeIndex) continue;
            result.append(" ").append(this.data.getName(i)).append(": ").append(LIRInstructionClass.getFieldString(obj, i, this.data));
        }
        for (i = 0; i < this.states.getCount(); ++i) {
            LIRFrameState state = (LIRFrameState)this.states.getObject(obj, i);
            if (state == null) continue;
            result.append(" ").append(this.states.getName(i)).append(" [bci:");
            String sep = "";
            for (BytecodeFrame cur = state.topFrame; cur != null; cur = cur.caller()) {
                result.append(sep).append(cur.getBCI());
                sep = ", ";
            }
            result.append("]");
        }
        return result.toString();
    }

    final boolean isMoveOp() {
        return this.isMoveOp;
    }

    final boolean isValueMoveOp() {
        return this.isValueMoveOp;
    }

    final boolean isLoadConstantOp() {
        return this.isLoadConstantOp;
    }

    private static class LIRInstructionFieldsScanner
    extends LIRIntrospection.LIRFieldsScanner {
        private String opcodeConstant;
        private FieldsScanner.FieldInfo opcodeField;

        LIRInstructionFieldsScanner(FieldsScanner.CalcOffset calc) {
            super(calc);
            this.valueAnnotations.put(LIRInstruction.Use.class, (Object)new LIRIntrospection.OperandModeAnnotation());
            this.valueAnnotations.put(LIRInstruction.Alive.class, (Object)new LIRIntrospection.OperandModeAnnotation());
            this.valueAnnotations.put(LIRInstruction.Temp.class, (Object)new LIRIntrospection.OperandModeAnnotation());
            this.valueAnnotations.put(LIRInstruction.Def.class, (Object)new LIRIntrospection.OperandModeAnnotation());
        }

        @Override
        protected EnumSet<LIRInstruction.OperandFlag> getFlags(Field field) {
            EnumSet<LIRInstruction.OperandFlag> result = EnumSet.noneOf(LIRInstruction.OperandFlag.class);
            if (field.isAnnotationPresent(LIRInstruction.Use.class)) {
                result.addAll(Arrays.asList(field.getAnnotation(LIRInstruction.Use.class).value()));
            } else if (field.isAnnotationPresent(LIRInstruction.Alive.class)) {
                result.addAll(Arrays.asList(field.getAnnotation(LIRInstruction.Alive.class).value()));
            } else if (field.isAnnotationPresent(LIRInstruction.Temp.class)) {
                result.addAll(Arrays.asList(field.getAnnotation(LIRInstruction.Temp.class).value()));
            } else if (field.isAnnotationPresent(LIRInstruction.Def.class)) {
                result.addAll(Arrays.asList(field.getAnnotation(LIRInstruction.Def.class).value()));
            } else {
                GraalError.shouldNotReachHereUnexpectedValue(field);
            }
            return result;
        }

        public void scan(Class<?> clazz) {
            if (clazz.getAnnotation(Opcode.class) != null) {
                this.opcodeConstant = clazz.getAnnotation(Opcode.class).value();
            }
            this.opcodeField = null;
            super.scan(clazz, LIRInstruction.class, false);
            if (this.opcodeConstant == null && this.opcodeField == null) {
                this.opcodeConstant = clazz.getSimpleName();
                if (this.opcodeConstant.endsWith("Op")) {
                    this.opcodeConstant = this.opcodeConstant.substring(0, this.opcodeConstant.length() - 2);
                }
            }
        }

        @Override
        protected void scanField(Field field, long offset) {
            Class<?> type = field.getType();
            if (STATE_CLASS.isAssignableFrom(type)) {
                assert (this.getOperandModeAnnotation(field) == null) : "Field must not have operand mode annotation: " + String.valueOf(field);
                assert (field.getAnnotation(LIRInstruction.State.class) != null) : "Field must have state annotation: " + String.valueOf(field);
                this.states.add(new FieldsScanner.FieldInfo(offset, field.getName(), type, field.getDeclaringClass()));
            } else {
                super.scanField(field, offset);
            }
            if (field.getAnnotation(Opcode.class) != null) {
                assert (this.opcodeConstant == null && this.opcodeField == null) : "Can have only one Opcode definition: " + String.valueOf(type);
                assert (((FieldsScanner.FieldInfo)this.data.get((int)(this.data.size() - 1))).offset == offset) : Assertions.errorMessage(((FieldsScanner.FieldInfo)this.data.get((int)(this.data.size() - 1))).offset, offset);
                this.opcodeField = (FieldsScanner.FieldInfo)this.data.get(this.data.size() - 1);
            }
        }
    }
}

