/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.lir;

import java.util.ArrayList;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.CodeEmissionOrder;
import jdk.graal.compiler.lir.LIR;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.StandardOp;
import jdk.graal.compiler.lir.gen.LIRGenerationResult;
import jdk.graal.compiler.lir.phases.PostAllocationOptimizationPhase;
import jdk.graal.compiler.options.OptionKey;
import jdk.vm.ci.code.TargetDescription;

public final class ComputeCodeEmissionOrder
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR lir = lirGenRes.getLIR();
        int[] layout = context.blockOrder.computeCodeEmittingOrder(lir.getOptions(), CodeEmissionOrder.ComputationTime.AFTER_CONTROL_FLOW_OPTIMIZATIONS);
        assert (LIR.verifyBlocks(lir, layout)) : "Block layout is not correct " + String.valueOf(layout);
        lir.setCodeEmittingOrder(layout);
        for (int blockId : layout) {
            BasicBlock<?> block = lir.getBlockById(blockId);
            if (!block.isAligned()) continue;
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "first instruction must always be a label";
            StandardOp.LabelOp label = (StandardOp.LabelOp)instructions.get(0);
            label.setAlignment(GraalOptions.LoopHeaderAlignment.getValue(lir.getOptions()));
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> EarlyCodeEmissionOrder = new OptionKey<Boolean>(false);
    }
}

